/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;

public abstract class ExecutableNode
extends Node {
    final LanguageInfo languageInfo;

    protected ExecutableNode(TruffleLanguage<?> language) {
        CompilerAsserts.neverPartOfCompilation();
        if (language != null) {
            this.languageInfo = Node.ACCESSOR.languageSupport().getLanguageInfo(language);
            if (this.languageInfo == null) {
                throw new IllegalArgumentException("Truffle language instance is not initialized.");
            }
        } else {
            this.languageInfo = null;
        }
    }

    public abstract Object execute(VirtualFrame var1);

    public final LanguageInfo getLanguageInfo() {
        return this.languageInfo;
    }

    public final <C extends TruffleLanguage> C getLanguage(Class<C> languageClass) {
        if (this.languageInfo == null) {
            return null;
        }
        TruffleLanguage<?> language = this.languageInfo.getSpi();
        if (!(language.getClass() == languageClass || languageClass.isInstance(language) && languageClass != TruffleLanguage.class && TruffleLanguage.class.isAssignableFrom(languageClass))) {
            CompilerDirectives.transferToInterpreter();
            throw new ClassCastException("Illegal language class specified. Expected " + language.getClass().getName() + ".");
        }
        return (C)((TruffleLanguage)languageClass.cast(language));
    }
}

