/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.JavaFieldDesc;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.SingleFieldDesc;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.WriteFieldNodeGen;
import com.oracle.truffle.api.nodes.Node;

abstract class WriteFieldNode
extends Node {
    static final int LIMIT = 3;
    @Node.Child
    ToJavaNode toJava = ToJavaNode.create();

    WriteFieldNode() {
    }

    static WriteFieldNode create() {
        return WriteFieldNodeGen.create();
    }

    public abstract void execute(JavaFieldDesc var1, JavaObject var2, Object var3);

    @Specialization(guards={"field == cachedField"}, limit="LIMIT")
    void doCached(SingleFieldDesc field, JavaObject object, Object rawValue, @Cached(value="field") SingleFieldDesc cachedField) {
        Object val = this.toJava.execute(rawValue, cachedField.getType(), cachedField.getGenericType(), object.languageContext);
        cachedField.set(object.obj, val);
    }

    @Specialization(replaces={"doCached"})
    void doUncached(SingleFieldDesc field, JavaObject object, Object rawValue) {
        Object val = this.toJava.execute(rawValue, field.getType(), field.getGenericType(), object.languageContext);
        field.set(object.obj, val);
    }
}

