/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.HostEntryRootNode;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.JavaInteropErrors;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.TruffleExecuteNode;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

class TruffleList<T>
extends AbstractList<T> {
    final TruffleObject guestObject;
    final Object languageContext;
    final TruffleListCache cache;

    TruffleList(Class<T> elementClass, Type elementType, TruffleObject array, Object languageContext) {
        this.guestObject = array;
        this.languageContext = languageContext;
        this.cache = TruffleListCache.lookup(languageContext, array.getClass(), elementClass, elementType);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> List<T> create(Object languageContext, TruffleObject array, boolean implementFunction, Class<T> elementClass, Type elementType) {
        if (implementFunction) {
            return new FunctionTruffleList<T>(elementClass, elementType, array, languageContext);
        }
        return new TruffleList<T>(elementClass, elementType, array, languageContext);
    }

    @Override
    public T get(int index) {
        return (T)this.cache.get.call(this.languageContext, this.guestObject, index);
    }

    @Override
    public T set(int index, T element) {
        T prev = this.get(index);
        this.cache.set.call(this.languageContext, this.guestObject, index, element);
        return prev;
    }

    @Override
    public T remove(int index) {
        return (T)this.cache.remove.call(this.languageContext, this.guestObject, index);
    }

    @Override
    public int size() {
        return (Integer)this.cache.size.call(this.languageContext, this.guestObject);
    }

    private static final class TruffleListCache {
        final Class<?> receiverClass;
        final Class<?> valueClass;
        final Type valueType;
        final CallTarget get;
        final CallTarget set;
        final CallTarget remove;
        final CallTarget size;
        final CallTarget apply;

        TruffleListCache(Class<?> receiverClass, Class<?> valueClass, Type valueType) {
            this.receiverClass = receiverClass;
            this.valueClass = valueClass;
            this.valueType = valueType;
            this.get = TruffleListCache.initializeCall(new Get(this));
            this.size = TruffleListCache.initializeCall(new Size(this));
            this.set = TruffleListCache.initializeCall(new Set(this));
            this.remove = TruffleListCache.initializeCall(new Remove(this));
            this.apply = TruffleListCache.initializeCall(new Apply(this));
        }

        private static CallTarget initializeCall(TruffleListNode node) {
            return HostEntryRootNode.createTarget(node);
        }

        static TruffleListCache lookup(Object languageContext, Class<?> receiverClass, Class<?> valueClass, Type valueType) {
            Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
            if (engine == null) {
                return new TruffleListCache(receiverClass, valueClass, valueType);
            }
            Key cacheKey = new Key(receiverClass, valueClass, valueType);
            TruffleListCache cache = engine.lookupJavaInteropCodeCache(languageContext, cacheKey, TruffleListCache.class);
            if (cache == null) {
                cache = engine.installJavaInteropCodeCache(languageContext, cacheKey, new TruffleListCache(receiverClass, valueClass, valueType), TruffleListCache.class);
            }
            assert (cache.receiverClass == receiverClass);
            assert (cache.valueClass == valueClass);
            assert (cache.valueType == valueType);
            return cache;
        }

        private static class Apply
        extends TruffleListNode {
            @Node.Child
            private TruffleExecuteNode apply = new TruffleExecuteNode();

            Apply(TruffleListCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "apply";
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject function, Object[] args, int offset) {
                return this.apply.execute(languageContext, function, args[offset], Object.class, (Type)((Object)Object.class));
            }
        }

        private static class Remove
        extends TruffleListNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private Node remove = Message.REMOVE.createNode();
            @Node.Child
            private ToJavaNode toHost = ToJavaNode.create();
            @Node.Child
            private Node hasSize = Message.HAS_SIZE.createNode();

            Remove(TruffleListCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "remove";
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                assert (key instanceof Integer);
                if (ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    if (KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key))) {
                        try {
                            result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                        }
                        catch (UnknownIdentifierException unknownIdentifierException) {
                        }
                        catch (UnsupportedMessageException unsupportedMessageException) {
                            // empty catch block
                        }
                    }
                    try {
                        ForeignAccess.sendRemove(this.remove, receiver, key);
                    }
                    catch (UnknownIdentifierException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw JavaInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, (Integer)key);
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw JavaInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "remove");
                    }
                    return this.cache.valueClass.cast(result);
                }
                CompilerDirectives.transferToInterpreter();
                throw JavaInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "remove");
            }
        }

        private static class Set
        extends TruffleListNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node write = Message.WRITE.createNode();
            @Node.Child
            private ToJavaNode toHost = ToJavaNode.create();
            @Node.Child
            private Node hasSize = Message.HAS_SIZE.createNode();
            private final BiFunction<Object, Object, Object> toGuest = Set.createToGuestValueNode();

            Set(TruffleListCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "set";
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                assert (key instanceof Integer);
                Object originalValue = args[offset + 1];
                Object value = this.toGuest.apply(languageContext, originalValue);
                if (ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    if (KeyInfo.isWritable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key))) {
                        try {
                            ForeignAccess.sendWrite(this.write, receiver, key, value);
                        }
                        catch (UnknownIdentifierException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw JavaInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, (Integer)key);
                        }
                        catch (UnsupportedMessageException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw JavaInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "set");
                        }
                        catch (UnsupportedTypeException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw JavaInteropErrors.invalidListValue(languageContext, receiver, this.cache.valueType, (Integer)key, value);
                        }
                        return this.cache.valueClass.cast(result);
                    }
                    throw JavaInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "set");
                }
                throw JavaInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "set");
            }
        }

        private static class Get
        extends TruffleListNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private ToJavaNode toHost = ToJavaNode.create();
            @Node.Child
            private Node hasSize = Message.HAS_SIZE.createNode();

            Get(TruffleListCache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "get";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                assert (key instanceof Integer);
                if (ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    if (KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key))) {
                        try {
                            return this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                        }
                        catch (UnknownIdentifierException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw JavaInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, (Integer)key);
                        }
                        catch (UnsupportedMessageException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw JavaInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "get()");
                        }
                    }
                    CompilerDirectives.transferToInterpreter();
                    throw JavaInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, (Integer)key);
                }
                CompilerDirectives.transferToInterpreter();
                throw JavaInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "get()");
            }
        }

        private static class Size
        extends TruffleListNode {
            @Node.Child
            private Node getSize = Message.GET_SIZE.createNode();
            @Node.Child
            private Node hasSize = Message.HAS_SIZE.createNode();

            Size(TruffleListCache cache) {
                super(cache);
            }

            @Override
            protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
                int size = 0;
                if (ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    try {
                        size = ((Number)ForeignAccess.sendGetSize(this.getSize, receiver)).intValue();
                    }
                    catch (UnsupportedMessageException e) {
                        size = 0;
                    }
                }
                return size;
            }

            @Override
            protected String getOperationName() {
                return "size";
            }
        }

        private static abstract class TruffleListNode
        extends HostEntryRootNode<TruffleObject>
        implements Supplier<String> {
            final TruffleListCache cache;

            TruffleListNode(TruffleListCache cache) {
                this.cache = cache;
            }

            @Override
            protected Class<? extends TruffleObject> getReceiverType() {
                return this.cache.receiverClass;
            }

            @Override
            public final String get() {
                return "TruffleList<" + this.cache.receiverClass + ", " + this.cache.valueType + ">." + this.getOperationName();
            }

            protected abstract String getOperationName();
        }

        private static final class Key {
            final Class<?> receiverClass;
            final Class<?> valueClass;
            final Type valueType;

            Key(Class<?> receiverClass, Class<?> valueClass, Type valueType) {
                assert (receiverClass != null);
                this.receiverClass = receiverClass;
                this.valueClass = valueClass;
                this.valueType = valueType;
            }

            public int hashCode() {
                return 31 * (31 * (this.valueType == null ? 0 : this.valueType.hashCode()) + this.receiverClass.hashCode()) + this.valueClass.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.valueType == other.valueType && this.valueClass == other.valueClass && this.receiverClass == other.receiverClass;
            }
        }
    }

    private static class FunctionTruffleList<T>
    extends TruffleList<T>
    implements Function<Object, Object> {
        FunctionTruffleList(Class<T> elementClass, Type elementType, TruffleObject array, Object languageContext) {
            super(elementClass, elementType, array, languageContext);
        }

        @Override
        public Object apply(Object t) {
            return this.cache.apply.call(this.languageContext, this.guestObject, t);
        }
    }
}

