/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.HostEntryRootNode;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.TruffleExecuteNode;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

final class TruffleFunction<T, R>
implements Function<T, R> {
    final TruffleObject guestObject;
    final Object languageContext;
    final CallTarget apply;

    TruffleFunction(Object languageContext, TruffleObject function, Class<?> returnClass, Type returnType) {
        this.guestObject = function;
        this.languageContext = languageContext;
        this.apply = Apply.lookup(languageContext, function.getClass(), returnClass, returnType);
    }

    @Override
    public R apply(T t) {
        return (R)this.apply.call(this.languageContext, this.guestObject, t);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TruffleFunction) {
            return this.guestObject.equals(((TruffleFunction)obj).guestObject);
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.guestObject.hashCode();
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public String toString() {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine != null) {
            try {
                return engine.toHostValue(this.guestObject, this.languageContext).toString();
            }
            catch (UnsupportedOperationException e) {
                return super.toString();
            }
        }
        return super.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> TruffleFunction<?, ?> create(Object languageContext, TruffleObject function, Class<?> returnClass, Type returnType) {
        return new TruffleFunction(languageContext, function, returnClass, returnType);
    }

    static final class Apply
    extends HostEntryRootNode<TruffleObject>
    implements Supplier<String> {
        final Class<?> receiverClass;
        final Class<?> returnClass;
        final Type returnType;
        @Node.Child
        private TruffleExecuteNode apply;

        Apply(Class<?> receiverType, Class<?> returnClass, Type returnType) {
            this.receiverClass = receiverType;
            this.returnClass = returnClass;
            this.returnType = returnType;
        }

        @Override
        protected Class<? extends TruffleObject> getReceiverType() {
            return this.receiverClass;
        }

        @Override
        public String get() {
            return "TruffleFunction<" + this.receiverClass + ", " + this.returnType + ">.apply";
        }

        @Override
        protected Object executeImpl(Object languageContext, TruffleObject function, Object[] args, int offset) {
            if (this.apply == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.apply = this.insert(new TruffleExecuteNode());
            }
            return this.apply.execute(languageContext, function, args[offset], this.returnClass, this.returnType);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Objects.hashCode(this.receiverClass);
            result = 31 * result + Objects.hashCode(this.returnClass);
            result = 31 * result + Objects.hashCode(this.returnType);
            return result;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Apply)) {
                return false;
            }
            Apply other = (Apply)obj;
            return this.receiverClass == other.receiverClass && this.returnType == other.returnType && this.returnClass == other.returnClass;
        }

        private static CallTarget lookup(Object languageContext, Class<?> receiverClass, Class<?> returnClass, Type returnType) {
            Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
            if (engine == null) {
                return Apply.createTarget(new Apply(receiverClass, returnClass, returnType));
            }
            Apply apply = new Apply(receiverClass, returnClass, returnType);
            CallTarget target = engine.lookupJavaInteropCodeCache(languageContext, apply, CallTarget.class);
            if (target == null) {
                target = engine.installJavaInteropCodeCache(languageContext, apply, Apply.createTarget(apply), CallTarget.class);
            }
            return target;
        }
    }
}

