/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.HostEntryRootNode;
import com.oracle.truffle.api.interop.java.JavaInteropErrors;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.reflect.Type;
import java.util.function.BiFunction;

final class TruffleExecuteNode
extends Node {
    private static final Object[] EMPTY = new Object[0];
    @Node.Child
    private Node isExecutable = Message.IS_EXECUTABLE.createNode();
    @Node.Child
    private Node isInstantiable = Message.IS_INSTANTIABLE.createNode();
    @Node.Child
    private Node execute = Message.createExecute(0).createNode();
    @Node.Child
    private Node instantiate = Message.createNew(0).createNode();
    private final BiFunction<Object, Object[], Object[]> toGuests = HostEntryRootNode.createToGuestValuesNode();
    private final ConditionProfile condition = ConditionProfile.createBinaryProfile();
    @Node.Child
    private ToJavaNode toHost = ToJavaNode.create();

    TruffleExecuteNode() {
    }

    public Object execute(Object languageContext, TruffleObject function, Object functionArgsObject, Class<?> resultClass, Type resultType) {
        Object result;
        block8: {
            Object[] argsArray = functionArgsObject instanceof Object[] ? (Object[])functionArgsObject : (functionArgsObject == null ? EMPTY : new Object[]{functionArgsObject});
            Object[] functionArgs = this.toGuests.apply(languageContext, argsArray);
            boolean executable = this.condition.profile(ForeignAccess.sendIsExecutable(this.isExecutable, function));
            try {
                if (executable) {
                    result = ForeignAccess.sendExecute(this.execute, function, functionArgs);
                    break block8;
                }
                if (ForeignAccess.sendIsInstantiable(this.isInstantiable, function)) {
                    result = ForeignAccess.sendNew(this.instantiate, function, functionArgs);
                    break block8;
                }
                CompilerDirectives.transferToInterpreter();
                throw JavaInteropErrors.executeUnsupported(languageContext, function);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreter();
                if (executable) {
                    throw JavaInteropErrors.invalidExecuteArgumentType(languageContext, function, functionArgs);
                }
                throw JavaInteropErrors.invalidInstantiateArgumentType(languageContext, function, functionArgs);
            }
            catch (ArityException e) {
                CompilerDirectives.transferToInterpreter();
                if (executable) {
                    throw JavaInteropErrors.invalidExecuteArity(languageContext, function, functionArgs, e.getExpectedArity(), e.getActualArity());
                }
                throw JavaInteropErrors.invalidInstantiateArity(languageContext, function, functionArgs, e.getExpectedArity(), e.getActualArity());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw JavaInteropErrors.executeUnsupported(languageContext, function);
            }
        }
        return this.toHost.execute(result, resultClass, resultType, languageContext);
    }

    public static TruffleExecuteNode create() {
        return new TruffleExecuteNode();
    }
}

