/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.nodes.Node;

final class ToPrimitiveNode
extends Node {
    private static final double DOUBLE_MAX_SAFE_INTEGER = 9.007199254740991E15;
    private static final long LONG_MAX_SAFE_DOUBLE = 0x1FFFFFFFFFFFFFL;
    private static final float FLOAT_MAX_SAFE_INTEGER = 1.6777215E7f;
    private static final int INT_MAX_SAFE_FLOAT = 0xFFFFFF;
    @Node.Child
    Node isNullNode = Message.IS_NULL.createNode();
    @Node.Child
    Node isBoxedNode = Message.IS_BOXED.createNode();
    @Node.Child
    Node hasKeysNode = Message.HAS_KEYS.createNode();
    @Node.Child
    Node hasSizeNode = Message.HAS_SIZE.createNode();
    @Node.Child
    Node unboxNode = Message.UNBOX.createNode();

    private ToPrimitiveNode() {
    }

    static ToPrimitiveNode create() {
        return new ToPrimitiveNode();
    }

    Integer toInteger(Object value) {
        assert (this.isUnboxed(value));
        return ToPrimitiveNode.toInt(value);
    }

    Object unbox(Object value) {
        if (value instanceof JavaObject) {
            return ((JavaObject)value).obj;
        }
        if (value instanceof TruffleObject) {
            return this.unbox((TruffleObject)value);
        }
        return value;
    }

    Object toPrimitive(Object value, Class<?> requestedType) {
        assert (this.isUnboxed(value));
        Object attr = value;
        if (requestedType == Boolean.TYPE || requestedType == Boolean.class) {
            if (attr instanceof Boolean) {
                Boolean z = (Boolean)attr;
                return z;
            }
        } else {
            if (requestedType == Byte.TYPE || requestedType == Byte.class) {
                return ToPrimitiveNode.toByte(attr);
            }
            if (requestedType == Short.TYPE || requestedType == Short.class) {
                return ToPrimitiveNode.toShort(attr);
            }
            if (requestedType == Integer.TYPE || requestedType == Integer.class) {
                return ToPrimitiveNode.toInt(attr);
            }
            if (requestedType == Long.TYPE || requestedType == Long.class) {
                return ToPrimitiveNode.toLong(attr);
            }
            if (requestedType == Float.TYPE || requestedType == Float.class) {
                return ToPrimitiveNode.toFloat(attr);
            }
            if (requestedType == Double.TYPE || requestedType == Double.class) {
                return ToPrimitiveNode.toDouble(attr);
            }
            if (requestedType == Number.class) {
                if (attr instanceof Number) {
                    Number n = (Number)attr;
                    return n;
                }
            } else if (requestedType == Character.TYPE || requestedType == Character.class) {
                String str;
                if (attr instanceof Character) {
                    Character c = (Character)attr;
                    return c;
                }
                if (attr instanceof String && (str = (String)attr).length() == 1) {
                    return Character.valueOf(str.charAt(0));
                }
            } else if (requestedType == String.class || requestedType == CharSequence.class) {
                if (attr instanceof String) {
                    String str = (String)attr;
                    return str;
                }
                if (attr instanceof Character) {
                    return String.valueOf(((Character)attr).charValue());
                }
            }
        }
        return null;
    }

    private static Object toByte(Object value) {
        double d;
        byte b;
        if (value instanceof Byte) {
            Byte b2 = (Byte)value;
            return b2;
        }
        if (value instanceof Short) {
            short s = (Short)value;
            byte b3 = (byte)s;
            if (b3 == s) {
                return b3;
            }
        } else if (value instanceof Integer) {
            int i = (Integer)value;
            byte b4 = (byte)i;
            if (b4 == i) {
                return b4;
            }
        } else if (value instanceof Long) {
            long l = (Long)value;
            byte b5 = (byte)l;
            if ((long)b5 == l) {
                return b5;
            }
        } else if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            byte b6 = (byte)f;
            if ((float)b6 == f && !ToPrimitiveNode.isNegativeZero(f)) {
                return b6;
            }
        } else if (value instanceof Double && (double)(b = (byte)(d = ((Double)value).doubleValue())) == d && !ToPrimitiveNode.isNegativeZero(d)) {
            return b;
        }
        return null;
    }

    private static Short toShort(Object value) {
        double d;
        short s;
        if (value instanceof Short) {
            Short s2 = (Short)value;
            return s2;
        }
        if (value instanceof Byte) {
            byte b = (Byte)value;
            return b;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            short s3 = (short)i;
            if (s3 == i) {
                return s3;
            }
        } else if (value instanceof Long) {
            long l = (Long)value;
            short s4 = (short)l;
            if ((long)s4 == l) {
                return s4;
            }
        } else if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            short s5 = (short)f;
            if ((float)s5 == f && !ToPrimitiveNode.isNegativeZero(f)) {
                return s5;
            }
        } else if (value instanceof Double && (double)(s = (short)(d = ((Double)value).doubleValue())) == d && !ToPrimitiveNode.isNegativeZero(d)) {
            return s;
        }
        return null;
    }

    private static Integer toInt(Object value) {
        double d;
        int i;
        if (value instanceof Integer) {
            Integer i2 = (Integer)value;
            return i2;
        }
        if (value instanceof Byte) {
            byte b = (Byte)value;
            return b;
        }
        if (value instanceof Short) {
            short s = (Short)value;
            return s;
        }
        if (value instanceof Long) {
            long l = (Long)value;
            int i3 = (int)l;
            if ((long)i3 == l) {
                return i3;
            }
        } else if (value instanceof Float) {
            int i4;
            float f = ((Float)value).floatValue();
            if (ToPrimitiveNode.inSafeIntegerRange(f) && !ToPrimitiveNode.isNegativeZero(f) && (float)(i4 = (int)f) == f) {
                return i4;
            }
        } else if (value instanceof Double && (double)(i = (int)(d = ((Double)value).doubleValue())) == d && !ToPrimitiveNode.isNegativeZero(d)) {
            return i;
        }
        return null;
    }

    private static Object toLong(Object value) {
        long l;
        double d;
        if (value instanceof Long) {
            Long l2 = (Long)value;
            return l2;
        }
        if (value instanceof Byte) {
            byte b = (Byte)value;
            return (long)b;
        }
        if (value instanceof Short) {
            short s = (Short)value;
            return (long)s;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            return (long)i;
        }
        if (value instanceof Float) {
            long l3;
            float f = ((Float)value).floatValue();
            if (ToPrimitiveNode.inSafeIntegerRange(f) && !ToPrimitiveNode.isNegativeZero(f) && (float)(l3 = (long)f) == f) {
                return l3;
            }
        } else if (value instanceof Double && ToPrimitiveNode.inSafeIntegerRange(d = ((Double)value).doubleValue()) && !ToPrimitiveNode.isNegativeZero(d) && (double)(l = (long)d) == d) {
            return l;
        }
        return null;
    }

    private static Object toFloat(Object value) {
        if (value instanceof Float) {
            Float f = (Float)value;
            return f;
        }
        if (value instanceof Byte) {
            byte b = (Byte)value;
            return Float.valueOf(b);
        }
        if (value instanceof Short) {
            short s = (Short)value;
            return Float.valueOf(s);
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            if (ToPrimitiveNode.inSafeFloatRange(i)) {
                return Float.valueOf(i);
            }
        } else if (value instanceof Long) {
            long l = (Long)value;
            if (ToPrimitiveNode.inSafeFloatRange(l)) {
                return Float.valueOf(l);
            }
        } else if (value instanceof Double) {
            double d = (Double)value;
            float f = (float)d;
            if (!Double.isFinite(d) || (double)f == d) {
                return Float.valueOf(f);
            }
        }
        return null;
    }

    private static Object toDouble(Object value) {
        if (value instanceof Double) {
            Double d = (Double)value;
            return d;
        }
        if (value instanceof Byte) {
            byte b = (Byte)value;
            return (double)b;
        }
        if (value instanceof Short) {
            short s = (Short)value;
            return (double)s;
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            return (double)i;
        }
        if (value instanceof Long) {
            long l = (Long)value;
            if (ToPrimitiveNode.inSafeDoubleRange(l)) {
                return (double)l;
            }
        } else if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            double d = f;
            if (!Float.isFinite(f) || d == (double)f) {
                return d;
            }
        }
        return null;
    }

    private static boolean inSafeIntegerRange(double d) {
        return d >= -9.007199254740991E15 && d <= 9.007199254740991E15;
    }

    private static boolean inSafeDoubleRange(long l) {
        return l >= -9007199254740991L && l <= 0x1FFFFFFFFFFFFFL;
    }

    private static boolean inSafeIntegerRange(float f) {
        return f >= -1.6777215E7f && f <= 1.6777215E7f;
    }

    private static boolean inSafeFloatRange(int i) {
        return i >= -16777215 && i <= 0xFFFFFF;
    }

    private static boolean inSafeFloatRange(long l) {
        return l >= -16777215L && l <= 0xFFFFFFL;
    }

    private static boolean isNegativeZero(double d) {
        return d == 0.0 && Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(-0.0);
    }

    private static boolean isNegativeZero(float f) {
        return f == 0.0f && Float.floatToRawIntBits(f) == Float.floatToRawIntBits(-0.0f);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static byte byteValue(Number n) {
        return n.byteValue();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static short shortValue(Number n) {
        return n.shortValue();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static int intValue(Number n) {
        return n.intValue();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static long longValue(Number n) {
        return n.longValue();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static float floatValue(Number n) {
        return n.floatValue();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static double doubleValue(Number n) {
        return n.doubleValue();
    }

    boolean hasKeys(TruffleObject truffleObject) {
        return ForeignAccess.sendHasKeys(this.hasKeysNode, truffleObject);
    }

    boolean hasSize(TruffleObject truffleObject) {
        return ForeignAccess.sendHasSize(this.hasSizeNode, truffleObject);
    }

    boolean isNull(TruffleObject ret) {
        return ForeignAccess.sendIsNull(this.isNullNode, ret);
    }

    Object unbox(TruffleObject value) {
        Object result;
        if (!ForeignAccess.sendIsBoxed(this.isBoxedNode, value)) {
            return null;
        }
        try {
            result = ForeignAccess.sendUnbox(this.unboxNode, value);
        }
        catch (UnsupportedMessageException e) {
            return null;
        }
        if (result instanceof TruffleObject && this.isNull((TruffleObject)result)) {
            return null;
        }
        return result;
    }

    boolean isBoxed(TruffleObject foreignObject) {
        return ForeignAccess.sendIsBoxed(this.isBoxedNode, foreignObject);
    }

    private boolean isUnboxed(Object value) {
        return !(value instanceof JavaObject) && (!(value instanceof TruffleObject) || !this.isBoxed((TruffleObject)value));
    }
}

