/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.JavaInteropErrors;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNodeGen;
import com.oracle.truffle.api.interop.java.ToPrimitiveNode;
import com.oracle.truffle.api.interop.java.TruffleFunction;
import com.oracle.truffle.api.interop.java.TruffleList;
import com.oracle.truffle.api.interop.java.TruffleMap;
import com.oracle.truffle.api.interop.java.TypeAndClass;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.graalvm.polyglot.Value;

abstract class ToJavaNode
extends Node {
    static final int LIMIT = 3;
    static final int STRICT = 0;
    static final int LOOSE = 1;
    static final int COERCE = 2;
    static final int[] PRIORITIES = new int[]{0, 1, 2};
    @Node.Child
    private Node isExecutable = Message.IS_EXECUTABLE.createNode();
    @Node.Child
    private Node isInstantiable = Message.IS_INSTANTIABLE.createNode();
    @Node.Child
    private Node isNull = Message.IS_NULL.createNode();
    @Node.Child
    private Node hasKeysNode = Message.HAS_KEYS.createNode();
    @Node.Child
    private ToPrimitiveNode primitive = ToPrimitiveNode.create();

    ToJavaNode() {
    }

    public abstract Object execute(Object var1, Class<?> var2, Type var3, Object var4);

    @Specialization(guards={"operand == null"})
    protected Object doNull(Object operand, Class<?> targetType, Type genericType, Object languageContext) {
        return null;
    }

    @Specialization(guards={"operand != null", "operand.getClass() == cachedOperandType", "targetType == cachedTargetType"}, limit="LIMIT")
    protected Object doCached(Object operand, Class<?> targetType, Type genericType, Object languageContext, @Cached(value="operand.getClass()") Class<?> cachedOperandType, @Cached(value="targetType") Class<?> cachedTargetType) {
        return this.convertImpl(cachedOperandType.cast(operand), cachedTargetType, genericType, languageContext);
    }

    @Specialization(guards={"operand != null"}, replaces={"doCached"})
    @CompilerDirectives.TruffleBoundary
    protected Object doGeneric(Object operand, Class<?> targetType, Type genericType, Object languageContext) {
        return this.convertImpl(operand, targetType, genericType, languageContext);
    }

    private Object convertImpl(Object value, Class<?> targetType, Type genericType, Object languageContext) {
        Object convertedValue;
        if (ToJavaNode.isAssignableFromTrufflePrimitiveType(targetType)) {
            Object unboxed = this.primitive.unbox(value);
            convertedValue = this.primitive.toPrimitive(unboxed, targetType);
            if (convertedValue != null) {
                return convertedValue;
            }
            if (targetType == Character.TYPE || targetType == Character.class) {
                int v;
                Integer safeChar = this.primitive.toInteger(unboxed);
                if (safeChar != null && (v = safeChar.intValue()) >= 0 && v < 65536) {
                    return Character.valueOf((char)v);
                }
            } else if (targetType == String.class && JavaInterop.isPrimitive(unboxed)) {
                return ToJavaNode.convertToString(unboxed);
            }
        }
        if (targetType == Value.class && languageContext != null) {
            convertedValue = value instanceof Value ? value : JavaInterop.toHostValue(value, languageContext);
        } else if (value instanceof TruffleObject) {
            convertedValue = this.asJavaObject((TruffleObject)value, targetType, genericType, languageContext);
        } else if (targetType.isAssignableFrom(value.getClass())) {
            convertedValue = value;
        } else {
            CompilerDirectives.transferToInterpreter();
            String reason = ToJavaNode.isAssignableFromTrufflePrimitiveType(targetType) ? "Invalid or lossy primitive coercion." : "Unsupported target type.";
            throw JavaInteropErrors.cannotConvert(languageContext, value, targetType, reason);
        }
        return convertedValue;
    }

    boolean canConvertToPrimitive(Object value, Class<?> targetType, int priority) {
        int v;
        Integer safeChar;
        if (JavaObject.isJavaInstance(targetType, value)) {
            return true;
        }
        if (!ToJavaNode.isAssignableFromTrufflePrimitiveType(targetType)) {
            return false;
        }
        Object unboxed = this.primitive.unbox(value);
        Object convertedValue = this.primitive.toPrimitive(unboxed, targetType);
        if (convertedValue != null) {
            return true;
        }
        if (priority <= 0) {
            return false;
        }
        return targetType == Character.TYPE || targetType == Character.class ? (safeChar = this.primitive.toInteger(unboxed)) != null && (v = safeChar.intValue()) >= 0 && v < 65536 : priority >= 2 && targetType == String.class && JavaInterop.isPrimitive(unboxed);
    }

    boolean canConvert(Object value, Class<?> targetType, Type genericType, Object languageContext, int priority) {
        if (this.canConvertToPrimitive(value, targetType, priority)) {
            return true;
        }
        if (priority <= 0) {
            return false;
        }
        if (targetType == Value.class && languageContext != null) {
            return true;
        }
        if (value instanceof TruffleObject) {
            TruffleObject tValue = (TruffleObject)value;
            if (ForeignAccess.sendIsNull(this.isNull, tValue)) {
                return !targetType.isPrimitive();
            }
            if (targetType == Object.class) {
                return true;
            }
            if (JavaObject.isJavaInstance(targetType, tValue)) {
                return true;
            }
            if (this.primitive.isNull(tValue)) {
                return true;
            }
            if (targetType == List.class) {
                return this.primitive.hasSize(tValue);
            }
            if (targetType == Map.class) {
                return this.primitive.hasKeys(tValue);
            }
            if (targetType == Function.class) {
                return this.isExecutable(tValue) || this.isInstantiable(tValue) || TruffleOptions.AOT && ForeignAccess.sendHasKeys(this.hasKeysNode, tValue);
            }
            if (targetType.isArray()) {
                return this.primitive.hasKeys(tValue);
            }
            if (TruffleOptions.AOT) {
                if (targetType == Function.class) {
                    return this.isExecutable(tValue) || this.isInstantiable(tValue);
                }
                return false;
            }
            if (JavaInterop.isJavaFunctionInterface(targetType) && (this.isExecutable(tValue) || this.isInstantiable(tValue))) {
                return true;
            }
            return targetType.isInterface() && ForeignAccess.sendHasKeys(this.hasKeysNode, tValue);
        }
        assert (!(value instanceof TruffleObject));
        return targetType.isInstance(value);
    }

    static boolean isAssignableFromTrufflePrimitiveType(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Character.TYPE || clazz == Character.class || clazz == Number.class || CharSequence.class.isAssignableFrom(clazz);
    }

    private boolean isExecutable(TruffleObject object) {
        return ForeignAccess.sendIsExecutable(this.isExecutable, object);
    }

    private boolean isInstantiable(TruffleObject object) {
        return ForeignAccess.sendIsInstantiable(this.isInstantiable, object);
    }

    private Object convertToObject(TruffleObject truffleObject, Object languageContext) {
        Object primitiveValue = this.primitive.unbox(truffleObject);
        if (primitiveValue != null) {
            return primitiveValue;
        }
        if (languageContext == null) {
            return truffleObject;
        }
        if (this.primitive.hasKeys(truffleObject)) {
            return this.asJavaObject(truffleObject, Map.class, null, languageContext);
        }
        if (this.primitive.hasSize(truffleObject)) {
            return this.asJavaObject(truffleObject, List.class, null, languageContext);
        }
        if (this.isExecutable(truffleObject) || this.isInstantiable(truffleObject)) {
            return this.asJavaObject(truffleObject, Function.class, null, languageContext);
        }
        return JavaInterop.toHostValue(truffleObject, languageContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CompilerDirectives.TruffleBoundary
    private <T> T asJavaObject(TruffleObject truffleObject, Class<T> targetType, Type genericType, Object languageContext) {
        Map obj;
        Objects.requireNonNull(truffleObject);
        if (this.primitive.isNull(truffleObject)) {
            if (!targetType.isPrimitive()) return null;
            throw JavaInteropErrors.nullCoercion(languageContext, truffleObject, targetType);
        }
        if (JavaObject.isJavaInstance(targetType, truffleObject)) {
            obj = JavaObject.valueOf(truffleObject);
        } else if (targetType == Object.class) {
            obj = this.convertToObject(truffleObject, languageContext);
        } else {
            if (languageContext == null && targetType.isInstance(truffleObject)) {
                return targetType.cast(truffleObject);
            }
            if (targetType == List.class) {
                if (!this.primitive.hasSize(truffleObject)) throw JavaInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must have array elements.");
                boolean implementsFunction = this.shouldImplementFunction(truffleObject);
                TypeAndClass<?> elementType = ToJavaNode.getGenericParameterType(genericType, 0);
                obj = TruffleList.create(languageContext, truffleObject, implementsFunction, elementType.clazz, elementType.type);
            } else if (targetType == Map.class) {
                boolean hasKeys;
                Class keyClazz = ToJavaNode.getGenericParameterType((Type)genericType, (int)0).clazz;
                TypeAndClass<?> valueType = ToJavaNode.getGenericParameterType(genericType, 1);
                if (!ToJavaNode.isSupportedMapKeyType(keyClazz)) {
                    throw ToJavaNode.newInvalidKeyTypeException(keyClazz);
                }
                boolean hasSize = Number.class.isAssignableFrom(keyClazz) && this.primitive.hasSize(truffleObject);
                boolean bl = hasKeys = (keyClazz == Object.class || keyClazz == String.class) && this.primitive.hasKeys(truffleObject);
                if (!hasKeys && !hasSize) throw JavaInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must have members or array elements.");
                boolean implementsFunction = this.shouldImplementFunction(truffleObject);
                obj = TruffleMap.create(languageContext, truffleObject, implementsFunction, keyClazz, valueType.clazz, valueType.type);
            } else if (targetType == Function.class) {
                TypeAndClass<?> returnType = ToJavaNode.getGenericParameterType(genericType, 1);
                if (this.isExecutable(truffleObject) || this.isInstantiable(truffleObject)) {
                    obj = TruffleFunction.create(languageContext, truffleObject, returnType.clazz, returnType.type);
                } else {
                    if (TruffleOptions.AOT || !ForeignAccess.sendHasKeys(this.hasKeysNode, truffleObject)) throw JavaInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must be executable or instantiable.");
                    obj = JavaInteropReflect.newProxyInstance(targetType, truffleObject, languageContext);
                }
            } else if (targetType.isArray()) {
                if (!this.primitive.hasSize(truffleObject)) throw JavaInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must have array elements.");
                obj = ToJavaNode.truffleObjectToArray(truffleObject, targetType, genericType, languageContext);
            } else {
                if (TruffleOptions.AOT || !targetType.isInterface()) throw JavaInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Unsupported target type.");
                if (JavaInterop.isJavaFunctionInterface(targetType) && (this.isExecutable(truffleObject) || this.isInstantiable(truffleObject))) {
                    obj = JavaInteropReflect.asJavaFunction(targetType, truffleObject, languageContext);
                } else if (ForeignAccess.sendHasKeys(this.hasKeysNode, truffleObject)) {
                    obj = JavaInteropReflect.newProxyInstance(targetType, truffleObject, languageContext);
                } else {
                    if (languageContext != null) throw JavaInteropErrors.cannotConvert(languageContext, truffleObject, targetType, "Value must have members.");
                    obj = JavaInteropReflect.newProxyInstance(targetType, truffleObject, languageContext);
                }
            }
        }
        assert (targetType.isInstance(obj));
        return targetType.cast(obj);
    }

    private boolean shouldImplementFunction(TruffleObject truffleObject) {
        boolean executable = this.isExecutable(truffleObject);
        boolean instantiable = false;
        if (!executable) {
            instantiable = this.isInstantiable(truffleObject);
        }
        boolean implementsFunction = executable || instantiable;
        return implementsFunction;
    }

    private static boolean isSupportedMapKeyType(Class<?> keyType) {
        return keyType == Object.class || keyType == String.class || keyType == Long.class || keyType == Integer.class || keyType == Number.class;
    }

    @CompilerDirectives.TruffleBoundary
    private static ClassCastException newInvalidKeyTypeException(Type targetType) {
        String message = "Unsupported Map key type: " + targetType;
        return ToJavaNode.newClassCastException(message);
    }

    @CompilerDirectives.TruffleBoundary
    private static ClassCastException newClassCastException(String message) {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        return engine != null ? engine.newClassCastException(message, null) : new ClassCastException(message);
    }

    private static TypeAndClass<?> getGenericParameterType(Type genericType, int index) {
        if (!TruffleOptions.AOT && genericType instanceof ParameterizedType) {
            ParameterizedType parametrizedType = (ParameterizedType)genericType;
            Type[] typeArguments = parametrizedType.getActualTypeArguments();
            Class elementClass = Object.class;
            if (index < typeArguments.length) {
                Type elementType = typeArguments[index];
                if (elementType instanceof ParameterizedType) {
                    elementType = ((ParameterizedType)elementType).getRawType();
                }
                if (elementType instanceof Class) {
                    elementClass = (Class)elementType;
                }
                return new TypeAndClass(typeArguments[index], elementClass);
            }
        }
        return TypeAndClass.ANY;
    }

    private static Type getGenericArrayComponentType(Type genericType) {
        Type genericComponentType = null;
        if (!TruffleOptions.AOT && genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            genericComponentType = genericArrayType.getGenericComponentType();
        }
        return genericComponentType;
    }

    private static Object truffleObjectToArray(TruffleObject foreignObject, Class<?> arrayType, Type genericArrayType, Object languageContext) {
        Class<?> componentType = arrayType.getComponentType();
        List<?> list = TruffleList.create(languageContext, foreignObject, false, componentType, ToJavaNode.getGenericArrayComponentType(genericArrayType));
        Object array = Array.newInstance(componentType, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    @CompilerDirectives.TruffleBoundary
    private static String convertToString(Object value) {
        return value.toString();
    }

    public static ToJavaNode create() {
        return ToJavaNodeGen.create();
    }
}

