/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.ProxyInvokeNode;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ProxyInvokeNode.class)
final class ProxyInvokeNodeGen
extends ProxyInvokeNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @Node.Child
    private CachedMethodData cachedMethod_cache;

    private ProxyInvokeNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public Object execute(Object arg0Value, TruffleObject arg1Value, Method arg2Value, Object[] arg3Value) {
        int state = this.state_;
        if (state != 0) {
            CachedMethodData s1_ = this.cachedMethod_cache;
            while (s1_ != null) {
                if (s1_.cachedMethod_.equals(arg2Value)) {
                    return this.doCachedMethod(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedMethod_, s1_.name_, s1_.returnClass_, s1_.returnType_, s1_.invokeNode_, s1_.keyInfoNode_, s1_.readNode_, s1_.isExecutableNode_, s1_.executeNode_, s1_.branchProfile_, s1_.toJava_, s1_.message_, s1_.messageNode_);
                }
                s1_ = s1_.next_;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    private Object executeAndSpecialize(Object arg0Value, TruffleObject arg1Value, Method arg2Value, Object[] arg3Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        try {
            int count1_ = 0;
            CachedMethodData s1_ = this.cachedMethod_cache;
            if (state != 0) {
                while (s1_ != null && !s1_.cachedMethod_.equals(arg2Value)) {
                    s1_ = s1_.next_;
                    ++count1_;
                }
            }
            if (s1_ == null && count1_ < Integer.MAX_VALUE) {
                s1_ = new CachedMethodData(this.cachedMethod_cache);
                s1_.cachedMethod_ = arg2Value;
                s1_.name_ = arg2Value.getName();
                s1_.returnClass_ = JavaInteropReflect.getMethodReturnType(arg2Value);
                s1_.returnType_ = JavaInteropReflect.getMethodGenericReturnType(arg2Value);
                s1_.invokeNode_ = Message.createInvoke(0).createNode();
                s1_.keyInfoNode_ = Message.KEY_INFO.createNode();
                s1_.readNode_ = Message.READ.createNode();
                s1_.isExecutableNode_ = Message.IS_EXECUTABLE.createNode();
                s1_.executeNode_ = Message.createExecute(0).createNode();
                s1_.branchProfile_ = ConditionProfile.createBinaryProfile();
                s1_.toJava_ = ToJavaNode.create();
                s1_.message_ = ProxyInvokeNode.findMessage(arg2Value);
                s1_.messageNode_ = ProxyInvokeNode.maybeCreateNode(s1_.message_);
                this.cachedMethod_cache = super.insert(s1_);
                this.state_ = state |= 1;
            }
            if (s1_ != null) {
                lock.unlock();
                hasLock = false;
                Object object = this.doCachedMethod(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedMethod_, s1_.name_, s1_.returnClass_, s1_.returnType_, s1_.invokeNode_, s1_.keyInfoNode_, s1_.readNode_, s1_.isExecutableNode_, s1_.executeNode_, s1_.branchProfile_, s1_.toJava_, s1_.message_, s1_.messageNode_);
                return object;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CachedMethodData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cachedMethod_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ProxyInvokeNode create() {
        return new ProxyInvokeNodeGen();
    }

    @GeneratedBy(value=ProxyInvokeNode.class)
    private static final class CachedMethodData
    extends Node {
        @Node.Child
        CachedMethodData next_;
        @CompilerDirectives.CompilationFinal
        Method cachedMethod_;
        @CompilerDirectives.CompilationFinal
        String name_;
        @CompilerDirectives.CompilationFinal
        Class<?> returnClass_;
        @CompilerDirectives.CompilationFinal
        Type returnType_;
        @Node.Child
        Node invokeNode_;
        @Node.Child
        Node keyInfoNode_;
        @Node.Child
        Node readNode_;
        @Node.Child
        Node isExecutableNode_;
        @Node.Child
        Node executeNode_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile branchProfile_;
        @Node.Child
        ToJavaNode toJava_;
        @CompilerDirectives.CompilationFinal
        Message message_;
        @Node.Child
        Node messageNode_;

        CachedMethodData(CachedMethodData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }
}

