/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.HostEntryRootNode;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.ProxyInvokeNode;
import com.oracle.truffle.api.interop.java.ProxyInvokeNodeGen;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class ObjectProxyNode
extends HostEntryRootNode<TruffleObject>
implements Supplier<String> {
    final Class<?> receiverClass;
    final Class<?> interfaceType;
    @Node.Child
    private ProxyInvokeNode proxyInvoke = ProxyInvokeNodeGen.create();
    @CompilerDirectives.CompilationFinal
    private BiFunction<Object, Object[], Object[]> toGuests;

    ObjectProxyNode(Class<?> receiverType, Class<?> interfaceType) {
        this.receiverClass = receiverType;
        this.interfaceType = interfaceType;
    }

    @Override
    protected Class<? extends TruffleObject> getReceiverType() {
        return this.receiverClass;
    }

    @Override
    public final String get() {
        return "InterfaceProxy<" + this.receiverClass + ">";
    }

    @Override
    protected Object executeImpl(Object languageContext, TruffleObject receiver, Object[] args, int offset) {
        if (this.proxyInvoke == null || this.toGuests == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toGuests = ObjectProxyNode.createToGuestValuesNode();
            this.proxyInvoke = ProxyInvokeNodeGen.create();
        }
        Method method = (Method)args[offset];
        Object[] arguments = this.toGuests.apply(languageContext, (Object[])args[offset + 1]);
        return this.proxyInvoke.execute(languageContext, receiver, method, arguments);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.receiverClass);
        result = 31 * result + Objects.hashCode(this.interfaceType);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectProxyNode)) {
            return false;
        }
        ObjectProxyNode other = (ObjectProxyNode)obj;
        return this.receiverClass == other.receiverClass && this.interfaceType == other.interfaceType;
    }

    static CallTarget lookup(Object languageContext, Class<?> receiverClass, Class<?> interfaceClass) {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine == null) {
            return ObjectProxyNode.createTarget(new ObjectProxyNode(receiverClass, interfaceClass));
        }
        ObjectProxyNode node = new ObjectProxyNode(receiverClass, interfaceClass);
        CallTarget target = engine.lookupJavaInteropCodeCache(languageContext, node, CallTarget.class);
        if (target == null) {
            target = engine.installJavaInteropCodeCache(languageContext, node, ObjectProxyNode.createTarget(node), CallTarget.class);
        }
        return target;
    }
}

