/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.LookupMethodNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=LookupMethodNode.class)
final class LookupMethodNodeGen
extends LookupMethodNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;

    private LookupMethodNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public JavaMethodDesc execute(Class<?> arg0Value, String arg1Value, boolean arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (arg2Value == s1_.cachedStatic_ && arg0Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg1Value)) {
                        return LookupMethodNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedMethod_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return LookupMethodNode.doUncached(arg0Value, arg1Value, arg2Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaMethodDesc executeAndSpecialize(Class<?> arg0Value, String arg1Value, boolean arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 1) != 0) {
                    while (!(s1_ == null || arg2Value == s1_.cachedStatic_ && arg0Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg1Value))) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 3) {
                    s1_ = new CachedData(this.cached_cache);
                    s1_.cachedStatic_ = arg2Value;
                    s1_.cachedClazz_ = arg0Value;
                    s1_.cachedName_ = arg1Value;
                    s1_.cachedMethod_ = LookupMethodNode.doUncached(arg0Value, arg1Value, arg2Value);
                    this.cached_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    JavaMethodDesc javaMethodDesc = LookupMethodNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedMethod_);
                    return javaMethodDesc;
                }
            }
            this.exclude_ = exclude |= 1;
            this.cached_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            JavaMethodDesc javaMethodDesc = LookupMethodNode.doUncached(arg0Value, arg1Value, arg2Value);
            return javaMethodDesc;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static LookupMethodNode create() {
        return new LookupMethodNodeGen();
    }

    @GeneratedBy(value=LookupMethodNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        boolean cachedStatic_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClazz_;
        @CompilerDirectives.CompilationFinal
        String cachedName_;
        @CompilerDirectives.CompilationFinal
        JavaMethodDesc cachedMethod_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

