/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.LookupInnerClassNodeGen;
import com.oracle.truffle.api.nodes.Node;

abstract class LookupInnerClassNode
extends Node {
    static final int LIMIT = 3;

    LookupInnerClassNode() {
    }

    static LookupInnerClassNode create() {
        return LookupInnerClassNodeGen.create();
    }

    public abstract Class<?> execute(Class<?> var1, String var2);

    @Specialization(guards={"clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
    static Class<?> doCached(Class<?> clazz, String name, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name)") Class<?> cachedInnerClass) {
        assert (cachedInnerClass == JavaInteropReflect.findInnerClass(clazz, name));
        return cachedInnerClass;
    }

    @Specialization(replaces={"doCached"})
    static Class<?> doUncached(Class<?> clazz, String name) {
        return JavaInteropReflect.findInnerClass(clazz, name);
    }
}

