/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.JavaClassDesc;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.LookupFunctionalMethodNodeGen;
import com.oracle.truffle.api.nodes.Node;

abstract class LookupFunctionalMethodNode
extends Node {
    static final int LIMIT = 3;

    LookupFunctionalMethodNode() {
    }

    static LookupFunctionalMethodNode create() {
        return LookupFunctionalMethodNodeGen.create();
    }

    public abstract JavaMethodDesc execute(Class<?> var1);

    @Specialization(guards={"clazz == cachedClazz"}, limit="LIMIT")
    static JavaMethodDesc doCached(Class<?> clazz, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="doUncached(clazz)") JavaMethodDesc cachedMethod) {
        assert (cachedMethod == LookupFunctionalMethodNode.doUncached(clazz));
        return cachedMethod;
    }

    @Specialization(replaces={"doCached"})
    static JavaMethodDesc doUncached(Class<?> clazz) {
        return JavaClassDesc.forClass(clazz).getFunctionalMethod();
    }
}

