/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.JavaFieldDesc;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.LookupFieldNodeGen;
import com.oracle.truffle.api.nodes.Node;

abstract class LookupFieldNode
extends Node {
    static final int LIMIT = 3;

    LookupFieldNode() {
    }

    static LookupFieldNode create() {
        return LookupFieldNodeGen.create();
    }

    public abstract JavaFieldDesc execute(Class<?> var1, String var2, boolean var3);

    @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
    static JavaFieldDesc doCached(Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name, onlyStatic)") JavaFieldDesc cachedField) {
        assert (cachedField == JavaInteropReflect.findField(clazz, name, onlyStatic));
        return cachedField;
    }

    @Specialization(replaces={"doCached"})
    static JavaFieldDesc doUncached(Class<?> clazz, String name, boolean onlyStatic) {
        return JavaInteropReflect.findField(clazz, name, onlyStatic);
    }
}

