/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.java.KeyInfoCacheNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=KeyInfoCacheNode.class)
final class KeyInfoCacheNodeGen
extends KeyInfoCacheNode {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private CachedData cached_cache;

    private KeyInfoCacheNodeGen() {
    }

    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public int execute(Class<?> arg0Value, String arg1Value, boolean arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (arg2Value == s1_.cachedStatic_ && arg0Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg1Value)) {
                        return KeyInfoCacheNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedKeyInfo_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return KeyInfoCacheNode.doUncached(arg0Value, arg1Value, arg2Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeAndSpecialize(Class<?> arg0Value, String arg1Value, boolean arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (exclude == 0) {
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 1) != 0) {
                    while (!(s1_ == null || arg2Value == s1_.cachedStatic_ && arg0Value == s1_.cachedClazz_ && s1_.cachedName_.equals(arg1Value))) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 3) {
                    s1_ = new CachedData(this.cached_cache);
                    s1_.cachedStatic_ = arg2Value;
                    s1_.cachedClazz_ = arg0Value;
                    s1_.cachedName_ = arg1Value;
                    s1_.cachedKeyInfo_ = KeyInfoCacheNode.doUncached(arg0Value, arg1Value, arg2Value);
                    this.cached_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    int n = KeyInfoCacheNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedStatic_, s1_.cachedClazz_, s1_.cachedName_, s1_.cachedKeyInfo_);
                    return n;
                }
            }
            this.exclude_ = exclude |= 1;
            this.cached_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            int n = KeyInfoCacheNode.doUncached(arg0Value, arg1Value, arg2Value);
            return n;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static KeyInfoCacheNode create() {
        return new KeyInfoCacheNodeGen();
    }

    @GeneratedBy(value=KeyInfoCacheNode.class)
    private static final class CachedData {
        @CompilerDirectives.CompilationFinal
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        boolean cachedStatic_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClazz_;
        @CompilerDirectives.CompilationFinal
        String cachedName_;
        @CompilerDirectives.CompilationFinal
        int cachedKeyInfo_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }
    }
}

