/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaObjectMessageResolutionForeign;

final class JavaObject
implements TruffleObject {
    static final JavaObject NULL = new JavaObject(null, null, false);
    final Object obj;
    final Object languageContext;
    private final boolean staticClass;

    private JavaObject(Object obj, Object languageContext, boolean staticClass) {
        this.obj = obj;
        this.languageContext = languageContext;
        this.staticClass = staticClass;
    }

    static JavaObject forClass(Class<?> clazz, Object languageContext) {
        assert (clazz != null);
        return new JavaObject(clazz, languageContext, false);
    }

    static JavaObject forStaticClass(Class<?> clazz, Object languageContext) {
        assert (clazz != null);
        return new JavaObject(clazz, languageContext, true);
    }

    static JavaObject forObject(Object object, Object languageContext) {
        assert (object != null && !(object instanceof Class));
        return new JavaObject(object, languageContext, false);
    }

    static boolean isInstance(TruffleObject obj) {
        return obj instanceof JavaObject;
    }

    static boolean isJavaInstance(Class<?> targetType, Object javaObject) {
        if (javaObject instanceof JavaObject) {
            Object value = JavaObject.valueOf((JavaObject)javaObject);
            return targetType.isInstance(value);
        }
        return false;
    }

    static Object valueOf(TruffleObject value) {
        JavaObject obj = (JavaObject)value;
        return obj.obj;
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return JavaObjectMessageResolutionForeign.ACCESS;
    }

    public int hashCode() {
        return System.identityHashCode(this.obj);
    }

    boolean isClass() {
        return this.obj instanceof Class;
    }

    boolean isArray() {
        return this.obj != null && this.obj.getClass().isArray();
    }

    boolean isNull() {
        return this.obj == null;
    }

    boolean isStaticClass() {
        return this.staticClass;
    }

    Class<?> getObjectClass() {
        return this.obj == null ? null : this.obj.getClass();
    }

    Class<?> asStaticClass() {
        assert (this.isStaticClass());
        return (Class)this.obj;
    }

    Class<?> asClass() {
        assert (this.isClass());
        return (Class)this.obj;
    }

    Class<?> getLookupClass() {
        if (this.obj == null) {
            return null;
        }
        if (this.isStaticClass()) {
            return this.asStaticClass();
        }
        return this.obj.getClass();
    }

    public boolean equals(Object o) {
        if (o instanceof JavaObject) {
            JavaObject other = (JavaObject)o;
            return this.obj == other.obj && this.languageContext == other.languageContext;
        }
        return false;
    }

    public String toString() {
        if (this.obj == null) {
            return "null";
        }
        if (this.isClass()) {
            return "JavaClass[" + this.asClass().getTypeName() + "]";
        }
        return "JavaObject[" + this.obj + " (" + this.getObjectClass().getTypeName() + ")]";
    }
}

