/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import java.lang.reflect.Type;
import java.util.Arrays;

class JavaInteropErrors {
    JavaInteropErrors() {
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException nullCoercion(Object languageContext, TruffleObject nullValue, Type targetType) {
        return JavaInteropErrors.newNullPointerException(String.format("Cannot convert null value %s to Java type '%s'.", JavaInteropErrors.getValueInfo(languageContext, nullValue), targetType.getTypeName()));
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException cannotConvert(Object languageContext, Object value, Type targetType, String reason) {
        return JavaInteropErrors.newClassCastException(String.format("Cannot convert %s to Java type '%s': %s", JavaInteropErrors.getValueInfo(languageContext, value), targetType.getTypeName(), reason));
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invalidListIndex(Object context, Object receiver, Type componentType, int index) {
        String message = String.format("Invalid index %s for List<%s> %s.", index, JavaInteropErrors.formatComponentType(componentType), JavaInteropErrors.getValueInfo(context, receiver));
        throw JavaInteropErrors.newArrayIndexOutOfBounds(message);
    }

    private static Object formatComponentType(Type componentType) {
        return componentType == null || componentType == Object.class ? "Object" : componentType.getTypeName();
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException listUnsupported(Object context, Object receiver, Type componentType, String operation) {
        String message = String.format("Unsupported operation %s for List<%s> %s.", operation, JavaInteropErrors.formatComponentType(componentType), JavaInteropErrors.getValueInfo(context, receiver));
        throw JavaInteropErrors.newUnsupportedOperationException(message);
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException mapUnsupported(Object context, Object receiver, Type keyType, Type valueType, String operation) {
        String message = String.format("Unsupported operation %s for Map<%s, %s> %s.", operation, JavaInteropErrors.formatComponentType(keyType), JavaInteropErrors.formatComponentType(valueType), JavaInteropErrors.getValueInfo(context, receiver));
        throw JavaInteropErrors.newUnsupportedOperationException(message);
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invalidMapValue(Object context, Object receiver, Type keyType, Type valueType, Object identifier, Object value) {
        throw JavaInteropErrors.newClassCastException(String.format("Invalid value %s for Map<%s, %s> %s and identifier '%s'.", JavaInteropErrors.getValueInfo(context, value), JavaInteropErrors.formatComponentType(keyType), JavaInteropErrors.formatComponentType(valueType), JavaInteropErrors.getValueInfo(context, receiver), identifier));
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invalidMapIdentifier(Object context, Object receiver, Type keyType, Type valueType, Object identifier) {
        if (identifier instanceof Number || identifier instanceof String) {
            throw JavaInteropErrors.newIllegalArgumentException(String.format("Invalid or unmodifiable value for identifier '%s' for Map<%s, %s> %s.", identifier, JavaInteropErrors.formatComponentType(keyType), JavaInteropErrors.formatComponentType(valueType), JavaInteropErrors.getValueInfo(context, receiver)));
        }
        throw JavaInteropErrors.newIllegalArgumentException(String.format("Illegal identifier type '%s' for Map<%s, %s> %s.", identifier == null ? "null" : identifier.getClass().getTypeName(), JavaInteropErrors.formatComponentType(keyType), JavaInteropErrors.formatComponentType(valueType), JavaInteropErrors.getValueInfo(context, receiver)));
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invalidListValue(Object context, Object receiver, Type componentType, int identifier, Object value) {
        throw JavaInteropErrors.newClassCastException(String.format("Invalid value %s for List<%s> %s and index %s.", JavaInteropErrors.getValueInfo(context, value), JavaInteropErrors.formatComponentType(componentType), JavaInteropErrors.getValueInfo(context, receiver), identifier));
    }

    static RuntimeException invalidExecuteInvalidIdentifier(Object context, Object receiver, Object[] arguments) {
        String[] formattedArgs = JavaInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument when executing %s with arguments %s.", JavaInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw JavaInteropErrors.newIllegalArgumentException(message);
    }

    static RuntimeException invalidExecuteArgumentType(Object context, Object receiver, Object[] arguments) {
        String[] formattedArgs = JavaInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument when executing %s with arguments %s.", JavaInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw JavaInteropErrors.newIllegalArgumentException(message);
    }

    static RuntimeException invalidInstantiateArgumentType(Object context, Object receiver, Object[] arguments) {
        String[] formattedArgs = JavaInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument when instantiating %s with arguments %s.", JavaInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw JavaInteropErrors.newIllegalArgumentException(message);
    }

    static RuntimeException invalidInstantiateArity(Object context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = JavaInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when instantiating %s with arguments %s. Expected %s argument(s) but got %s.", JavaInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw JavaInteropErrors.newIllegalArgumentException(message);
    }

    static RuntimeException invalidExecuteArity(Object context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = JavaInteropErrors.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when executing %s with arguments %s. Expected %s argument(s) but got %s.", JavaInteropErrors.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw JavaInteropErrors.newIllegalArgumentException(message);
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invokeUnsupported(Object context, Object receiver, String identifier) {
        String message = String.format("Unsupported operation identifier '%s' and  object %s. Identifier is not executable or instantiable.", identifier, JavaInteropErrors.getValueInfo(context, receiver));
        throw JavaInteropErrors.newUnsupportedOperationException(message);
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException executeUnsupported(Object context, Object receiver) {
        String message = String.format("Unsupported operation for object %s. Object is not executable or instantiable.", JavaInteropErrors.getValueInfo(context, receiver));
        throw JavaInteropErrors.newUnsupportedOperationException(message);
    }

    private static String[] formatArgs(Object context, Object[] arguments) {
        String[] formattedArgs = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            formattedArgs[i] = JavaInteropErrors.getValueInfo(context, arguments[i]);
        }
        return formattedArgs;
    }

    static String getValueInfo(Object languageContext, Object value) {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine == null) {
            return value.toString();
        }
        return engine.getValueInfo(languageContext, value);
    }

    private static RuntimeException newNullPointerException(String message) {
        CompilerDirectives.transferToInterpreter();
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        return engine != null ? engine.newNullPointerException(message, null) : new NullPointerException(message);
    }

    private static RuntimeException newUnsupportedOperationException(String message) {
        CompilerDirectives.transferToInterpreter();
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        return engine != null ? engine.newUnsupportedOperationException(message, null) : new UnsupportedOperationException(message);
    }

    private static RuntimeException newClassCastException(String message) {
        CompilerDirectives.transferToInterpreter();
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        return engine != null ? engine.newClassCastException(message, null) : new ClassCastException(message);
    }

    static final RuntimeException newIllegalArgumentException(String message) {
        CompilerDirectives.transferToInterpreter();
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        return engine != null ? engine.newIllegalArgumentException(message, null) : new IllegalArgumentException(message);
    }

    private static RuntimeException newArrayIndexOutOfBounds(String message) {
        CompilerDirectives.transferToInterpreter();
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        return engine != null ? engine.newArrayIndexOutOfBounds(message, null) : new ArrayIndexOutOfBoundsException(message);
    }
}

