/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.java.JavaFieldDesc;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.interop.java.OverloadedMethodDesc;
import com.oracle.truffle.api.interop.java.SingleFieldDesc;
import com.oracle.truffle.api.interop.java.SingleMethodDesc;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

final class JavaClassDesc {
    private static final ClassValue<JavaClassDesc> CACHED_DESCS = new ClassValue<JavaClassDesc>(){

        @Override
        protected JavaClassDesc computeValue(Class<?> type) {
            return new JavaClassDesc(type);
        }
    };
    private final Class<?> type;
    private volatile Members members;
    private volatile JNIMembers jniMembers;

    @CompilerDirectives.TruffleBoundary
    static JavaClassDesc forClass(Class<?> clazz) {
        return CACHED_DESCS.get(clazz);
    }

    JavaClassDesc(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    static boolean isObjectMethodOverride(Method m) {
        return m.getParameterCount() == 0 && (m.getName().equals("hashCode") || m.getName().equals("toString")) || m.getParameterCount() == 1 && m.getName().equals("equals") && m.getParameterTypes()[0] == Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Members getMembers() {
        Members m = this.members;
        if (m == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            JavaClassDesc javaClassDesc = this;
            synchronized (javaClassDesc) {
                m = this.members;
                if (m == null) {
                    this.members = m = new Members(this.type);
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JNIMembers getJNIMembers() {
        JNIMembers m = this.jniMembers;
        if (m == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            JavaClassDesc javaClassDesc = this;
            synchronized (javaClassDesc) {
                m = this.jniMembers;
                if (m == null) {
                    this.jniMembers = m = new JNIMembers(this.getMembers());
                }
            }
        }
        return m;
    }

    public JavaMethodDesc lookupMethod(String name) {
        return this.getMembers().methods.get(name);
    }

    public JavaMethodDesc lookupStaticMethod(String name) {
        return this.getMembers().staticMethods.get(name);
    }

    public JavaMethodDesc lookupMethod(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticMethod(name) : this.lookupMethod(name);
    }

    public JavaMethodDesc lookupMethodByJNIName(String jniName, boolean onlyStatic) {
        return onlyStatic ? this.getJNIMembers().staticMethods.get(jniName) : this.getJNIMembers().methods.get(jniName);
    }

    public Collection<String> getMethodNames(boolean onlyStatic, boolean includeInternal) {
        Map<String, JavaMethodDesc> methods;
        Map<String, JavaMethodDesc> map = methods = onlyStatic ? this.getMembers().staticMethods : this.getMembers().methods;
        if (includeInternal || onlyStatic) {
            return Collections.unmodifiableCollection(methods.keySet());
        }
        ArrayList<String> methodNames = new ArrayList<String>(methods.size());
        for (Map.Entry<String, JavaMethodDesc> entry : methods.entrySet()) {
            if (entry.getValue().isInternal()) continue;
            methodNames.add(entry.getKey());
        }
        return methodNames;
    }

    public Collection<String> getJNIMethodNames(boolean onlyStatic) {
        return Collections.unmodifiableCollection((onlyStatic ? this.getJNIMembers().staticMethods : this.getJNIMembers().methods).keySet());
    }

    public JavaMethodDesc lookupConstructor() {
        return this.getMembers().constructor;
    }

    public JavaFieldDesc lookupField(String name) {
        return this.getMembers().fields.get(name);
    }

    public JavaFieldDesc lookupStaticField(String name) {
        return this.getMembers().staticFields.get(name);
    }

    public JavaFieldDesc lookupField(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticField(name) : this.lookupField(name);
    }

    public Collection<String> getFieldNames(boolean onlyStatic) {
        return Collections.unmodifiableCollection((onlyStatic ? this.getMembers().staticFields : this.getMembers().fields).keySet());
    }

    public JavaMethodDesc getFunctionalMethod() {
        return this.getMembers().functionalMethod;
    }

    public String toString() {
        return "JavaClass[" + this.type.getCanonicalName() + "]";
    }

    private static class JNIMembers {
        final Map<String, JavaMethodDesc> methods;
        final Map<String, JavaMethodDesc> staticMethods;

        JNIMembers(Members members) {
            this.methods = JNIMembers.collectJNINamedMethods(members.methods);
            this.staticMethods = JNIMembers.collectJNINamedMethods(members.staticMethods);
        }

        private static Map<String, JavaMethodDesc> collectJNINamedMethods(Map<String, JavaMethodDesc> methods) {
            LinkedHashMap<String, JavaMethodDesc> jniMethods = new LinkedHashMap<String, JavaMethodDesc>();
            for (JavaMethodDesc method : methods.values()) {
                if (method.isConstructor()) continue;
                for (JavaMethodDesc m : method.getOverloads()) {
                    assert (m.isMethod());
                    jniMethods.put(JavaInteropReflect.jniName((Method)((SingleMethodDesc)m).getReflectionMethod()), m);
                }
            }
            return jniMethods;
        }
    }

    private static class Members {
        final Map<String, JavaMethodDesc> methods;
        final Map<String, JavaMethodDesc> staticMethods;
        final JavaMethodDesc constructor;
        final Map<String, JavaFieldDesc> fields;
        final Map<String, JavaFieldDesc> staticFields;
        final JavaMethodDesc functionalMethod;
        private static final BiFunction<JavaMethodDesc, JavaMethodDesc, JavaMethodDesc> MERGE = new BiFunction<JavaMethodDesc, JavaMethodDesc, JavaMethodDesc>(){

            @Override
            public JavaMethodDesc apply(JavaMethodDesc m1, JavaMethodDesc m2) {
                return Members.merge(m1, m2);
            }
        };

        Members(Class<?> type) {
            String functionalInterfaceMethodName;
            LinkedHashMap<String, JavaMethodDesc> methodMap = new LinkedHashMap<String, JavaMethodDesc>();
            LinkedHashMap<String, JavaMethodDesc> staticMethodMap = new LinkedHashMap<String, JavaMethodDesc>();
            LinkedHashMap<String, JavaFieldDesc> fieldMap = new LinkedHashMap<String, JavaFieldDesc>();
            LinkedHashMap<String, JavaFieldDesc> staticFieldMap = new LinkedHashMap<String, JavaFieldDesc>();
            SingleMethodDesc ctor = null;
            JavaMethodDesc functionalInterfaceMethod = null;
            Members.collectPublicMethods(type, methodMap, staticMethodMap);
            if (Modifier.isPublic(type.getModifiers())) {
                boolean inheritedPublicInstanceFields = false;
                boolean inheritedPublicInaccessibleFields = false;
                for (Field f : type.getFields()) {
                    if (!Modifier.isStatic(f.getModifiers())) {
                        if (f.getDeclaringClass() == type) {
                            assert (!fieldMap.containsKey(f.getName()));
                            fieldMap.put(f.getName(), SingleFieldDesc.unreflect(f));
                            continue;
                        }
                        if (Modifier.isPublic(f.getDeclaringClass().getModifiers())) {
                            inheritedPublicInstanceFields = true;
                            continue;
                        }
                        inheritedPublicInaccessibleFields = true;
                        continue;
                    }
                    if (f.getDeclaringClass() != type) continue;
                    staticFieldMap.put(f.getName(), SingleFieldDesc.unreflect(f));
                }
                if (inheritedPublicInstanceFields) {
                    Members.collectPublicInstanceFields(type, fieldMap, inheritedPublicInaccessibleFields);
                }
            } else if (!Modifier.isInterface(type.getModifiers())) {
                Members.collectPublicInstanceFields(type, fieldMap, true);
            }
            if (Modifier.isPublic(type.getModifiers())) {
                for (Constructor<?> c : type.getConstructors()) {
                    SingleMethodDesc overload = SingleMethodDesc.unreflect(c);
                    ctor = ctor == null ? overload : Members.merge(ctor, overload);
                }
            }
            if (!Modifier.isInterface(type.getModifiers()) && !Modifier.isAbstract(type.getModifiers()) && (functionalInterfaceMethodName = Members.findFunctionalInterfaceMethodName(type)) != null) {
                functionalInterfaceMethod = (JavaMethodDesc)methodMap.get(functionalInterfaceMethodName);
                assert (functionalInterfaceMethod != null);
            }
            this.methods = methodMap;
            this.staticMethods = staticMethodMap;
            this.constructor = ctor;
            this.fields = fieldMap;
            this.staticFields = staticFieldMap;
            this.functionalMethod = functionalInterfaceMethod;
        }

        private static void collectPublicMethods(Class<?> type, Map<String, JavaMethodDesc> methodMap, Map<String, JavaMethodDesc> staticMethodMap) {
            Members.collectPublicMethods(type, methodMap, staticMethodMap, new HashSet<Object>(), type);
        }

        private static void collectPublicMethods(Class<?> type, Map<String, JavaMethodDesc> methodMap, Map<String, JavaMethodDesc> staticMethodMap, Set<Object> visited, Class<?> startType) {
            boolean isPublicType = Modifier.isPublic(type.getModifiers()) && !Proxy.isProxyClass(type);
            boolean allMethodsPublic = true;
            if (isPublicType) {
                for (GenericDeclaration genericDeclaration : type.getMethods()) {
                    if (!Modifier.isPublic(((Method)genericDeclaration).getDeclaringClass().getModifiers())) {
                        allMethodsPublic = false;
                        continue;
                    }
                    if (Modifier.isStatic(((Method)genericDeclaration).getModifiers()) && ((Method)genericDeclaration).getDeclaringClass() != startType && Modifier.isInterface(((Method)genericDeclaration).getDeclaringClass().getModifiers()) || !visited.add(Members.methodInfo((Method)genericDeclaration))) continue;
                    Members.putMethod((Method)genericDeclaration, methodMap, staticMethodMap);
                }
            }
            if (!isPublicType || !allMethodsPublic) {
                if (type.getSuperclass() != null) {
                    Members.collectPublicMethods(type.getSuperclass(), methodMap, staticMethodMap, visited, startType);
                }
                for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                    if (!visited.add(genericDeclaration)) continue;
                    Members.collectPublicMethods(genericDeclaration, methodMap, staticMethodMap, visited, startType);
                }
            }
        }

        private static Object methodInfo(Method m) {
            class MethodInfo {
                private final String name;
                private final Class<?>[] parameterTypes;
                final /* synthetic */ Method val$m;

                MethodInfo(Method method) {
                    this.val$m = method;
                    this.name = this.val$m.getName();
                    this.parameterTypes = this.val$m.getParameterTypes();
                }

                public boolean equals(Object obj) {
                    return obj instanceof MethodInfo && this.name.equals(((MethodInfo)obj).name) && Arrays.equals(this.parameterTypes, ((MethodInfo)obj).parameterTypes);
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + this.name.hashCode();
                    result = 31 * result + Arrays.hashCode(this.parameterTypes);
                    return result;
                }
            }
            return new MethodInfo(m);
        }

        private static void putMethod(Method m, Map<String, JavaMethodDesc> methodMap, Map<String, JavaMethodDesc> staticMethodMap) {
            SingleMethodDesc method = SingleMethodDesc.unreflect(m);
            Map<String, JavaMethodDesc> map = Modifier.isStatic(m.getModifiers()) ? staticMethodMap : methodMap;
            map.merge(m.getName(), method, MERGE);
        }

        static JavaMethodDesc merge(JavaMethodDesc existing, JavaMethodDesc other) {
            assert (other instanceof SingleMethodDesc);
            if (existing instanceof SingleMethodDesc) {
                return new OverloadedMethodDesc(new SingleMethodDesc[]{(SingleMethodDesc)existing, (SingleMethodDesc)other});
            }
            SingleMethodDesc[] oldOverloads = ((OverloadedMethodDesc)existing).getOverloads();
            SingleMethodDesc[] newOverloads = Arrays.copyOf(oldOverloads, oldOverloads.length + 1);
            newOverloads[oldOverloads.length] = (SingleMethodDesc)other;
            return new OverloadedMethodDesc(newOverloads);
        }

        private static void collectPublicInstanceFields(Class<?> type, Map<String, JavaFieldDesc> fieldMap, boolean mayHaveInaccessibleFields) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (Class<?> superclass = type; superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                boolean inheritedPublicInstanceFields = false;
                for (Field f : superclass.getFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    if (f.getDeclaringClass() != superclass) {
                        if (!Modifier.isPublic(f.getDeclaringClass().getModifiers())) continue;
                        inheritedPublicInstanceFields = true;
                        continue;
                    }
                    if (mayHaveInaccessibleFields && !fieldNames.add(f.getName())) continue;
                    if (Modifier.isPublic(f.getDeclaringClass().getModifiers())) {
                        fieldMap.putIfAbsent(f.getName(), SingleFieldDesc.unreflect(f));
                        continue;
                    }
                    assert (mayHaveInaccessibleFields);
                }
                if (!inheritedPublicInstanceFields) break;
            }
        }

        private static String findFunctionalInterfaceMethodName(Class<?> clazz) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!Modifier.isPublic(iface.getModifiers()) || !iface.isAnnotationPresent(FunctionalInterface.class)) continue;
                for (Method m : iface.getMethods()) {
                    if (!Modifier.isAbstract(m.getModifiers()) || JavaClassDesc.isObjectMethodOverride(m)) continue;
                    return m.getName();
                }
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return Members.findFunctionalInterfaceMethodName(superclass);
            }
            return null;
        }
    }
}

