/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.java.IsApplicableByArityNodeGen;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaMethodDesc;
import com.oracle.truffle.api.nodes.Node;

abstract class IsApplicableByArityNode
extends Node {
    static final int LIMIT = 3;

    IsApplicableByArityNode() {
    }

    static IsApplicableByArityNode create() {
        return IsApplicableByArityNodeGen.create();
    }

    public abstract boolean execute(JavaMethodDesc var1, int var2);

    @Specialization(guards={"argsLength == cachedArgsLength"}, limit="LIMIT")
    static boolean doCached(JavaMethodDesc method, int argsLength, @Cached(value="argsLength") int cachedArgsLength, @Cached(value="doUncached(method, argsLength)") boolean applicableByArity) {
        assert (applicableByArity == JavaInteropReflect.isApplicableByArity(method, argsLength));
        return applicableByArity;
    }

    @Specialization(replaces={"doCached"})
    static boolean doUncached(JavaMethodDesc method, int argsLength) {
        return JavaInteropReflect.isApplicableByArity(method, argsLength);
    }
}

