/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.function.BiFunction;
import java.util.function.Supplier;

abstract class HostEntryRootNode<T>
extends ExecutableNode
implements Supplier<String> {
    HostEntryRootNode() {
        super(null);
    }

    protected abstract Class<? extends T> getReceiverType();

    @Override
    public final Object execute(VirtualFrame frame) {
        Object[] arguments = frame.getArguments();
        Object languageContext = arguments[0];
        T receiver = this.getReceiverType().cast(arguments[1]);
        Object result = this.executeImpl(languageContext, receiver, arguments, 2);
        assert (languageContext == null || !(result instanceof TruffleObject));
        return result;
    }

    protected abstract Object executeImpl(Object var1, T var2, Object[] var3, int var4);

    protected static CallTarget createTarget(final HostEntryRootNode<?> node) {
        Accessor.EngineSupport support = JavaInteropAccessor.ACCESSOR.engine();
        if (support == null) {
            return Truffle.getRuntime().createCallTarget(new RootNode(null){

                @Override
                public Object execute(VirtualFrame frame) {
                    return node.execute(frame);
                }
            });
        }
        return Truffle.getRuntime().createCallTarget(support.wrapHostBoundary(node, node));
    }

    protected static BiFunction<Object, Object, Object> createToGuestValueNode() {
        Accessor.EngineSupport support = JavaInteropAccessor.ACCESSOR.engine();
        if (support == null) {
            return new BiFunction<Object, Object, Object>(){

                @Override
                public Object apply(Object context, Object value) {
                    return HostEntryRootNode.asTruffleValue(value, context);
                }
            };
        }
        return support.createToGuestValueNode();
    }

    protected static BiFunction<Object, Object[], Object[]> createToGuestValuesNode() {
        Accessor.EngineSupport support = JavaInteropAccessor.ACCESSOR.engine();
        if (support == null) {
            return new BiFunction<Object, Object[], Object[]>(){

                @Override
                public Object[] apply(Object context, Object[] values) {
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = HostEntryRootNode.asTruffleValue(values[i], context);
                    }
                    return values;
                }
            };
        }
        return support.createToGuestValuesNode();
    }

    static Object asTruffleValue(Object obj, Object languageContext) {
        return JavaInterop.isPrimitive(obj) ? obj : JavaInterop.asTruffleObject(obj, languageContext);
    }
}

