/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.HostEntryRootNode;
import com.oracle.truffle.api.interop.java.JavaInteropAccessor;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.TruffleExecuteNode;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;

class FunctionProxyNode
extends HostEntryRootNode<TruffleObject>
implements Supplier<String> {
    final Class<?> receiverClass;
    final Method method;
    @Node.Child
    private TruffleExecuteNode executeNode;
    @CompilerDirectives.CompilationFinal
    private Class<?> returnClass;
    @CompilerDirectives.CompilationFinal
    private Type returnType;

    FunctionProxyNode(Class<?> receiverType, Method method) {
        this.receiverClass = receiverType;
        this.method = method;
    }

    @Override
    protected Class<? extends TruffleObject> getReceiverType() {
        return this.receiverClass;
    }

    @Override
    public final String get() {
        return "FunctionalInterfaceProxy<" + this.receiverClass + ", " + this.method + ">";
    }

    @Override
    protected Object executeImpl(Object languageContext, TruffleObject function, Object[] args, int offset) {
        if (this.executeNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.returnClass = JavaInteropReflect.getMethodReturnType(this.method);
            this.returnType = JavaInteropReflect.getMethodGenericReturnType(this.method);
            this.executeNode = this.insert(new TruffleExecuteNode());
        }
        return this.executeNode.execute(languageContext, function, args[offset], this.returnClass, this.returnType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.receiverClass);
        result = 31 * result + Objects.hashCode(this.method);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionProxyNode)) {
            return false;
        }
        FunctionProxyNode other = (FunctionProxyNode)obj;
        return this.receiverClass == other.receiverClass && this.method.equals(other.method);
    }

    static CallTarget lookup(Object languageContext, Class<?> receiverClass, Method method) {
        Accessor.EngineSupport engine = JavaInteropAccessor.ACCESSOR.engine();
        if (engine == null) {
            return FunctionProxyNode.createTarget(new FunctionProxyNode(receiverClass, method));
        }
        FunctionProxyNode node = new FunctionProxyNode(receiverClass, method);
        CallTarget target = engine.lookupJavaInteropCodeCache(languageContext, node, CallTarget.class);
        if (target == null) {
            target = engine.installJavaInteropCodeCache(languageContext, node, FunctionProxyNode.createTarget(node), CallTarget.class);
        }
        return target;
    }
}

