/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.ArrayWriteNodeGen;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Array;
import java.util.List;

abstract class ArrayWriteNode
extends Node {
    @Node.Child
    private ToJavaNode toJavaNode = ToJavaNode.create();

    ArrayWriteNode() {
    }

    protected abstract Object executeWithTarget(JavaObject var1, Object var2, Object var3);

    @Specialization(guards={"receiver.isArray()"})
    protected final Object doArrayIntIndex(JavaObject receiver, int index, Object value) {
        return this.doArrayAccess(receiver, index, value);
    }

    @Specialization(guards={"receiver.isArray()", "index.getClass() == clazz"})
    protected final Object doArrayCached(JavaObject receiver, Number index, Object value, @Cached(value="index.getClass()") Class<? extends Number> clazz) {
        return this.doArrayAccess(receiver, clazz.cast(index).intValue(), value);
    }

    @Specialization(guards={"receiver.isArray()"}, replaces={"doArrayCached"})
    protected final Object doArrayGeneric(JavaObject receiver, Number index, Object value) {
        return this.doArrayAccess(receiver, index.intValue(), value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isList(receiver)"})
    protected Object doListIntIndex(JavaObject receiver, int index, Object value) {
        Object javaValue = this.toJavaNode.execute(value, Object.class, null, receiver.languageContext);
        try {
            List list = (List)receiver.obj;
            if (index == list.size()) {
                list.add(javaValue);
            } else {
                list.set(index, javaValue);
            }
            return value;
        }
        catch (IndexOutOfBoundsException e) {
            CompilerDirectives.transferToInterpreter();
            throw UnknownIdentifierException.raise(String.valueOf(index));
        }
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isList(receiver)"}, replaces={"doListIntIndex"})
    protected Object doListGeneric(JavaObject receiver, Number index, Object value) {
        return this.doListIntIndex(receiver, index.intValue(), value);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!receiver.isArray()", "!isList(receiver)"})
    protected static Object notArray(JavaObject receiver, Number index, Object value) {
        throw UnsupportedMessageException.raise(Message.WRITE);
    }

    private Object doArrayAccess(JavaObject receiver, int index, Object value) {
        Object obj = receiver.obj;
        assert (receiver.isArray());
        Object javaValue = this.toJavaNode.execute(value, obj.getClass().getComponentType(), null, receiver.languageContext);
        try {
            Array.set(obj, index, javaValue);
        }
        catch (ArrayIndexOutOfBoundsException outOfBounds) {
            CompilerDirectives.transferToInterpreter();
            throw UnknownIdentifierException.raise(String.valueOf(index));
        }
        return JavaObject.NULL;
    }

    static boolean isList(JavaObject receiver) {
        return receiver.obj instanceof List;
    }

    static ArrayWriteNode create() {
        return ArrayWriteNodeGen.create();
    }
}

