/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.java.ArrayRemoveNodeGen;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

abstract class ArrayRemoveNode
extends Node {
    ArrayRemoveNode() {
    }

    protected abstract boolean executeWithTarget(JavaObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isList(receiver)"})
    protected boolean doListIntIndex(JavaObject receiver, int index) {
        try {
            ((List)receiver.obj).remove(index);
        }
        catch (IndexOutOfBoundsException outOfBounds) {
            throw UnknownIdentifierException.raise(String.valueOf(index));
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isList(receiver)"}, replaces={"doListIntIndex"})
    protected boolean doListGeneric(JavaObject receiver, Number index) {
        return this.doListIntIndex(receiver, index.intValue());
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"!isList(receiver)"})
    protected static boolean notArray(JavaObject receiver, Number index) {
        throw UnsupportedMessageException.raise(Message.REMOVE);
    }

    static boolean isList(JavaObject receiver) {
        return receiver.obj instanceof List;
    }

    static ArrayRemoveNode create() {
        return ArrayRemoveNodeGen.create();
    }
}

