/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.UnwindException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public final class ProbeNode
extends Node {
    public static final Object UNWIND_ACTION_REENTER = new Object();
    private static final Object UNWIND_ACTION_IGNORED = new Object();
    private final InstrumentationHandler handler;
    @CompilerDirectives.CompilationFinal
    private volatile EventContext context;
    @Node.Child
    private volatile EventChainNode chain;
    @CompilerDirectives.CompilationFinal
    private volatile Assumption version;
    @CompilerDirectives.CompilationFinal
    private volatile byte seen = 0;
    private final BranchProfile unwindHasNext = BranchProfile.create();

    ProbeNode(InstrumentationHandler handler, SourceSection sourceSection) {
        this.handler = handler;
        this.context = new EventContext(this, sourceSection);
    }

    public void onEnter(VirtualFrame frame) {
        EventChainNode localChain = this.lazyUpdate(frame);
        if (localChain != null) {
            localChain.onEnter(this.context, frame);
        }
    }

    public void onReturnValue(VirtualFrame frame, Object result) {
        EventChainNode localChain = this.lazyUpdate(frame);
        assert (this.isNullOrInteropValue(result));
        if (localChain != null) {
            localChain.onReturnValue(this.context, frame, result);
        }
    }

    private boolean isNullOrInteropValue(Object result) {
        if (!(this.context.getInstrumentedNode() instanceof InstrumentableNode)) {
            return true;
        }
        if (result == null) {
            return true;
        }
        InstrumentationHandler.AccessorInstrumentHandler.interopAccess().checkInteropType(result);
        return true;
    }

    @Deprecated
    public void onReturnExceptional(VirtualFrame frame, Throwable exception) {
        if (exception instanceof ThreadDeath) {
            throw (ThreadDeath)exception;
        }
        EventChainNode localChain = this.lazyUpdate(frame);
        if (localChain != null) {
            localChain.onReturnExceptional(this.context, frame, exception);
        }
    }

    @Override
    public Node copy() {
        ProbeNode pn = (ProbeNode)super.copy();
        pn.context = new EventContext(pn, this.context.getInstrumentedSourceSection());
        return pn;
    }

    public Object onReturnExceptionalOrUnwind(VirtualFrame frame, Throwable exception, boolean isReturnCalled) {
        UnwindException unwind = null;
        if (exception instanceof UnwindException) {
            if (!this.isSeenUnwind()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setSeenUnwind();
            }
            unwind = (UnwindException)exception;
        } else if (exception instanceof ThreadDeath) {
            throw (ThreadDeath)exception;
        }
        EventChainNode localChain = this.lazyUpdate(frame);
        if (localChain != null) {
            if (!isReturnCalled) {
                try {
                    localChain.onReturnExceptional(this.context, frame, exception);
                }
                catch (UnwindException ex) {
                    if (!this.isSeenUnwind()) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.setSeenUnwind();
                    }
                    if (unwind != null && unwind != ex) {
                        this.unwindHasNext.enter();
                        unwind.addNext(ex);
                    }
                    unwind = ex;
                }
            }
            if (unwind != null) {
                Object ret = localChain.onUnwind(this.context, frame, unwind);
                if (ret == UNWIND_ACTION_REENTER) {
                    if (!this.isSeenReenter()) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.setSeenReenter();
                    }
                    return UNWIND_ACTION_REENTER;
                }
                if (ret != null && ret != UNWIND_ACTION_IGNORED) {
                    if (!this.isSeenReturn()) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.setSeenReturn();
                    }
                    assert (this.isNullOrInteropValue(ret));
                    return ret;
                }
                throw unwind;
            }
        }
        return null;
    }

    private boolean isSeenUnwind() {
        return (this.seen & 1) != 0;
    }

    private void setSeenUnwind() {
        CompilerAsserts.neverPartOfCompilation();
        this.seen = (byte)(this.seen | 1);
    }

    private boolean isSeenReenter() {
        return (this.seen & 2) != 0;
    }

    private void setSeenReenter() {
        CompilerAsserts.neverPartOfCompilation();
        this.seen = (byte)(this.seen | 2);
    }

    private boolean isSeenReturn() {
        return (this.seen & 4) != 0;
    }

    private void setSeenReturn() {
        CompilerAsserts.neverPartOfCompilation();
        this.seen = (byte)(this.seen | 4);
    }

    void onInputValue(VirtualFrame frame, EventBinding<?> targetBinding, EventContext inputContext, int inputIndex, Object inputValue) {
        EventChainNode localChain = this.lazyUpdate(frame);
        if (localChain != null) {
            localChain.onInputValue(this.context, frame, targetBinding, inputContext, inputIndex, inputValue);
        }
    }

    EventContext getContext() {
        return this.context;
    }

    InstrumentableFactory.WrapperNode findWrapper() throws AssertionError {
        Node parent = this.getParent();
        if (!(parent instanceof InstrumentableFactory.WrapperNode)) {
            if (parent == null) {
                throw new AssertionError((Object)"Probe node disconnected from AST.");
            }
            throw new AssertionError((Object)"ProbeNodes must have a parent Node that implements NodeWrapper.");
        }
        return (InstrumentableFactory.WrapperNode)((Object)parent);
    }

    synchronized void invalidate() {
        Assumption localVersion = this.version;
        if (localVersion != null) {
            localVersion.invalidate();
        }
    }

    EventChainNode lazyUpdate(VirtualFrame frame) {
        Assumption localVersion = this.version;
        if (localVersion == null || !localVersion.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.lazyUpdatedImpl(frame);
        }
        return this.chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventChainNode lazyUpdatedImpl(VirtualFrame frame) {
        EventChainNode oldChain;
        EventChainNode nextChain;
        Lock lock = this.getLock();
        lock.lock();
        try {
            Assumption localVersion = this.version;
            if (localVersion != null && localVersion.isValid()) {
                EventChainNode eventChainNode = this.chain;
                return eventChainNode;
            }
            nextChain = this.handler.createBindings(frame, this);
            if (nextChain == null) {
                InstrumentationHandler.removeWrapper(this);
                EventChainNode eventChainNode = null;
                return eventChainNode;
            }
            oldChain = this.chain;
            this.chain = this.insert(nextChain);
            this.version = Truffle.getRuntime().createAssumption("Instruments unchanged");
        }
        finally {
            lock.unlock();
        }
        if (oldChain != null) {
            oldChain.onDispose(this.context, frame);
        }
        return nextChain;
    }

    ExecutionEventNode lookupExecutionEventNode(EventBinding<?> binding) {
        if (binding.isDisposed()) {
            return null;
        }
        EventChainNode chainNode = this.chain;
        while (chainNode != null) {
            if (chainNode.binding == binding && chainNode instanceof EventProviderChainNode) {
                return ((EventProviderChainNode)chainNode).eventNode;
            }
            chainNode = chainNode.next;
        }
        return null;
    }

    Iterator<ExecutionEventNode> lookupExecutionEventNodes(final Collection<EventBinding<? extends ExecutionEventNodeFactory>> bindings) {
        return new Iterator<ExecutionEventNode>(){
            private EventChainNode chainNode;
            private EventProviderChainNode nextNode;
            {
                this.chainNode = ProbeNode.this.chain;
            }

            @Override
            public boolean hasNext() {
                if (this.nextNode == null) {
                    while (this.chainNode != null) {
                        if (this.chainNode instanceof EventProviderChainNode && bindings.contains(this.chainNode.binding)) {
                            this.nextNode = (EventProviderChainNode)this.chainNode;
                            this.chainNode = this.chainNode.next;
                            break;
                        }
                        this.chainNode = this.chainNode.next;
                    }
                }
                return this.nextNode != null;
            }

            @Override
            public ExecutionEventNode next() {
                EventProviderChainNode node = this.nextNode;
                if (node == null) {
                    throw new NoSuchElementException();
                }
                this.nextNode = null;
                return node.eventNode;
            }
        };
    }

    EventChainNode createParentEventChainCallback(VirtualFrame frame, EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags) {
        EventChainNode parent = this.findParentChain(frame, binding);
        if (!(parent instanceof EventProviderWithInputChainNode)) {
            return null;
        }
        EventContext parentContext = parent.findProbe().getContext();
        EventProviderWithInputChainNode parentChain = (EventProviderWithInputChainNode)parent;
        int index = ProbeNode.indexOfChild(binding, rootNode, providedTags, parentContext.getInstrumentedNode(), parentContext.getInstrumentedSourceSection(), this.context.getInstrumentedNode());
        if (index < 0 || index >= parentChain.inputCount) {
            assert (ProbeNode.throwIllegalASTAssertion(parentChain, parentContext, binding, rootNode, providedTags, index));
            return null;
        }
        ProbeNode probe = parent.findProbe();
        return new InputValueChainNode(binding, probe, this.context, index);
    }

    private static boolean throwIllegalASTAssertion(EventProviderWithInputChainNode parentChain, EventContext parentContext, EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags, int index) {
        StringBuilder msg = new StringBuilder();
        try {
            EventContext eventContext;
            int i;
            int lookupChildrenCount = 10;
            SourceSection parentSourceSection = parentContext.getInstrumentedSourceSection();
            EventContext[] contexts = ProbeNode.findChildContexts(binding, rootNode, providedTags, parentContext.getInstrumentedNode(), parentContext.getInstrumentedSourceSection(), Math.max(parentChain.inputCount, index + 10));
            int contextCount = 0;
            for (i = 0; i < contexts.length; ++i) {
                eventContext = contexts[i];
                if (eventContext == null) continue;
                ++contextCount;
            }
            msg.append("Stable AST assumption violated.  " + parentChain.inputCount + " children expected got " + contextCount);
            msg.append("\n Parent: " + parentSourceSection);
            block3: for (i = 0; i < contexts.length; ++i) {
                eventContext = contexts[i];
                if (eventContext == null) continue;
                msg.append("\nChild[" + i + "] = " + eventContext.getInstrumentedSourceSection());
                String indent = "  ";
                for (Node node = eventContext.getInstrumentedNode(); node != null; node = node.getParent()) {
                    msg.append("\n");
                    msg.append(indent);
                    if (node == parentContext.getInstrumentedNode()) {
                        msg.append("Parent");
                        continue block3;
                    }
                    if (node.getParent() == null) {
                        msg.append("null parent = ");
                    } else {
                        String fieldName = NodeUtil.findChildField(node.getParent(), node).getName();
                        msg.append(node.getParent().getClass().getSimpleName() + "." + fieldName + " = ");
                    }
                    msg.append(node.getClass().getSimpleName() + "#" + System.identityHashCode(node));
                    indent = indent + "  ";
                }
            }
        }
        catch (Throwable e) {
            AssertionError error = new AssertionError((Object)"Stable AST assumption violated");
            ((Throwable)((Object)error)).addSuppressed(e);
            throw error;
        }
        throw new AssertionError((Object)msg.toString());
    }

    EventChainNode createEventChainCallback(VirtualFrame frame, EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags, Node instrumentedNode, SourceSection instrumentedNodeSourceSection) {
        EventChainNode next;
        Object element = binding.getElement();
        if (element instanceof ExecutionEventListener) {
            next = new EventFilterChainNode(binding, (ExecutionEventListener)element);
        } else {
            assert (element instanceof ExecutionEventNodeFactory);
            ExecutionEventNode eventNode = this.createEventNode(binding, element);
            if (eventNode == null) {
                return null;
            }
            if (binding.getInputFilter() != null) {
                int baseInput;
                EventChainNode parent = this.findParentChain(frame, binding);
                EventProviderWithInputChainNode parentChain = (EventProviderWithInputChainNode)parent;
                if (parentChain == null) {
                    baseInput = 0;
                } else {
                    EventContext parentContext = parentChain.findProbe().getContext();
                    int childIndex = ProbeNode.indexOfChild(binding, rootNode, providedTags, parentContext.getInstrumentedNode(), parentContext.getInstrumentedSourceSection(), instrumentedNode);
                    int inputBaseIndex = parentChain.inputBaseIndex;
                    baseInput = childIndex < 0 ? inputBaseIndex + parentChain.inputCount : inputBaseIndex + childIndex;
                }
                int inputCount = ProbeNode.countChildren(binding, rootNode, providedTags, instrumentedNode, instrumentedNodeSourceSection);
                next = new EventProviderWithInputChainNode(binding, eventNode, baseInput, inputCount);
            } else {
                next = new EventProviderChainNode(binding, eventNode);
            }
        }
        return next;
    }

    static EventContext[] findChildContexts(EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags, Node instrumentedNode, SourceSection instrumentedNodeSourceSection, int inputCount) {
        InputChildContextLookup visitor = new InputChildContextLookup(binding, rootNode, providedTags, instrumentedNode, instrumentedNodeSourceSection, inputCount);
        NodeUtil.forEachChild(instrumentedNode, visitor);
        return visitor.foundContexts;
    }

    private static int indexOfChild(EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags, Node instrumentedNode, SourceSection instrumentedNodeSourceSection, Node lookupChild) {
        InputChildIndexLookup visitor = new InputChildIndexLookup(binding, rootNode, providedTags, instrumentedNode, instrumentedNodeSourceSection, lookupChild);
        NodeUtil.forEachChild(instrumentedNode, visitor);
        return visitor.found ? visitor.index : -1;
    }

    private static int countChildren(EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags, Node instrumentedNode, SourceSection instrumentedNodeSourceSection) {
        InputChildIndexLookup visitor = new InputChildIndexLookup(binding, rootNode, providedTags, instrumentedNode, instrumentedNodeSourceSection, null);
        NodeUtil.forEachChild(instrumentedNode, visitor);
        return visitor.index;
    }

    private EventChainNode findParentChain(VirtualFrame frame, EventBinding<?> binding) {
        Node node;
        for (node = this.getParent().getParent(); node != null; node = node.getParent()) {
            if (node instanceof InstrumentableFactory.WrapperNode) {
                ProbeNode probe = ((InstrumentableFactory.WrapperNode)((Object)node)).getProbeNode();
                EventChainNode c = probe.lazyUpdate(frame);
                if (c != null) {
                    c = c.find(binding);
                }
                if (c == null) continue;
                return c;
            }
            if (node instanceof RootNode) break;
        }
        if (node == null) {
            throw new IllegalStateException("The AST node is not yet adopted. ");
        }
        return null;
    }

    private ExecutionEventNode createEventNode(EventBinding.Source<?> binding, Object element) {
        ExecutionEventNode eventNode;
        try {
            eventNode = ((ExecutionEventNodeFactory)element).create(this.context);
            if (eventNode != null && eventNode.getParent() != null) {
                throw new IllegalStateException(String.format("Returned EventNode %s was already adopted by another AST.", eventNode));
            }
        }
        catch (Throwable t) {
            if (binding.isLanguageBinding()) {
                throw t;
            }
            ProbeNode.exceptionEventForClientInstrument(binding, "ProbeNodeFactory.create", t);
            return null;
        }
        return eventNode;
    }

    @CompilerDirectives.TruffleBoundary
    static void exceptionEventForClientInstrument(EventBinding.Source<?> b, String eventName, Throwable t) {
        assert (!b.isLanguageBinding());
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        Object currentVm = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getCurrentVM();
        if (currentVm != null && InstrumentationHandler.AccessorInstrumentHandler.engineAccess().isInstrumentExceptionsAreThrown(currentVm)) {
            ProbeNode.sthrow(RuntimeException.class, t);
        }
        InstrumentationHandler.InstrumentClientInstrumenter instrumenter = (InstrumentationHandler.InstrumentClientInstrumenter)b.getInstrumenter();
        Class<?> instrumentClass = instrumenter.getInstrumentClass();
        String message = String.format("Event %s failed for instrument class %s and listener/factory %s.", eventName, instrumentClass.getName(), b.getElement());
        Exception exception = new Exception(message, t);
        PrintStream stream = new PrintStream(instrumenter.getEnv().err());
        exception.printStackTrace(stream);
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    private static boolean checkInteropType(Object value, EventBinding.Source<?> binding) {
        Class<?> clazz;
        if (value != null && value != UNWIND_ACTION_REENTER && !InstrumentationHandler.ACCESSOR.isTruffleObject(value) && (clazz = value.getClass()) != Byte.class && clazz != Short.class && clazz != Integer.class && clazz != Long.class && clazz != Float.class && clazz != Double.class && clazz != Character.class && clazz != Boolean.class && clazz != String.class) {
            CompilerDirectives.transferToInterpreter();
            ClassCastException ccex = new ClassCastException(clazz.getName() + " isn't allowed Truffle interop type!");
            if (binding.isLanguageBinding()) {
                throw ccex;
            }
            ProbeNode.exceptionEventForClientInstrument(binding, "onUnwind", ccex);
            return false;
        }
        return true;
    }

    private static Object mergePostUnwindReturns(Object r1, Object r2) {
        if (r1 == null || r2 == null) {
            return null;
        }
        if (r1 == UNWIND_ACTION_IGNORED) {
            return r2;
        }
        if (r2 == UNWIND_ACTION_IGNORED) {
            return r1;
        }
        if (r1 == UNWIND_ACTION_REENTER || r2 == UNWIND_ACTION_REENTER) {
            return UNWIND_ACTION_REENTER;
        }
        return r1;
    }

    private static <T extends Throwable> void sthrow(Class<T> type, Throwable t) throws T {
        throw t;
    }

    private static class InputValueChainNode
    extends EventChainNode {
        private final EventBinding<?> targetBinding;
        private final ProbeNode parentProbe;
        private final int inputIndex;
        private final EventContext inputContext;

        InputValueChainNode(EventBinding.Source<?> binding, ProbeNode parentProbe, EventContext inputContext, int inputIndex) {
            super(binding);
            this.targetBinding = binding;
            this.parentProbe = parentProbe;
            this.inputContext = inputContext;
            this.inputIndex = inputIndex;
        }

        @Override
        EventChainNode find(EventBinding<?> b) {
            EventChainNode next = this.getNext();
            if (next == null) {
                return null;
            }
            return next.find(b);
        }

        @Override
        protected Object innerOnUnwind(EventContext context, VirtualFrame frame, Object info) {
            return null;
        }

        @Override
        protected void innerOnInputValue(EventContext context, VirtualFrame frame, EventBinding<?> binding, EventContext inputContext, int inputIndex, Object inputValue) {
        }

        @Override
        protected void innerOnEnter(EventContext context, VirtualFrame frame) {
        }

        @Override
        protected void innerOnDispose(EventContext context, VirtualFrame frame) {
        }

        @Override
        protected void innerOnReturnValue(EventContext context, VirtualFrame frame, Object result) {
            this.parentProbe.onInputValue(frame, this.targetBinding, this.inputContext, this.inputIndex, result);
        }

        @Override
        protected void innerOnReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
        }
    }

    static class EventProviderChainNode
    extends EventChainNode {
        @Node.Child
        private ExecutionEventNode eventNode;

        EventProviderChainNode(EventBinding.Source<?> binding, ExecutionEventNode eventNode) {
            super(binding);
            this.eventNode = eventNode;
        }

        @Override
        protected final void innerOnInputValue(EventContext context, VirtualFrame frame, EventBinding<?> binding, EventContext inputContext, int inputIndex, Object inputValue) {
            this.eventNode.onInputValue(frame, inputContext, inputIndex, inputValue);
        }

        @Override
        protected final void innerOnEnter(EventContext context, VirtualFrame frame) {
            this.eventNode.onEnter(frame);
        }

        @Override
        protected void innerOnReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            this.eventNode.onReturnExceptional(frame, exception);
        }

        @Override
        protected void innerOnReturnValue(EventContext context, VirtualFrame frame, Object result) {
            this.eventNode.onReturnValue(frame, result);
        }

        @Override
        protected Object innerOnUnwind(EventContext context, VirtualFrame frame, Object info) {
            return this.eventNode.onUnwind(frame, info);
        }

        @Override
        protected void innerOnDispose(EventContext context, VirtualFrame frame) {
            this.eventNode.onDispose(frame);
        }
    }

    static class EventProviderWithInputChainNode
    extends EventProviderChainNode {
        static final Object[] EMPTY_ARRAY = new Object[0];
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private volatile FrameSlot[] inputSlots;
        private volatile FrameDescriptor sourceFrameDescriptor;
        final int inputBaseIndex;
        final int inputCount;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        volatile EventContext[] inputContexts;

        EventProviderWithInputChainNode(EventBinding.Source<?> binding, ExecutionEventNode eventNode, int inputBaseIndex, int inputCount) {
            super(binding, eventNode);
            this.inputBaseIndex = inputBaseIndex;
            this.inputCount = inputCount;
        }

        final int getInputCount() {
            return this.inputCount;
        }

        final EventContext getInputContext(int index) {
            EventContext[] contexts = this.inputContexts;
            if (contexts == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                ProbeNode probe = this.findProbe();
                EventContext thisContext = probe.context;
                RootNode rootNode = this.getRootNode();
                Set<Class<?>> providedTags = probe.handler.getProvidedTags(rootNode);
                this.inputContexts = contexts = ProbeNode.findChildContexts(this.getBinding(), rootNode, providedTags, thisContext.getInstrumentedNode(), thisContext.getInstrumentedSourceSection(), this.inputCount);
            }
            if (contexts == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("Input event context not yet available. They are only available during event notifications.");
            }
            return contexts[index];
        }

        final void saveInputValue(VirtualFrame frame, int inputIndex, Object value) {
            this.verifyIndex(inputIndex);
            if (this.inputSlots == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.initializeSlots(frame);
            }
            assert (this.sourceFrameDescriptor == frame.getFrameDescriptor()) : "Unstable frame descriptor used by the language.";
            frame.setObject(this.inputSlots[inputIndex], value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeSlots(VirtualFrame frame) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.inputSlots == null) {
                    if (InstrumentationHandler.TRACE) {
                        InstrumentationHandler.trace("SLOTS: Adding %s save slots for binding %s%n", this.inputCount, this.getBinding().getElement());
                    }
                    FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
                    FrameSlot[] slots = new FrameSlot[this.inputCount];
                    for (int i = 0; i < this.inputCount; ++i) {
                        int slotIndex = this.inputBaseIndex + i;
                        slots[i] = frameDescriptor.findOrAddFrameSlot(new SavedInputValueID(this.getBinding(), slotIndex));
                    }
                    this.sourceFrameDescriptor = frameDescriptor;
                    this.inputSlots = slots;
                }
            }
            finally {
                lock.unlock();
            }
        }

        private void verifyIndex(int inputIndex) {
            if (inputIndex >= this.inputCount || inputIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalArgumentException("Invalid input index.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void innerOnDispose(EventContext context, VirtualFrame frame) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.inputSlots != null) {
                    FrameSlot[] slots = this.inputSlots;
                    this.inputSlots = null;
                    RootNode rootNode = context.getInstrumentedNode().getRootNode();
                    if (rootNode == null) {
                        return;
                    }
                    FrameDescriptor descriptor = rootNode.getFrameDescriptor();
                    assert (descriptor != null);
                    for (FrameSlot slot : slots) {
                        FrameSlot resolvedSlot = descriptor.findFrameSlot(slot.getIdentifier());
                        if (resolvedSlot == null) continue;
                        descriptor.removeFrameSlot(slot.getIdentifier());
                    }
                }
            }
            finally {
                lock.unlock();
            }
            super.innerOnDispose(context, frame);
        }

        @Override
        protected void innerOnReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            super.innerOnReturnExceptional(context, frame, exception);
            this.clearSlots(frame);
        }

        @Override
        protected void innerOnReturnValue(EventContext context, VirtualFrame frame, Object result) {
            super.innerOnReturnValue(context, frame, result);
            this.clearSlots(frame);
        }

        @ExplodeLoop
        private void clearSlots(VirtualFrame frame) {
            FrameSlot[] slots = this.inputSlots;
            if (slots != null && frame.getFrameDescriptor() == this.sourceFrameDescriptor) {
                for (int i = 0; i < slots.length; ++i) {
                    frame.setObject(slots[i], null);
                }
            }
        }

        protected final Object getSavedInputValue(VirtualFrame frame, int inputIndex) {
            try {
                this.verifyIndex(inputIndex);
                if (this.inputSlots == null) {
                    return null;
                }
                return frame.getObject(this.inputSlots[inputIndex]);
            }
            catch (FrameSlotTypeException e) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)e);
            }
        }

        @ExplodeLoop
        protected final Object[] getSavedInputValues(VirtualFrame frame) {
            Object[] inputValues;
            FrameSlot[] slots = this.inputSlots;
            if (slots == null) {
                return EMPTY_ARRAY;
            }
            if (frame.getFrameDescriptor() == this.sourceFrameDescriptor) {
                inputValues = new Object[slots.length];
                for (int i = 0; i < slots.length; ++i) {
                    try {
                        inputValues[i] = frame.getObject(slots[i]);
                        continue;
                    }
                    catch (FrameSlotTypeException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw new AssertionError((Object)e);
                    }
                }
            } else {
                inputValues = new Object[this.inputSlots.length];
            }
            return inputValues;
        }

        static final class SavedInputValueID {
            private final EventBinding<?> binding;
            private final int index;

            SavedInputValueID(EventBinding<?> binding, int index) {
                this.binding = binding;
                this.index = index;
            }

            public int hashCode() {
                return 31 * this.binding.hashCode() * 31 + this.index;
            }

            public String toString() {
                return "SavedInputValue(binding=" + this.binding.hashCode() + ":" + this.index + ")";
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                SavedInputValueID other = (SavedInputValueID)obj;
                return this.binding == other.binding && this.index == other.index;
            }
        }
    }

    private static class EventFilterChainNode
    extends EventChainNode {
        private final ExecutionEventListener listener;

        EventFilterChainNode(EventBinding.Source<?> binding, ExecutionEventListener listener) {
            super(binding);
            this.listener = listener;
        }

        @Override
        protected void innerOnInputValue(EventContext context, VirtualFrame frame, EventBinding<?> binding, EventContext inputContext, int inputIndex, Object inputValue) {
            this.listener.onInputValue(context, frame, inputContext, inputIndex, inputValue);
        }

        @Override
        protected void innerOnEnter(EventContext context, VirtualFrame frame) {
            this.listener.onEnter(context, frame);
        }

        @Override
        protected void innerOnReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            this.listener.onReturnExceptional(context, frame, exception);
        }

        @Override
        protected void innerOnReturnValue(EventContext context, VirtualFrame frame, Object result) {
            this.listener.onReturnValue(context, frame, result);
        }

        @Override
        protected Object innerOnUnwind(EventContext context, VirtualFrame frame, Object info) {
            return this.listener.onUnwind(context, frame, info);
        }

        @Override
        protected void innerOnDispose(EventContext context, VirtualFrame frame) {
        }
    }

    static abstract class EventChainNode
    extends Node {
        @Node.Child
        private EventChainNode next;
        private final EventBinding.Source<?> binding;
        private final BranchProfile unwindHasNext = BranchProfile.create();
        @CompilerDirectives.CompilationFinal
        private byte seen = 0;

        EventChainNode(EventBinding.Source<?> binding) {
            this.binding = binding;
        }

        final ProbeNode findProbe() {
            Node parent;
            for (parent = this; parent != null && !(parent instanceof ProbeNode); parent = parent.getParent()) {
            }
            return (ProbeNode)parent;
        }

        final void setNext(EventChainNode next) {
            this.next = this.insert(next);
        }

        EventBinding.Source<?> getBinding() {
            return this.binding;
        }

        EventChainNode getNext() {
            return this.next;
        }

        @Override
        public final NodeCost getCost() {
            return NodeCost.NONE;
        }

        private boolean isSeenException() {
            return (this.seen & 1) != 0;
        }

        private void setSeenException() {
            CompilerAsserts.neverPartOfCompilation();
            this.seen = (byte)(this.seen | 1);
        }

        private boolean isSeenUnwind() {
            return (this.seen & 2) != 0;
        }

        private void setSeenUnwind() {
            CompilerAsserts.neverPartOfCompilation();
            this.seen = (byte)(this.seen | 2);
        }

        final void onDispose(EventContext context, VirtualFrame frame) {
            try {
                this.innerOnDispose(context, frame);
            }
            catch (Throwable t) {
                if (!this.isSeenException()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenException();
                }
                if (this.binding.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onEnter", t);
            }
            if (this.next != null) {
                this.next.onDispose(context, frame);
            }
        }

        protected abstract void innerOnDispose(EventContext var1, VirtualFrame var2);

        final void onEnter(EventContext context, VirtualFrame frame) {
            UnwindException unwind = null;
            try {
                this.innerOnEnter(context, frame);
            }
            catch (UnwindException ex) {
                if (!this.isSeenUnwind()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenUnwind();
                }
                ex.thrownFromBinding(this.binding);
                unwind = ex;
            }
            catch (Throwable t) {
                if (!this.isSeenException()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenException();
                }
                if (this.binding.isLanguageBinding()) {
                    throw t;
                }
                CompilerDirectives.transferToInterpreter();
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onEnter", t);
            }
            if (this.next != null) {
                try {
                    this.next.onEnter(context, frame);
                }
                catch (UnwindException ex) {
                    if (!this.isSeenUnwind()) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.setSeenUnwind();
                    }
                    if (unwind != null && unwind != ex) {
                        this.unwindHasNext.enter();
                        unwind.addNext(ex);
                    }
                    unwind = ex;
                }
            }
            if (unwind != null) {
                throw unwind;
            }
        }

        protected abstract void innerOnEnter(EventContext var1, VirtualFrame var2);

        final void onInputValue(EventContext context, VirtualFrame frame, EventBinding<?> inputBinding, EventContext inputContext, int inputIndex, Object inputValue) {
            if (this.next != null) {
                this.next.onInputValue(context, frame, inputBinding, inputContext, inputIndex, inputValue);
            }
            try {
                if (this.binding == inputBinding) {
                    this.innerOnInputValue(context, frame, this.binding, inputContext, inputIndex, inputValue);
                }
            }
            catch (Throwable t) {
                if (!this.isSeenException()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenException();
                }
                if (this.binding.isLanguageBinding()) {
                    throw t;
                }
                CompilerDirectives.transferToInterpreter();
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onInputValue", t);
            }
        }

        protected abstract void innerOnInputValue(EventContext var1, VirtualFrame var2, EventBinding<?> var3, EventContext var4, int var5, Object var6);

        final void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
            UnwindException unwind = null;
            if (this.next != null) {
                try {
                    this.next.onReturnValue(context, frame, result);
                }
                catch (UnwindException ex) {
                    if (!this.isSeenUnwind()) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.setSeenUnwind();
                    }
                    unwind = ex;
                }
            }
            try {
                this.innerOnReturnValue(context, frame, result);
            }
            catch (UnwindException ex) {
                if (!this.isSeenUnwind()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenUnwind();
                }
                ex.thrownFromBinding(this.binding);
                if (unwind != null && unwind != ex) {
                    this.unwindHasNext.enter();
                    unwind.addNext(ex);
                } else {
                    unwind = ex;
                }
            }
            catch (Throwable t) {
                if (!this.isSeenException()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenException();
                }
                if (this.binding.isLanguageBinding()) {
                    throw t;
                }
                CompilerDirectives.transferToInterpreter();
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onReturnValue", t);
            }
            if (unwind != null) {
                throw unwind;
            }
        }

        protected abstract void innerOnReturnValue(EventContext var1, VirtualFrame var2, Object var3);

        final void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
            UnwindException unwind = null;
            if (exception instanceof UnwindException) {
                if (!this.isSeenUnwind()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenUnwind();
                }
                unwind = (UnwindException)exception;
                assert (unwind.getBinding() != null);
            }
            if (this.next != null) {
                try {
                    this.next.onReturnExceptional(context, frame, exception);
                }
                catch (UnwindException ex) {
                    if (!this.isSeenUnwind()) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.setSeenUnwind();
                    }
                    if (unwind != null && unwind != ex) {
                        this.unwindHasNext.enter();
                        unwind.addNext(ex);
                    }
                    unwind = ex;
                }
            }
            try {
                this.innerOnReturnExceptional(context, frame, exception);
            }
            catch (UnwindException ex) {
                if (!this.isSeenUnwind()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenUnwind();
                }
                ex.thrownFromBinding(this.binding);
                if (unwind != null && unwind != ex) {
                    this.unwindHasNext.enter();
                    unwind.addNext(ex);
                } else {
                    unwind = ex;
                }
            }
            catch (Throwable t) {
                if (!this.isSeenException()) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.setSeenException();
                }
                if (this.binding.isLanguageBinding()) {
                    exception.addSuppressed(t);
                }
                CompilerDirectives.transferToInterpreter();
                ProbeNode.exceptionEventForClientInstrument(this.binding, "onReturnExceptional", t);
            }
            if (unwind != null) {
                throw unwind;
            }
        }

        protected abstract void innerOnReturnExceptional(EventContext var1, VirtualFrame var2, Throwable var3);

        private boolean containsBinding(UnwindException unwind) {
            if (unwind.getBinding() == this.binding) {
                return true;
            }
            UnwindException nextUnwind = unwind.getNext();
            if (nextUnwind != null) {
                this.unwindHasNext.enter();
                return this.containsBindingBoundary(nextUnwind);
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean containsBindingBoundary(UnwindException unwind) {
            return this.containsBinding(unwind);
        }

        private Object getInfo(UnwindException unwind) {
            if (unwind.getBinding() == this.binding) {
                return unwind.getInfo();
            }
            UnwindException nextUnwind = unwind.getNext();
            if (nextUnwind != null) {
                this.unwindHasNext.enter();
                return this.getInfoBoundary(nextUnwind);
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private Object getInfoBoundary(UnwindException unwind) {
            return this.getInfo(unwind);
        }

        private void reset(UnwindException unwind) {
            if (unwind.getBinding() == this.binding) {
                unwind.resetThread();
            } else {
                UnwindException nextUnwind = unwind.getNext();
                if (nextUnwind != null) {
                    this.unwindHasNext.enter();
                    unwind.resetBoundary(this.binding);
                }
            }
        }

        final Object onUnwind(EventContext context, VirtualFrame frame, UnwindException unwind) {
            Object ret = null;
            if (this.containsBinding(unwind)) {
                try {
                    ret = this.innerOnUnwind(context, frame, this.getInfo(unwind));
                }
                catch (Throwable t) {
                    if (!this.isSeenException()) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.setSeenException();
                    }
                    if (this.binding.isLanguageBinding()) {
                        throw t;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ProbeNode.exceptionEventForClientInstrument(this.binding, "onUnwind", t);
                }
                if (ret != null) {
                    assert (ProbeNode.checkInteropType(ret, this.binding));
                    this.reset(unwind);
                }
            } else {
                ret = UNWIND_ACTION_IGNORED;
            }
            if (this.next != null) {
                Object nextRet = this.next.onUnwind(context, frame, unwind);
                ret = ProbeNode.mergePostUnwindReturns(ret, nextRet);
            }
            return ret;
        }

        protected abstract Object innerOnUnwind(EventContext var1, VirtualFrame var2, Object var3);

        EventChainNode find(EventBinding<?> b) {
            if (this.binding == b) {
                assert (this.next == null || this.next.find(b) == null) : "only one chain entry per binding allowed";
                return this;
            }
            return this.next != null ? this.next.find(b) : null;
        }
    }

    private static abstract class InstrumentableChildVisitor
    implements NodeVisitor {
        private final EventBinding.Source<?> binding;
        private final Set<Class<?>> providedTags;
        private final RootNode rootNode;
        private final Node instrumentedNode;
        private final SourceSection instrumentedNodeSourceSection;

        InstrumentableChildVisitor(EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags, Node instrumentedNode, SourceSection instrumentedNodeSourceSection) {
            this.binding = binding;
            this.providedTags = providedTags;
            this.rootNode = rootNode;
            this.instrumentedNode = instrumentedNode;
            this.instrumentedNodeSourceSection = instrumentedNodeSourceSection;
        }

        @Override
        public final boolean visit(Node node) {
            SourceSection sourceSection = node.getSourceSection();
            if (InstrumentationHandler.isInstrumentableNode(node, sourceSection)) {
                return !this.binding.isChildInstrumentedFull(this.providedTags, this.rootNode, this.instrumentedNode, this.instrumentedNodeSourceSection, node, sourceSection) || this.visitChild(node);
            }
            NodeUtil.forEachChild(node, this);
            return true;
        }

        protected abstract boolean visitChild(Node var1);
    }

    private static class InputChildIndexLookup
    extends InstrumentableChildVisitor {
        private final Node lookupNode;
        boolean found = false;
        int index;

        InputChildIndexLookup(EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags, Node instrumentedNode, SourceSection instrumentedNodeSourceSection, Node lookupNode) {
            super(binding, rootNode, providedTags, instrumentedNode, instrumentedNodeSourceSection);
            this.lookupNode = lookupNode;
        }

        @Override
        protected boolean visitChild(Node child) {
            if (this.found) {
                return false;
            }
            if (this.lookupNode == child) {
                this.found = true;
                return false;
            }
            ++this.index;
            return true;
        }
    }

    private static class InputChildContextLookup
    extends InstrumentableChildVisitor {
        EventContext[] foundContexts;
        int index;

        InputChildContextLookup(EventBinding.Source<?> binding, RootNode rootNode, Set<Class<?>> providedTags, Node instrumentedNode, SourceSection instrumentedNodeSourceSection, int childrenCount) {
            super(binding, rootNode, providedTags, instrumentedNode, instrumentedNodeSourceSection);
            this.foundContexts = new EventContext[childrenCount];
        }

        @Override
        protected boolean visitChild(Node child) {
            ProbeNode probe;
            Node parent = child.getParent();
            if (parent instanceof InstrumentableFactory.WrapperNode) {
                probe = ((InstrumentableFactory.WrapperNode)((Object)parent)).getProbeNode();
                if (this.index >= this.foundContexts.length) {
                    assert (false);
                    this.foundContexts = null;
                    return false;
                }
            } else {
                assert (false);
                this.foundContexts = null;
                return false;
            }
            this.foundContexts[this.index] = probe.context;
            ++this.index;
            return true;
        }
    }
}

