/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.instrumentation.AllocationEventFilter;
import com.oracle.truffle.api.instrumentation.AllocationListener;
import com.oracle.truffle.api.instrumentation.AllocationReporter;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecuteSourceEvent;
import com.oracle.truffle.api.instrumentation.ExecuteSourceListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.Instrumentable;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceSectionListener;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.RootNodeBits;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Source;

final class InstrumentationHandler {
    static final boolean TRACE = Boolean.getBoolean("truffle.instrumentation.trace");
    private final Object sourceVM;
    private final Map<com.oracle.truffle.api.source.Source, Void> sources = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicReference<Collection<com.oracle.truffle.api.source.Source>> sourcesListRef = new AtomicReference();
    private volatile boolean hasSourceBindings;
    private final Map<com.oracle.truffle.api.source.Source, Void> sourcesExecuted = Collections.synchronizedMap(new WeakHashMap());
    private final AtomicReference<Collection<com.oracle.truffle.api.source.Source>> sourcesExecutedListRef = new AtomicReference();
    private volatile boolean hasSourceExecutedBindings;
    private final Collection<RootNode> loadedRoots = new WeakAsyncList<RootNode>(256);
    private final Collection<RootNode> executedRoots = new WeakAsyncList<RootNode>(64);
    private final Collection<AllocationReporter> allocationReporters = new WeakAsyncList<AllocationReporter>(16);
    private final Collection<EventBinding.Source<?>> executionBindings = new EventBindingList(8);
    private final Collection<EventBinding.Source<?>> sourceSectionBindings = new EventBindingList(8);
    private final Collection<EventBinding.Source<?>> sourceBindings = new EventBindingList(8);
    private final FindSourcesVisitor findSourcesVisitor = new FindSourcesVisitor(this.sources, this.sourcesListRef);
    private final Collection<EventBinding.Source<?>> sourceExecutedBindings = new EventBindingList(8);
    private final FindSourcesVisitor findSourcesExecutedVisitor = new FindSourcesVisitor(this.sourcesExecuted, this.sourcesExecutedListRef);
    private final Collection<EventBinding<? extends OutputStream>> outputStdBindings = new EventBindingList<EventBinding<? extends OutputStream>>(1);
    private final Collection<EventBinding<? extends OutputStream>> outputErrBindings = new EventBindingList<EventBinding<? extends OutputStream>>(1);
    private final Collection<EventBinding.Allocation<? extends AllocationListener>> allocationBindings = new EventBindingList<EventBinding.Allocation<? extends AllocationListener>>(2);
    private final Collection<EventBinding<? extends ContextsListener>> contextsBindings = new EventBindingList<EventBinding<? extends ContextsListener>>(8);
    private final Collection<EventBinding<? extends ThreadsListener>> threadsBindings = new EventBindingList<EventBinding<? extends ThreadsListener>>(8);
    private final ConcurrentHashMap<Object, AbstractInstrumenter> instrumenterMap = new ConcurrentHashMap();
    private DispatchOutputStream out;
    private DispatchOutputStream err;
    private InputStream in;
    private final Map<Class<?>, Set<Class<?>>> cachedProvidedTags = new ConcurrentHashMap();
    private final EngineInstrumenter engineInstrumenter;
    static final AccessorInstrumentHandler ACCESSOR = new AccessorInstrumentHandler();

    private InstrumentationHandler(Object sourceVM, DispatchOutputStream out, DispatchOutputStream err, InputStream in) {
        this.sourceVM = sourceVM;
        this.out = out;
        this.err = err;
        this.in = in;
        this.engineInstrumenter = new EngineInstrumenter();
    }

    Object getSourceVM() {
        return this.sourceVM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLoad(RootNode root) {
        if (!AccessorInstrumentHandler.nodesAccess().isInstrumentable(root)) {
            return;
        }
        assert (root.getLanguageInfo() != null);
        if (this.hasSourceBindings) {
            com.oracle.truffle.api.source.Source[] sourceArray = this.sources;
            synchronized (this.sources) {
                com.oracle.truffle.api.source.Source[] rootSources;
                if (!this.sourceBindings.isEmpty()) {
                    this.lazyInitializeSourcesList();
                    SourceSection sourceSection = root.getSourceSection();
                    if (sourceSection != null) {
                        this.findSourcesVisitor.adoptSource(sourceSection.getSource());
                    }
                    this.visitRoot(root, root, this.findSourcesVisitor, false);
                    rootSources = this.findSourcesVisitor.getSources();
                } else {
                    this.hasSourceBindings = false;
                    this.sources.clear();
                    this.sourcesListRef.set(null);
                    rootSources = null;
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.loadedRoots.add(root);
                if (rootSources != null) {
                    for (com.oracle.truffle.api.source.Source src : rootSources) {
                        InstrumentationHandler.notifySourceBindingsLoaded(this.sourceBindings, src);
                    }
                }
            }
        } else {
            this.loadedRoots.add(root);
        }
        {
            if (!this.sourceSectionBindings.isEmpty()) {
                this.visitRoot(root, root, new NotifyLoadedListenerVisitor(this.sourceSectionBindings), false);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFirstExecution(RootNode root) {
        if (!AccessorInstrumentHandler.nodesAccess().isInstrumentable(root)) {
            return;
        }
        assert (root.getLanguageInfo() != null);
        if (this.hasSourceExecutedBindings) {
            com.oracle.truffle.api.source.Source[] rootSources;
            Map<com.oracle.truffle.api.source.Source, Void> map = this.sourcesExecuted;
            synchronized (map) {
                if (!this.sourceExecutedBindings.isEmpty()) {
                    this.lazyInitializeSourcesExecutedList();
                    int rootBits = RootNodeBits.get(root);
                    if (RootNodeBits.isNoSourceSection(rootBits)) {
                        rootSources = null;
                    } else {
                        SourceSection sourceSection = root.getSourceSection();
                        if (RootNodeBits.isSameSource(rootBits) && sourceSection != null) {
                            com.oracle.truffle.api.source.Source source = sourceSection.getSource();
                            this.findSourcesExecutedVisitor.adoptSource(source);
                            rootSources = new com.oracle.truffle.api.source.Source[]{source};
                        } else {
                            if (sourceSection != null) {
                                this.findSourcesExecutedVisitor.adoptSource(sourceSection.getSource());
                            }
                            this.visitRoot(root, root, this.findSourcesExecutedVisitor, false);
                            rootSources = this.findSourcesExecutedVisitor.getSources();
                        }
                    }
                } else {
                    this.hasSourceExecutedBindings = false;
                    this.sourcesExecuted.clear();
                    this.sourcesExecutedListRef.set(null);
                    rootSources = null;
                }
            }
            this.executedRoots.add(root);
            if (rootSources != null) {
                for (Map<com.oracle.truffle.api.source.Source, Void> map2 : rootSources) {
                    InstrumentationHandler.notifySourceExecutedBindings(this.sourceExecutedBindings, map2);
                }
            }
        } else {
            this.executedRoots.add(root);
        }
        if (!this.executionBindings.isEmpty()) {
            this.visitRoot(root, root, new InsertWrappersVisitor(this.executionBindings), false);
        }
    }

    void initializeInstrument(Object vmObject, Class<?> instrumentClass) {
        TruffleInstrument.Env env = new TruffleInstrument.Env(vmObject, this.out, this.err, this.in);
        env.instrumenter = new InstrumentClientInstrumenter(env, instrumentClass);
        if (TRACE) {
            InstrumentationHandler.trace("Initialize instrument class %s %n", instrumentClass);
        }
        try {
            env.instrumenter.instrument = (TruffleInstrument)instrumentClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            InstrumentationHandler.failInstrumentInitialization(env, String.format("Failed to create new instrumenter class %s", instrumentClass.getName()), e);
            return;
        }
        if (TRACE) {
            InstrumentationHandler.trace("Initialized instrument %s class %s %n", env.instrumenter.instrument, instrumentClass);
        }
        this.addInstrumenter(vmObject, env.instrumenter);
    }

    void createInstrument(Object vmObject, String[] expectedServices, OptionValues optionValues) {
        InstrumentClientInstrumenter instrumenter = (InstrumentClientInstrumenter)this.instrumenterMap.get(vmObject);
        ((InstrumentClientInstrumenter)instrumenter).env.options = optionValues;
        instrumenter.create(expectedServices);
    }

    void finalizeInstrumenter(Object key) {
        AbstractInstrumenter finalisingInstrumenter = this.instrumenterMap.get(key);
        if (finalisingInstrumenter == null) {
            throw new AssertionError((Object)"Instrumenter already disposed.");
        }
        finalisingInstrumenter.doFinalize();
    }

    void disposeInstrumenter(Object key, boolean cleanupRequired) {
        AbstractInstrumenter disposedInstrumenter = this.instrumenterMap.remove(key);
        if (disposedInstrumenter == null) {
            throw new AssertionError((Object)"Instrumenter already disposed.");
        }
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Dispose instrumenter %n", key);
        }
        disposedInstrumenter.dispose();
        if (cleanupRequired) {
            Collection<EventBinding.Source<?>> disposedExecutionBindings = InstrumentationHandler.filterBindingsForInstrumenter(this.executionBindings, disposedInstrumenter);
            if (!disposedExecutionBindings.isEmpty()) {
                this.visitRoots(this.executedRoots, new DisposeWrappersWithBindingVisitor(disposedExecutionBindings));
            }
            InstrumentationHandler.disposeBindingsBulk(disposedExecutionBindings);
            InstrumentationHandler.disposeBindingsBulk(InstrumentationHandler.filterBindingsForInstrumenter(this.sourceSectionBindings, disposedInstrumenter));
            InstrumentationHandler.disposeBindingsBulk(InstrumentationHandler.filterBindingsForInstrumenter(this.sourceBindings, disposedInstrumenter));
            InstrumentationHandler.disposeOutputBindingsBulk(this.out, this.outputStdBindings);
            InstrumentationHandler.disposeOutputBindingsBulk(this.err, this.outputErrBindings);
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Disposed instrumenter %n", key);
        }
    }

    private static void disposeBindingsBulk(Collection<EventBinding.Source<?>> list) {
        for (EventBinding eventBinding : list) {
            eventBinding.disposeBulk();
        }
    }

    private static void disposeOutputBindingsBulk(DispatchOutputStream dos, Collection<EventBinding<? extends OutputStream>> list) {
        for (EventBinding<? extends OutputStream> binding : list) {
            AccessorInstrumentHandler.engineAccess().detachOutputConsumer(dos, binding.getElement());
            binding.disposeBulk();
        }
    }

    Instrumenter forLanguage(LanguageInfo info) {
        return new LanguageClientInstrumenter(info);
    }

    <T> EventBinding<T> addExecutionBinding(EventBinding.Source<T> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.executionBindings.add(binding);
        if (!this.executedRoots.isEmpty()) {
            this.visitRoots(this.executedRoots, new InsertWrappersWithBindingVisitor(binding));
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    <T> EventBinding<T> addSourceSectionBinding(EventBinding.Source<T> binding, boolean notifyLoaded) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.sourceSectionBindings.add(binding);
        if (notifyLoaded && !this.loadedRoots.isEmpty()) {
            this.visitRoots(this.loadedRoots, new NotifyLoadedWithBindingVisitor(binding));
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    private void visitLoadedSourceSections(EventBinding.Source<?> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Visiting loaded source sections %s, %s%n", binding.getFilter(), binding.getElement());
        }
        if (!this.loadedRoots.isEmpty()) {
            this.visitRoots(this.loadedRoots, new NotifyLoadedWithBindingVisitor(binding));
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Visited loaded source sections %s, %s%n", binding.getFilter(), binding.getElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> EventBinding<T> addSourceBinding(EventBinding.Source<T> binding, boolean notifyLoaded) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding source binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.sourceBindings.add(binding);
        this.hasSourceBindings = true;
        if (notifyLoaded) {
            Map<com.oracle.truffle.api.source.Source, Void> map = this.sources;
            synchronized (map) {
                this.lazyInitializeSourcesList();
            }
            for (com.oracle.truffle.api.source.Source source : this.sourcesListRef.get()) {
                InstrumentationHandler.notifySourceBindingLoaded(binding, source);
            }
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added source binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> EventBinding<T> addSourceExecutionBinding(EventBinding.Source<T> binding, boolean notifyLoaded) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding source execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        this.sourceExecutedBindings.add(binding);
        this.hasSourceExecutedBindings = true;
        if (notifyLoaded) {
            Map<com.oracle.truffle.api.source.Source, Void> map = this.sourcesExecuted;
            synchronized (map) {
                this.lazyInitializeSourcesExecutedList();
            }
            for (com.oracle.truffle.api.source.Source source : this.sourcesExecutedListRef.get()) {
                InstrumentationHandler.notifySourceExecutedBinding(binding, source);
            }
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added source execution binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        return binding;
    }

    <T extends OutputStream> EventBinding<T> addOutputBinding(EventBinding<T> binding, boolean errorOutput) {
        String kind;
        if (TRACE) {
            kind = errorOutput ? "error" : "standard";
            InstrumentationHandler.trace("BEGIN: Adding " + kind + " output binding %s%n", binding.getElement());
        }
        if (errorOutput) {
            this.outputErrBindings.add(binding);
            AccessorInstrumentHandler.engineAccess().attachOutputConsumer(this.err, (OutputStream)binding.getElement());
        } else {
            this.outputStdBindings.add(binding);
            AccessorInstrumentHandler.engineAccess().attachOutputConsumer(this.out, (OutputStream)binding.getElement());
        }
        if (TRACE) {
            kind = errorOutput ? "error" : "standard";
            InstrumentationHandler.trace("END: Added " + kind + " output binding %s%n", binding.getElement());
        }
        return binding;
    }

    private <T extends AllocationListener> EventBinding<T> addAllocationBinding(EventBinding.Allocation<T> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding allocation binding %s%n", binding.getElement());
        }
        this.allocationBindings.add(binding);
        for (AllocationReporter allocationReporter : this.allocationReporters) {
            if (!binding.getAllocationFilter().contains(allocationReporter.language)) continue;
            allocationReporter.addListener((AllocationListener)binding.getElement());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added allocation binding %s%n", binding.getElement());
        }
        return binding;
    }

    private <T extends ContextsListener> EventBinding<T> addContextsBinding(EventBinding<T> binding, boolean includeActiveContexts) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding contexts binding %s%n", binding.getElement());
        }
        this.contextsBindings.add(binding);
        if (includeActiveContexts) {
            Accessor.EngineSupport engineAccess = AccessorInstrumentHandler.engineAccess();
            engineAccess.reportAllLanguageContexts(this.sourceVM, binding.getElement());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added contexts binding %s%n", binding.getElement());
        }
        return binding;
    }

    private <T extends ThreadsListener> EventBinding<T> addThreadsBinding(EventBinding<T> binding, boolean includeStartedThreads) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Adding threads binding %s%n", binding.getElement());
        }
        this.threadsBindings.add(binding);
        if (includeStartedThreads) {
            Accessor.EngineSupport engineAccess = AccessorInstrumentHandler.engineAccess();
            engineAccess.reportAllContextThreads(this.sourceVM, binding.getElement());
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Added threads binding %s%n", binding.getElement());
        }
        return binding;
    }

    private void lazyInitializeSourcesList() {
        assert (Thread.holdsLock(this.sources));
        if (this.sourcesListRef.get() == null) {
            WeakAsyncList sourcesList = new WeakAsyncList(16);
            this.sourcesListRef.set(sourcesList);
            for (RootNode root : this.loadedRoots) {
                int rootBits = RootNodeBits.get(root);
                if (RootNodeBits.isNoSourceSection(rootBits)) continue;
                SourceSection sourceSection = root.getSourceSection();
                if (RootNodeBits.isSameSource(rootBits) && sourceSection != null) {
                    com.oracle.truffle.api.source.Source source = sourceSection.getSource();
                    if (this.sources.containsKey(source)) continue;
                    this.sources.put(source, null);
                    sourcesList.add(source);
                    continue;
                }
                if (sourceSection != null) {
                    this.findSourcesVisitor.adoptSource(sourceSection.getSource());
                }
                this.visitRoot(root, root, this.findSourcesVisitor, false);
                for (com.oracle.truffle.api.source.Source source : this.findSourcesVisitor.rootSources) {
                    if (this.sources.containsKey(source)) continue;
                    this.sources.put(source, null);
                    sourcesList.add(source);
                }
                this.findSourcesVisitor.rootSources.clear();
            }
        }
    }

    private void lazyInitializeSourcesExecutedList() {
        assert (Thread.holdsLock(this.sourcesExecuted));
        if (this.sourcesExecutedListRef.get() == null) {
            WeakAsyncList sourcesExecutedList = new WeakAsyncList(16);
            this.sourcesExecutedListRef.set(sourcesExecutedList);
            for (RootNode root : this.executedRoots) {
                int rootBits = RootNodeBits.get(root);
                if (RootNodeBits.isNoSourceSection(rootBits)) continue;
                SourceSection sourceSection = root.getSourceSection();
                if (RootNodeBits.isSameSource(rootBits) && sourceSection != null) {
                    com.oracle.truffle.api.source.Source source = sourceSection.getSource();
                    if (this.sourcesExecuted.containsKey(source)) continue;
                    this.sourcesExecuted.put(source, null);
                    sourcesExecutedList.add(source);
                    continue;
                }
                if (sourceSection != null) {
                    this.findSourcesExecutedVisitor.adoptSource(sourceSection.getSource());
                }
                this.visitRoot(root, root, this.findSourcesExecutedVisitor, false);
                for (com.oracle.truffle.api.source.Source source : this.findSourcesExecutedVisitor.rootSources) {
                    if (this.sourcesExecuted.containsKey(source)) continue;
                    this.sourcesExecuted.put(source, null);
                    sourcesExecutedList.add(source);
                }
                this.findSourcesExecutedVisitor.rootSources.clear();
            }
        }
    }

    private void visitRoots(Collection<RootNode> roots, AbstractNodeVisitor addBindingsVisitor) {
        for (RootNode root : roots) {
            this.visitRoot(root, root, addBindingsVisitor, false);
        }
    }

    void disposeBinding(EventBinding<?> binding) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Dispose binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
        if (binding instanceof EventBinding.Source) {
            EventBinding.Source sourceBinding = (EventBinding.Source)binding;
            if (sourceBinding.isExecutionEvent()) {
                this.visitRoots(this.executedRoots, new DisposeWrappersVisitor(sourceBinding));
            }
        } else if (binding instanceof EventBinding.Allocation) {
            EventBinding.Allocation allocationBinding = (EventBinding.Allocation)binding;
            AllocationListener l = (AllocationListener)binding.getElement();
            for (AllocationReporter allocationReporter : this.allocationReporters) {
                if (!allocationBinding.getAllocationFilter().contains(allocationReporter.language)) continue;
                allocationReporter.removeListener(l);
            }
        } else {
            Object elm = binding.getElement();
            if (elm instanceof OutputStream) {
                if (this.outputErrBindings.contains(binding)) {
                    AccessorInstrumentHandler.engineAccess().detachOutputConsumer(this.err, (OutputStream)elm);
                } else if (this.outputStdBindings.contains(binding)) {
                    AccessorInstrumentHandler.engineAccess().detachOutputConsumer(this.out, (OutputStream)elm);
                }
            } else if (!(elm instanceof ContextsListener) && !(elm instanceof ThreadsListener)) assert (false) : "Unexpected binding " + binding + " with element " + elm;
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Disposed binding %s, %s%n", binding.getFilter(), binding.getElement());
        }
    }

    ProbeNode.EventChainNode createBindings(VirtualFrame frame, ProbeNode probeNodeImpl) {
        Node parentNode;
        EventContext context = probeNodeImpl.getContext();
        SourceSection sourceSection = context.getInstrumentedSourceSection();
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Lazy update for %s%n", sourceSection);
        }
        Node parentInstrumentable = null;
        SourceSection parentInstrumentableSourceSection = null;
        for (parentNode = probeNodeImpl.getParent(); parentNode != null && parentNode.getParent() != null; parentNode = parentNode.getParent()) {
            SourceSection parentSourceSection;
            if (parentInstrumentable != null || !InstrumentationHandler.isInstrumentableNode(parentNode, parentSourceSection = parentNode.getSourceSection())) continue;
            parentInstrumentable = parentNode;
            parentInstrumentableSourceSection = parentSourceSection;
        }
        if (!(parentNode instanceof RootNode)) {
            throw new AssertionError();
        }
        RootNode rootNode = (RootNode)parentNode;
        Node instrumentedNode = probeNodeImpl.getContext().getInstrumentedNode();
        Set<Class<?>> providedTags = this.getProvidedTags(rootNode);
        ProbeNode.EventChainNode root = null;
        ProbeNode.EventChainNode parent = null;
        for (EventBinding.Source<?> binding : this.executionBindings) {
            ProbeNode.EventChainNode next;
            if (binding.isChildInstrumentedFull(providedTags, rootNode, parentInstrumentable, parentInstrumentableSourceSection, instrumentedNode, sourceSection)) {
                if (TRACE) {
                    InstrumentationHandler.trace("  Found input value binding %s, %s%n", binding.getInputFilter(), System.identityHashCode(binding));
                }
                if ((next = probeNodeImpl.createParentEventChainCallback(frame, binding, rootNode, providedTags)) == null) continue;
                if (root == null) {
                    root = next;
                } else {
                    assert (parent != null);
                    parent.setNext(next);
                }
                parent = next;
            }
            if (!binding.isInstrumentedFull(providedTags, rootNode, instrumentedNode, sourceSection)) continue;
            if (TRACE) {
                InstrumentationHandler.trace("  Found binding %s, %s%n", binding.getFilter(), binding.getElement());
            }
            if ((next = probeNodeImpl.createEventChainCallback(frame, binding, rootNode, providedTags, instrumentedNode, sourceSection)) == null) continue;
            if (root == null) {
                root = next;
            } else {
                assert (parent != null);
                parent.setNext(next);
            }
            parent = next;
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Lazy updated for %s%n", sourceSection);
        }
        return root;
    }

    public void onNodeInserted(RootNode rootNode, Node tree) {
        Node parentInstrumentable = tree;
        while (parentInstrumentable != null && parentInstrumentable.getParent() != null && !InstrumentationHandler.isInstrumentableNode(parentInstrumentable = parentInstrumentable.getParent(), parentInstrumentable.getSourceSection())) {
        }
        assert (parentInstrumentable != null);
        if (!this.sourceSectionBindings.isEmpty()) {
            this.visitRoot(rootNode, parentInstrumentable, new NotifyLoadedListenerVisitor(this.sourceSectionBindings), true);
        }
        if (!this.executionBindings.isEmpty()) {
            this.visitRoot(rootNode, parentInstrumentable, new InsertWrappersVisitor(this.executionBindings), true);
        }
    }

    private static void notifySourceBindingsLoaded(Collection<EventBinding.Source<?>> bindings, com.oracle.truffle.api.source.Source source) {
        for (EventBinding.Source<?> binding : bindings) {
            InstrumentationHandler.notifySourceBindingLoaded(binding, source);
        }
    }

    private static void notifySourceBindingLoaded(EventBinding.Source<?> binding, com.oracle.truffle.api.source.Source source) {
        if (!binding.isDisposed() && binding.isInstrumentedSource(source)) {
            try {
                ((LoadSourceListener)binding.getElement()).onLoad(new LoadSourceEvent(source));
            }
            catch (Throwable t) {
                if (binding.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(binding, "onLoad", t);
            }
        }
    }

    private static void notifySourceExecutedBindings(Collection<EventBinding.Source<?>> bindings, com.oracle.truffle.api.source.Source source) {
        for (EventBinding.Source<?> binding : bindings) {
            InstrumentationHandler.notifySourceExecutedBinding(binding, source);
        }
    }

    private static void notifySourceExecutedBinding(EventBinding.Source<?> binding, com.oracle.truffle.api.source.Source source) {
        if (!binding.isDisposed() && binding.isInstrumentedSource(source)) {
            try {
                ((ExecuteSourceListener)binding.getElement()).onExecute(new ExecuteSourceEvent(source));
            }
            catch (Throwable t) {
                if (binding.isLanguageBinding()) {
                    throw t;
                }
                ProbeNode.exceptionEventForClientInstrument(binding, "onExecute", t);
            }
        }
    }

    static void notifySourceSectionLoaded(EventBinding.Source<?> binding, Node node, SourceSection section) {
        if (section == null) {
            return;
        }
        LoadSourceSectionListener listener = (LoadSourceSectionListener)binding.getElement();
        try {
            listener.onLoad(new LoadSourceSectionEvent(section, node));
        }
        catch (Throwable t) {
            if (binding.isLanguageBinding()) {
                throw t;
            }
            ProbeNode.exceptionEventForClientInstrument(binding, "onLoad", t);
        }
    }

    private void addInstrumenter(Object key, AbstractInstrumenter instrumenter) throws AssertionError {
        AbstractInstrumenter previousKey = this.instrumenterMap.putIfAbsent(key, instrumenter);
        if (previousKey != null) {
            throw new AssertionError((Object)"Instrumenter already present.");
        }
    }

    private static Collection<EventBinding.Source<?>> filterBindingsForInstrumenter(Collection<EventBinding.Source<?>> bindings, AbstractInstrumenter instrumenter) {
        if (bindings.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList newBindings = new ArrayList();
        for (EventBinding.Source<?> binding : bindings) {
            if (binding.getInstrumenter() != instrumenter) continue;
            newBindings.add(binding);
        }
        return newBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertWrapper(Node instrumentableNode, SourceSection sourceSection) {
        Lock lock = AccessorInstrumentHandler.nodesAccess().getLock(instrumentableNode);
        try {
            lock.lock();
            this.insertWrapperImpl(instrumentableNode, sourceSection);
        }
        finally {
            lock.unlock();
        }
    }

    private void insertWrapperImpl(Node node, SourceSection sourceSection) {
        InstrumentableFactory.WrapperNode wrapper;
        Node parent = node.getParent();
        if (parent instanceof InstrumentableFactory.WrapperNode) {
            InstrumentationHandler.invalidateWrapperImpl((InstrumentableFactory.WrapperNode)((Object)parent), node);
            return;
        }
        ProbeNode probe = new ProbeNode(this, sourceSection);
        try {
            if (node instanceof InstrumentableNode) {
                wrapper = ((InstrumentableNode)((Object)node)).createWrapper(probe);
                if (wrapper == null) {
                    throw new IllegalStateException("No wrapper returned for " + node + " of class " + node.getClass().getName());
                }
            } else {
                Class<? extends InstrumentableFactory<? extends Node>> factory = null;
                for (Class<?> currentClass = node.getClass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                    Instrumentable instrumentable = currentClass.getAnnotation(Instrumentable.class);
                    if (instrumentable == null) continue;
                    factory = instrumentable.factory();
                    break;
                }
                if (factory == null) {
                    if (TRACE) {
                        InstrumentationHandler.trace("No wrapper inserted for %s, section %s. Not annotated with @Instrumentable.%n", node, sourceSection);
                    }
                    return;
                }
                if (TRACE) {
                    InstrumentationHandler.trace("Insert wrapper for %s, section %s%n", node, sourceSection);
                }
                wrapper = ((InstrumentableFactory)factory.newInstance()).createWrapper(node, probe);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create wrapper of " + node, e);
        }
        if (!(wrapper instanceof Node)) {
            throw new IllegalStateException(String.format("Implementation of %s must be a subclass of %s.", wrapper.getClass().getName(), Node.class.getSimpleName()));
        }
        Node wrapperNode = (Node)((Object)wrapper);
        if (wrapperNode.getParent() != null) {
            throw new IllegalStateException(String.format("Instance of provided wrapper %s is already adopted by another parent: %s", wrapper.getClass().getName(), wrapperNode.getParent().getClass().getName()));
        }
        if (parent == null) {
            throw new IllegalStateException(String.format("Instance of instrumentable node %s is not adopted by a parent.", node.getClass().getName()));
        }
        if (!NodeUtil.isReplacementSafe(parent, node, wrapperNode)) {
            throw new IllegalStateException(String.format("WrapperNode implementation %s cannot be safely replaced in parent node class %s.", wrapperNode.getClass().getName(), parent.getClass().getName()));
        }
        node.replace(wrapperNode, "Insert instrumentation wrapper node.");
        assert (probe.getContext().validEventContext());
    }

    private <T extends ExecutionEventNodeFactory> EventBinding<T> attachFactory(AbstractInstrumenter instrumenter, SourceSectionFilter filter, SourceSectionFilter inputFilter, T factory) {
        return this.addExecutionBinding(new EventBinding.Source<T>(instrumenter, filter, inputFilter, factory, true));
    }

    private <T extends ExecutionEventListener> EventBinding<T> attachListener(AbstractInstrumenter instrumenter, SourceSectionFilter filter, SourceSectionFilter inputFilter, T listener) {
        return this.addExecutionBinding(new EventBinding.Source<T>(instrumenter, filter, inputFilter, listener, true));
    }

    private <T extends LoadSourceListener> EventBinding<T> attachSourceListener(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, T listener, boolean notifyLoaded) {
        return this.addSourceBinding(new EventBinding.Source<T>(abstractInstrumenter, filter, null, listener, false), notifyLoaded);
    }

    private <T> EventBinding<T> attachSourceSectionListener(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, T listener, boolean notifyLoaded) {
        return this.addSourceSectionBinding(new EventBinding.Source<T>(abstractInstrumenter, filter, null, listener, false), notifyLoaded);
    }

    private void visitLoadedSourceSections(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, LoadSourceSectionListener listener) {
        this.visitLoadedSourceSections(new EventBinding.Source<LoadSourceSectionListener>(abstractInstrumenter, filter, null, listener, false));
    }

    private <T> EventBinding<T> attachExecuteSourceListener(AbstractInstrumenter abstractInstrumenter, SourceSectionFilter filter, T listener, boolean notifyLoaded) {
        return this.addSourceExecutionBinding(new EventBinding.Source<T>(abstractInstrumenter, filter, null, listener, false), notifyLoaded);
    }

    private <T extends OutputStream> EventBinding<T> attachOutputConsumer(AbstractInstrumenter instrumenter, T stream, boolean errorOutput) {
        return this.addOutputBinding(new EventBinding<T>(instrumenter, stream), errorOutput);
    }

    private <T extends AllocationListener> EventBinding<T> attachAllocationListener(AbstractInstrumenter instrumenter, AllocationEventFilter filter, T listener) {
        return this.addAllocationBinding(new EventBinding.Allocation<T>(instrumenter, filter, listener));
    }

    private <T extends ContextsListener> EventBinding<T> attachContextsListener(AbstractInstrumenter instrumenter, T listener, boolean includeActiveContexts) {
        assert (listener != null);
        return this.addContextsBinding(new EventBinding<T>(instrumenter, listener), includeActiveContexts);
    }

    private <T extends ThreadsListener> EventBinding<T> attachThreadsListener(AbstractInstrumenter instrumenter, T listener, boolean includeStartedThreads) {
        assert (listener != null);
        return this.addThreadsBinding(new EventBinding<T>(instrumenter, listener), includeStartedThreads);
    }

    private void notifyContextCreated(TruffleContext context) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onContextCreated(context);
        }
    }

    private void notifyContextClosed(TruffleContext context) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onContextClosed(context);
        }
    }

    private void notifyLanguageContextCreated(TruffleContext context, LanguageInfo language) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onLanguageContextCreated(context, language);
        }
    }

    private void notifyLanguageContextInitialized(TruffleContext context, LanguageInfo language) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onLanguageContextInitialized(context, language);
        }
    }

    private void notifyLanguageContextFinalized(TruffleContext context, LanguageInfo language) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onLanguageContextFinalized(context, language);
        }
    }

    private void notifyLanguageContextDisposed(TruffleContext context, LanguageInfo language) {
        for (EventBinding<? extends ContextsListener> binding : this.contextsBindings) {
            binding.getElement().onLanguageContextDisposed(context, language);
        }
    }

    private void notifyThreadStarted(TruffleContext context, Thread thread) {
        for (EventBinding<? extends ThreadsListener> binding : this.threadsBindings) {
            binding.getElement().onThreadInitialized(context, thread);
        }
    }

    private void notifyThreadFinished(TruffleContext context, Thread thread) {
        for (EventBinding<? extends ThreadsListener> binding : this.threadsBindings) {
            binding.getElement().onThreadDisposed(context, thread);
        }
    }

    Set<Class<?>> getProvidedTags(LanguageInfo language) {
        Accessor.Nodes nodesAccess = AccessorInstrumentHandler.nodesAccess();
        TruffleLanguage<?> lang = nodesAccess.getLanguageSpi(language);
        if (lang == null) {
            return Collections.emptySet();
        }
        Class<?> languageClass = lang.getClass();
        Set<Class<Object>> tags = this.cachedProvidedTags.get(languageClass);
        if (tags == null) {
            ProvidedTags languageTags = languageClass.getAnnotation(ProvidedTags.class);
            List languageTagsList = languageTags != null ? Arrays.asList(languageTags.value()) : Collections.emptyList();
            tags = Collections.unmodifiableSet(new HashSet(languageTagsList));
            this.cachedProvidedTags.put(languageClass, tags);
        }
        return tags;
    }

    Set<Class<?>> getProvidedTags(Node root) {
        return this.getProvidedTags(root.getRootNode().getLanguageInfo());
    }

    static boolean isInstrumentableNode(Node node, SourceSection sourceSection) {
        if (node instanceof InstrumentableFactory.WrapperNode) {
            return false;
        }
        if (node instanceof InstrumentableNode) {
            return ((InstrumentableNode)((Object)node)).isInstrumentable();
        }
        return !(node instanceof RootNode) && sourceSection != null;
    }

    static void trace(String message, Object ... args) {
        PrintStream out = System.out;
        out.printf(message, args);
    }

    private void visitRoot(RootNode root, Node node, AbstractNodeVisitor visitor, boolean forceRootBitComputation) {
        if (TRACE) {
            InstrumentationHandler.trace("BEGIN: Visit root %s for %s%n", root.toString(), visitor);
        }
        visitor.root = root;
        visitor.providedTags = this.getProvidedTags(root);
        visitor.rootSourceSection = root.getSourceSection();
        visitor.rootBits = RootNodeBits.get(visitor.root);
        if (visitor.shouldVisit() || forceRootBitComputation) {
            if (forceRootBitComputation) {
                visitor.computingRootNodeBits = RootNodeBits.isUninitialized(visitor.rootBits) ? RootNodeBits.getAll() : visitor.rootBits;
            } else if (RootNodeBits.isUninitialized(visitor.rootBits)) {
                visitor.computingRootNodeBits = RootNodeBits.getAll();
            }
            if (TRACE) {
                InstrumentationHandler.trace("BEGIN: Traverse root %s for %s%n", root.toString(), visitor);
            }
            visitor.visit(node);
            if (TRACE) {
                InstrumentationHandler.trace("END: Traverse root %s for %s%n", root.toString(), visitor);
            }
            if (!RootNodeBits.isUninitialized(visitor.computingRootNodeBits)) {
                RootNodeBits.set(visitor.root, visitor.computingRootNodeBits);
            }
        }
        if (TRACE) {
            InstrumentationHandler.trace("END: Visited root %s for %s%n", root.toString(), visitor);
        }
    }

    static void removeWrapper(ProbeNode node) {
        if (TRACE) {
            InstrumentationHandler.trace("Remove wrapper for %s%n", node.getContext().getInstrumentedSourceSection());
        }
        InstrumentableFactory.WrapperNode wrapperNode = node.findWrapper();
        ((Node)((Object)wrapperNode)).replace(wrapperNode.getDelegateNode());
    }

    private static void invalidateWrapper(Node node) {
        Node parent = node.getParent();
        if (!(parent instanceof InstrumentableFactory.WrapperNode)) {
            return;
        }
        InstrumentationHandler.invalidateWrapperImpl((InstrumentableFactory.WrapperNode)((Object)parent), node);
    }

    private static void invalidateWrapperImpl(InstrumentableFactory.WrapperNode parent, Node node) {
        ProbeNode probeNode = parent.getProbeNode();
        if (TRACE) {
            SourceSection section = probeNode.getContext().getInstrumentedSourceSection();
            InstrumentationHandler.trace("Invalidate wrapper for %s, section %s %n", node, section);
        }
        if (probeNode != null) {
            probeNode.invalidate();
        }
    }

    static boolean hasTagImpl(Set<Class<?>> providedTags, Node node, Class<?> tag) {
        if (providedTags.contains(tag)) {
            if (node instanceof InstrumentableNode) {
                return ((InstrumentableNode)((Object)node)).hasTag(tag);
            }
            return AccessorInstrumentHandler.nodesAccess().isTaggedWith(node, tag);
        }
        return false;
    }

    private <T> T lookup(Object key, Class<T> type) {
        AbstractInstrumenter value = this.instrumenterMap.get(key);
        return value == null ? null : (T)value.lookup(this, type);
    }

    private AllocationReporter getAllocationReporter(LanguageInfo info) {
        AllocationReporter allocationReporter = new AllocationReporter(info);
        this.allocationReporters.add(allocationReporter);
        for (EventBinding.Allocation<? extends AllocationListener> binding : this.allocationBindings) {
            if (!binding.getAllocationFilter().contains(info)) continue;
            allocationReporter.addListener((AllocationListener)binding.getElement());
        }
        return allocationReporter;
    }

    private void patch(DispatchOutputStream newOut, DispatchOutputStream newErr, InputStream newIn) {
        this.out = newOut;
        this.err = newErr;
        this.in = newIn;
    }

    static void failInstrumentInitialization(TruffleInstrument.Env env, String message, Throwable t) {
        Exception exception = new Exception(message, t);
        PrintStream stream = new PrintStream(env.err());
        exception.printStackTrace(stream);
    }

    private static void traceFilterCheck(String result, Set<Class<?>> providedTags, EventBinding<?> binding, Node node, SourceSection sourceSection) {
        Set<Class<?>> tags = binding.getFilter().getReferencedTags();
        HashSet containedTags = new HashSet();
        for (Class<?> tag : tags) {
            if (!InstrumentationHandler.hasTagImpl(providedTags, node, tag)) continue;
            containedTags.add(tag);
        }
        InstrumentationHandler.trace("  Filter %4s %s section:%s tags:%s%n", result, binding.getFilter(), sourceSection, containedTags);
    }

    static final class AccessorInstrumentHandler
    extends Accessor {
        AccessorInstrumentHandler() {
        }

        static Accessor.Nodes nodesAccess() {
            return ACCESSOR.nodes();
        }

        static Accessor.LanguageSupport langAccess() {
            return ACCESSOR.languageSupport();
        }

        static Accessor.EngineSupport engineAccess() {
            return ACCESSOR.engineSupport();
        }

        static Accessor.InteropSupport interopAccess() {
            return ACCESSOR.interopSupport();
        }

        @Override
        protected Accessor.InstrumentSupport instrumentSupport() {
            return new InstrumentImpl();
        }

        protected boolean isTruffleObject(Object value) {
            return this.interopSupport().isTruffleObject(value);
        }

        static final class InstrumentImpl
        extends Accessor.InstrumentSupport {
            InstrumentImpl() {
            }

            @Override
            public Object createInstrumentationHandler(Object vm, DispatchOutputStream out, DispatchOutputStream err, InputStream in) {
                return new InstrumentationHandler(vm, out, err, in);
            }

            @Override
            public void initializeInstrument(Object instrumentationHandler, Object key, Class<?> instrumentClass) {
                ((InstrumentationHandler)instrumentationHandler).initializeInstrument(key, instrumentClass);
            }

            @Override
            public void createInstrument(Object instrumentationHandler, Object key, String[] expectedServices, OptionValues options) {
                ((InstrumentationHandler)instrumentationHandler).createInstrument(key, expectedServices, options);
            }

            @Override
            public Object getEngineInstrumenter(Object instrumentationHandler) {
                return ((InstrumentationHandler)instrumentationHandler).engineInstrumenter;
            }

            @Override
            public void onNodeInserted(RootNode rootNode, Node tree) {
                InstrumentationHandler handler = InstrumentImpl.getHandler(rootNode);
                if (handler != null) {
                    handler.onNodeInserted(rootNode, tree);
                }
            }

            @Override
            public OptionDescriptors describeOptions(Object instrumentationHandler, Object key, String requiredGroup) {
                InstrumentClientInstrumenter instrumenter = (InstrumentClientInstrumenter)((InstrumentationHandler)instrumentationHandler).instrumenterMap.get(key);
                OptionDescriptors descriptors = instrumenter.instrument.getOptionDescriptors();
                if (descriptors == null) {
                    descriptors = OptionDescriptors.EMPTY;
                }
                String groupPlusDot = requiredGroup + ".";
                for (OptionDescriptor descriptor : descriptors) {
                    if (descriptor.getName().equals(requiredGroup) || descriptor.getName().startsWith(groupPlusDot)) continue;
                    throw new IllegalArgumentException(String.format("Illegal option prefix in name '%s' specified for option described by instrument '%s'. The option prefix must match the id of the instrument '%s'.", descriptor.getName(), instrumenter.instrument.getClass().getName(), requiredGroup));
                }
                return descriptors;
            }

            @Override
            public void finalizeInstrument(Object instrumentationHandler, Object key) {
                ((InstrumentationHandler)instrumentationHandler).finalizeInstrumenter(key);
            }

            @Override
            public void disposeInstrument(Object instrumentationHandler, Object key, boolean cleanupRequired) {
                ((InstrumentationHandler)instrumentationHandler).disposeInstrumenter(key, cleanupRequired);
            }

            @Override
            public void collectEnvServices(Set<Object> collectTo, Object languageShared, LanguageInfo info) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(languageShared);
                Instrumenter instrumenter = instrumentationHandler.forLanguage(info);
                collectTo.add(instrumenter);
                AllocationReporter allocationReporter = instrumentationHandler.getAllocationReporter(info);
                collectTo.add(allocationReporter);
            }

            @Override
            public <T> T getInstrumentationHandlerService(Object vm, Object key, Class<T> type) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)vm;
                return (T)instrumentationHandler.lookup(key, type);
            }

            @Override
            public void onFirstExecution(RootNode rootNode) {
                InstrumentationHandler handler = InstrumentImpl.getHandler(rootNode);
                if (handler != null) {
                    handler.onFirstExecution(rootNode);
                }
            }

            @Override
            public void onLoad(RootNode rootNode) {
                InstrumentationHandler handler = InstrumentImpl.getHandler(rootNode);
                if (handler != null) {
                    handler.onLoad(rootNode);
                }
            }

            public Iterable<Scope> findTopScopes(TruffleLanguage.Env env) {
                return TruffleInstrument.Env.findTopScopes(env);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void notifyContextCreated(Object engine, TruffleContext context) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(engine);
                instrumentationHandler.notifyContextCreated(context);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void notifyContextClosed(Object engine, TruffleContext context) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(engine);
                instrumentationHandler.notifyContextClosed(context);
            }

            @Override
            public void notifyLanguageContextCreated(Object engine, TruffleContext context, LanguageInfo info) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(engine);
                instrumentationHandler.notifyLanguageContextCreated(context, info);
            }

            @Override
            public void notifyLanguageContextInitialized(Object engine, TruffleContext context, LanguageInfo info) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(engine);
                instrumentationHandler.notifyLanguageContextInitialized(context, info);
            }

            @Override
            public void notifyLanguageContextFinalized(Object engine, TruffleContext context, LanguageInfo info) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(engine);
                instrumentationHandler.notifyLanguageContextFinalized(context, info);
            }

            @Override
            public void notifyLanguageContextDisposed(Object engine, TruffleContext context, LanguageInfo info) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(engine);
                instrumentationHandler.notifyLanguageContextDisposed(context, info);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void notifyThreadStarted(Object engine, TruffleContext context, Thread thread) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(engine);
                instrumentationHandler.notifyThreadStarted(context, thread);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void notifyThreadFinished(Object engine, TruffleContext context, Thread thread) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(engine);
                instrumentationHandler.notifyThreadFinished(context, thread);
            }

            @Override
            public org.graalvm.polyglot.SourceSection createSourceSection(Object instrumentEnv, Source source, SourceSection ss) {
                TruffleInstrument.Env env = (TruffleInstrument.Env)instrumentEnv;
                return AccessorInstrumentHandler.engineAccess().createSourceSection(env.getVMObject(), source, ss);
            }

            @Override
            public void patchInstrumentationHandler(Object vm, DispatchOutputStream out, DispatchOutputStream err, InputStream in) {
                InstrumentationHandler instrumentationHandler = (InstrumentationHandler)vm;
                instrumentationHandler.patch(out, err, in);
            }

            @Override
            public boolean isInputValueSlotIdentifier(Object identifier) {
                return identifier instanceof ProbeNode.EventProviderWithInputChainNode.SavedInputValueID;
            }

            private static InstrumentationHandler getHandler(RootNode rootNode) {
                LanguageInfo info = rootNode.getLanguageInfo();
                if (info == null) {
                    return null;
                }
                Object languageShared = AccessorInstrumentHandler.nodesAccess().getEngineObject(info);
                if (languageShared == null) {
                    return null;
                }
                return (InstrumentationHandler)AccessorInstrumentHandler.engineAccess().getInstrumentationHandler(languageShared);
            }
        }
    }

    private static final class WeakAsyncList<T>
    extends AbstractAsyncCollection<WeakReference<T>, T> {
        WeakAsyncList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected WeakReference<T> wrap(T element) {
            return new WeakReference<T>(element);
        }

        @Override
        protected T unwrap(WeakReference<T> element) {
            return element.get();
        }
    }

    private static final class EventBindingList<EB extends EventBinding<?>>
    extends AbstractAsyncCollection<EB, EB> {
        EventBindingList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected EB wrap(EB element) {
            return element;
        }

        @Override
        protected EB unwrap(EB element) {
            if (((EventBinding)element).isDisposed()) {
                return null;
            }
            return element;
        }
    }

    private static abstract class AbstractAsyncCollection<T, R>
    extends AbstractCollection<R> {
        private volatile AtomicReferenceArray<T> values;
        private int nextInsertionIndex;

        AbstractAsyncCollection(int initialCapacity) {
            if (initialCapacity <= 0) {
                throw new IllegalArgumentException("Invalid initial capacity " + initialCapacity);
            }
            this.values = new AtomicReferenceArray(initialCapacity);
        }

        @Override
        public final synchronized boolean add(R reference) {
            T wrappedElement = this.wrap(reference);
            if (wrappedElement == null) {
                throw new NullPointerException();
            }
            if (this.nextInsertionIndex >= this.values.length()) {
                this.compact();
            }
            this.values.set(this.nextInsertionIndex++, wrappedElement);
            return true;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean isEmpty() {
            return this.values.get(0) == null;
        }

        protected abstract T wrap(R var1);

        protected abstract R unwrap(T var1);

        private void compact() {
            T ref;
            T ref2;
            AtomicReferenceArray<T> localValues = this.values;
            int liveElements = 0;
            for (int i = 0; i < localValues.length() && (ref2 = localValues.get(i)) != null; ++i) {
                if (this.unwrap(ref2) == null) continue;
                ++liveElements;
            }
            AtomicReferenceArray<T> newValues = new AtomicReferenceArray<T>(Math.max(liveElements * 2, 8));
            int index = 0;
            for (int i = 0; i < localValues.length() && (ref = localValues.get(i)) != null; ++i) {
                if (this.unwrap(ref) == null) continue;
                newValues.set(index++, ref);
            }
            this.nextInsertionIndex = index;
            this.values = newValues;
        }

        @Override
        public Iterator<R> iterator() {
            return new Iterator<R>(){
                private final AtomicReferenceArray<T> values;
                private int index;
                private R queuedNext;
                {
                    this.values = values;
                }

                @Override
                public boolean hasNext() {
                    Object next = this.queuedNext;
                    if (next == null) {
                        this.queuedNext = next = this.queueNext();
                    }
                    return next != null;
                }

                private R queueNext() {
                    Object localValue;
                    Object alive;
                    int localIndex = this.index;
                    AtomicReferenceArray array = this.values;
                    do {
                        if (localIndex >= array.length()) {
                            return null;
                        }
                        localValue = array.get(localIndex);
                        if (localValue == null) {
                            return null;
                        }
                        ++localIndex;
                    } while ((alive = this.unwrap(localValue)) == null);
                    this.index = localIndex;
                    return alive;
                }

                @Override
                public R next() {
                    Object next = this.queuedNext;
                    if (next == null && (next = this.queueNext()) == null) {
                        throw new NoSuchElementException();
                    }
                    this.queuedNext = null;
                    return next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    abstract class AbstractInstrumenter
    extends Instrumenter {
        AbstractInstrumenter() {
        }

        abstract void doFinalize();

        abstract void dispose();

        abstract <T> T lookup(InstrumentationHandler var1, Class<T> var2);

        public void disposeBinding(EventBinding<?> binding) {
            InstrumentationHandler.this.disposeBinding(binding);
        }

        abstract boolean isInstrumentableRoot(RootNode var1);

        abstract boolean isInstrumentableSource(com.oracle.truffle.api.source.Source var1);

        final Set<Class<?>> queryTagsImpl(Node node, LanguageInfo onlyLanguage) {
            SourceSection sourceSection = node.getSourceSection();
            if (!InstrumentationHandler.isInstrumentableNode(node, sourceSection)) {
                return Collections.emptySet();
            }
            RootNode root = node.getRootNode();
            if (root == null) {
                return Collections.emptySet();
            }
            if (onlyLanguage != null && root.getLanguageInfo() != onlyLanguage) {
                throw new IllegalArgumentException("The language instrumenter cannot query tags of nodes of other languages.");
            }
            Set<Class<?>> providedTags = InstrumentationHandler.this.getProvidedTags(root);
            if (providedTags.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet tags = new HashSet();
            for (Class<?> providedTag : providedTags) {
                if (!InstrumentationHandler.hasTagImpl(providedTags, node, providedTag)) continue;
                tags.add(providedTag);
            }
            return Collections.unmodifiableSet(tags);
        }

        @Override
        public <T extends ExecutionEventNodeFactory> EventBinding<T> attachExecutionEventFactory(SourceSectionFilter filter, SourceSectionFilter inputFilter, T factory) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachFactory(this, filter, inputFilter, factory);
        }

        @Override
        public <T extends ExecutionEventListener> EventBinding<T> attachExecutionEventListener(SourceSectionFilter filter, SourceSectionFilter inputFilter, T listener) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachListener(this, filter, inputFilter, listener);
        }

        @Override
        public <T extends LoadSourceListener> EventBinding<T> attachLoadSourceListener(SourceSectionFilter filter, T listener, boolean includeExistingSources) {
            this.verifySourceOnly(filter);
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachSourceListener(this, filter, listener, includeExistingSources);
        }

        @Override
        public <T extends LoadSourceListener> EventBinding<T> attachLoadSourceListener(SourceFilter filter, T listener, boolean notifyLoaded) {
            SourceSectionFilter sectionsFilter = SourceSectionFilter.newBuilder().sourceFilter(filter).build();
            return this.attachLoadSourceListener(sectionsFilter, listener, notifyLoaded);
        }

        @Override
        public <T extends LoadSourceSectionListener> EventBinding<T> attachLoadSourceSectionListener(SourceSectionFilter filter, T listener, boolean notifyLoaded) {
            this.verifyFilter(filter);
            return InstrumentationHandler.this.attachSourceSectionListener(this, filter, listener, notifyLoaded);
        }

        @Override
        public void visitLoadedSourceSections(SourceSectionFilter filter, LoadSourceSectionListener listener) {
            this.verifyFilter(filter);
            InstrumentationHandler.this.visitLoadedSourceSections(this, filter, listener);
        }

        @Override
        public <T extends ExecuteSourceListener> EventBinding<T> attachExecuteSourceListener(SourceFilter filter, T listener, boolean notifyLoaded) {
            SourceSectionFilter sectionsFilter = SourceSectionFilter.newBuilder().sourceFilter(filter).build();
            return InstrumentationHandler.this.attachExecuteSourceListener(this, sectionsFilter, listener, notifyLoaded);
        }

        @Override
        public <T extends AllocationListener> EventBinding<T> attachAllocationListener(AllocationEventFilter filter, T listener) {
            return InstrumentationHandler.this.attachAllocationListener(this, filter, listener);
        }

        @Override
        public <T extends OutputStream> EventBinding<T> attachOutConsumer(T stream) {
            return InstrumentationHandler.this.attachOutputConsumer(this, stream, false);
        }

        @Override
        public <T extends OutputStream> EventBinding<T> attachErrConsumer(T stream) {
            return InstrumentationHandler.this.attachOutputConsumer(this, stream, true);
        }

        private void verifySourceOnly(SourceSectionFilter filter) {
            if (!filter.isSourceOnly()) {
                throw new IllegalArgumentException(String.format("The attached filter %s uses filters that require source sections to verifiy. Source listeners can only use filter critera based on Source objects like mimeTypeIs or sourceIs.", filter));
            }
        }

        abstract void verifyFilter(SourceSectionFilter var1);
    }

    final class LanguageClientInstrumenter<T>
    extends AbstractInstrumenter {
        private final LanguageInfo languageInfo;

        LanguageClientInstrumenter(LanguageInfo info) {
            this.languageInfo = info;
        }

        @Override
        boolean isInstrumentableSource(com.oracle.truffle.api.source.Source source) {
            String mimeType = source.getMimeType();
            if (mimeType == null) {
                return false;
            }
            return this.languageInfo.getMimeTypes().contains(mimeType);
        }

        @Override
        boolean isInstrumentableRoot(RootNode node) {
            LanguageInfo langInfo = node.getLanguageInfo();
            if (langInfo == null) {
                return false;
            }
            return langInfo == this.languageInfo;
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, this.languageInfo);
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
            Set<Class<?>> referencedTags;
            Set<Class<Class<?>>> providedTags = InstrumentationHandler.this.getProvidedTags(this.languageInfo);
            if (!providedTags.containsAll(referencedTags = filter.getReferencedTags())) {
                HashSet missingTags = new HashSet(referencedTags);
                missingTags.removeAll(providedTags);
                LinkedHashSet allTags = new LinkedHashSet(providedTags);
                allTags.addAll(missingTags);
                StringBuilder builder = new StringBuilder("{");
                String sep = "";
                for (Class clazz : allTags) {
                    builder.append(sep);
                    builder.append(clazz.getSimpleName());
                    sep = ", ";
                }
                builder.append("}");
                Accessor.Nodes langAccess = AccessorInstrumentHandler.nodesAccess();
                TruffleLanguage<?> truffleLanguage = langAccess.getLanguageSpi(this.languageInfo);
                throw new IllegalArgumentException(String.format("The attached filter %s references the following tags %s which are not declared as provided by the language. To fix this annotate the language class %s with @%s(%s).", filter, missingTags, truffleLanguage.getClass().getName(), ProvidedTags.class.getSimpleName(), builder));
            }
        }

        public <S extends ContextsListener> EventBinding<S> attachContextsListener(S listener, boolean includeActiveContexts) {
            throw new UnsupportedOperationException("Not supported in language instrumenter.");
        }

        public <S extends ThreadsListener> EventBinding<S> attachThreadsListener(S listener, boolean includeStartedThreads) {
            throw new UnsupportedOperationException("Not supported in language instrumenter.");
        }

        @Override
        void doFinalize() {
        }

        @Override
        void dispose() {
        }

        <S> S lookup(InstrumentationHandler handler, Class<S> type) {
            return null;
        }
    }

    final class EngineInstrumenter
    extends AbstractInstrumenter {
        EngineInstrumenter() {
        }

        @Override
        void doFinalize() {
        }

        @Override
        void dispose() {
        }

        @Override
        <T> T lookup(InstrumentationHandler handler, Class<T> type) {
            return null;
        }

        @Override
        boolean isInstrumentableRoot(RootNode rootNode) {
            return true;
        }

        @Override
        boolean isInstrumentableSource(com.oracle.truffle.api.source.Source source) {
            return true;
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, null);
        }

        @Override
        public <T extends ContextsListener> EventBinding<T> attachContextsListener(T listener, boolean includeActiveContexts) {
            throw new UnsupportedOperationException("Not supported in engine instrumenter.");
        }

        @Override
        public <T extends ThreadsListener> EventBinding<T> attachThreadsListener(T listener, boolean includeStartedThreads) {
            throw new UnsupportedOperationException("Not supported in engine instrumenter.");
        }
    }

    final class InstrumentClientInstrumenter
    extends AbstractInstrumenter {
        private final Class<?> instrumentClass;
        private Object[] services;
        private TruffleInstrument instrument;
        private final TruffleInstrument.Env env;

        InstrumentClientInstrumenter(TruffleInstrument.Env env, Class<?> instrumentClass) {
            this.instrumentClass = instrumentClass;
            this.env = env;
        }

        @Override
        boolean isInstrumentableSource(com.oracle.truffle.api.source.Source source) {
            return true;
        }

        @Override
        boolean isInstrumentableRoot(RootNode rootNode) {
            return true;
        }

        @Override
        public Set<Class<?>> queryTags(Node node) {
            return this.queryTagsImpl(node, null);
        }

        @Override
        void verifyFilter(SourceSectionFilter filter) {
        }

        Class<?> getInstrumentClass() {
            return this.instrumentClass;
        }

        TruffleInstrument.Env getEnv() {
            return this.env;
        }

        void create(String[] expectedServices) {
            if (TRACE) {
                InstrumentationHandler.trace("Create instrument %s class %s %n", this.instrument, this.instrumentClass);
            }
            this.services = this.env.onCreate(this.instrument);
            if (expectedServices != null && !TruffleOptions.AOT) {
                this.checkServices(expectedServices);
            }
            if (TRACE) {
                InstrumentationHandler.trace("Created instrument %s class %s %n", this.instrument, this.instrumentClass);
            }
        }

        private boolean checkServices(String[] expectedServices) {
            block0: for (String name : expectedServices) {
                for (Object obj : this.services) {
                    if (this.findType(name, obj.getClass())) continue block0;
                }
                InstrumentationHandler.failInstrumentInitialization(this.env, String.format("%s declares service %s but doesn't register it", this.instrumentClass.getName(), name), null);
            }
            return true;
        }

        private boolean findType(String name, Class<?> type) {
            if (type == null) {
                return false;
            }
            if (type.getName().equals(name) || type.getCanonicalName() != null && type.getCanonicalName().equals(name)) {
                return true;
            }
            if (this.findType(name, type.getSuperclass())) {
                return true;
            }
            for (Class<?> inter : type.getInterfaces()) {
                if (!this.findType(name, inter)) continue;
                return true;
            }
            return false;
        }

        boolean isInitialized() {
            return this.instrument != null;
        }

        TruffleInstrument getInstrument() {
            return this.instrument;
        }

        @Override
        public <T extends ContextsListener> EventBinding<T> attachContextsListener(T listener, boolean includeActiveContexts) {
            return InstrumentationHandler.this.attachContextsListener(this, listener, includeActiveContexts);
        }

        @Override
        public <T extends ThreadsListener> EventBinding<T> attachThreadsListener(T listener, boolean includeStartedThreads) {
            return InstrumentationHandler.this.attachThreadsListener(this, listener, includeStartedThreads);
        }

        @Override
        void doFinalize() {
            this.instrument.onFinalize(this.env);
        }

        @Override
        void dispose() {
            this.instrument.onDispose(this.env);
        }

        @Override
        <T> T lookup(InstrumentationHandler handler, Class<T> type) {
            if (this.services != null) {
                for (Object service : this.services) {
                    if (!type.isInstance(service)) continue;
                    return type.cast(service);
                }
            }
            return null;
        }
    }

    private final class NotifyLoadedListenerVisitor
    extends AbstractBindingsVisitor {
        NotifyLoadedListenerVisitor(Collection<EventBinding.Source<?>> bindings) {
            super(bindings, true);
        }

        @Override
        protected void visitInstrumented(EventBinding.Source<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.notifySourceSectionLoaded(binding, node, section);
        }
    }

    private final class NotifyLoadedWithBindingVisitor
    extends AbstractBindingVisitor {
        NotifyLoadedWithBindingVisitor(EventBinding.Source<?> binding) {
            super(binding);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.notifySourceSectionLoaded(this.binding, node, section);
        }
    }

    private final class DisposeWrappersWithBindingVisitor
    extends AbstractBindingsVisitor {
        DisposeWrappersWithBindingVisitor(Collection<EventBinding.Source<?>> bindings) {
            super(bindings, false);
        }

        @Override
        protected void visitInstrumented(EventBinding.Source<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.invalidateWrapper(node);
        }
    }

    private final class InsertWrappersVisitor
    extends AbstractBindingsVisitor {
        InsertWrappersVisitor(Collection<EventBinding.Source<?>> bindings) {
            super(bindings, false);
        }

        @Override
        protected void visitInstrumented(EventBinding.Source<?> binding, Node node, SourceSection section) {
            InstrumentationHandler.this.insertWrapper(node, section);
        }
    }

    private final class DisposeWrappersVisitor
    extends AbstractBindingVisitor {
        DisposeWrappersVisitor(EventBinding.Source<?> binding) {
            super(binding);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.invalidateWrapper(node);
        }
    }

    private final class InsertWrappersWithBindingVisitor
    extends AbstractBindingVisitor {
        InsertWrappersWithBindingVisitor(EventBinding.Source<?> filter) {
            super(filter);
        }

        @Override
        protected void visitInstrumented(Node node, SourceSection section) {
            InstrumentationHandler.this.insertWrapper(node, section);
        }
    }

    private abstract class AbstractBindingsVisitor
    extends AbstractNodeVisitor {
        private final Collection<EventBinding.Source<?>> bindings;
        private final boolean visitForEachBinding;

        AbstractBindingsVisitor(Collection<EventBinding.Source<?>> bindings, boolean visitForEachBinding) {
            this.bindings = bindings;
            this.visitForEachBinding = visitForEachBinding;
            HashSet compoundTags = null;
            for (EventBinding.Source<?> sourceBinding : bindings) {
                Set<Class<?>> limitedTags = sourceBinding.getLimitedTags();
                if (limitedTags == null) {
                    compoundTags = null;
                    break;
                }
                if (compoundTags == null) {
                    compoundTags = new HashSet();
                }
                compoundTags.addAll(limitedTags);
            }
            this.materializeLimitedTags = compoundTags != null ? Collections.unmodifiableSet(compoundTags) : null;
        }

        @Override
        boolean shouldVisit() {
            if (this.bindings.isEmpty()) {
                return false;
            }
            RootNode localRoot = this.root;
            SourceSection localRootSourceSection = this.rootSourceSection;
            int localRootBits = this.rootBits;
            for (EventBinding.Source<?> binding : this.bindings) {
                if (!binding.isInstrumentedRoot(this.providedTags, localRoot, localRootSourceSection, localRootBits)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected final void visitInstrumentable(Node parentInstrumentable, SourceSection parentSourceSection, Node instrumentableNode, SourceSection sourceSection) {
            for (EventBinding.Source<?> binding : this.bindings) {
                if (binding.isInstrumentedFull(this.providedTags, this.root, instrumentableNode, sourceSection) || binding.isChildInstrumentedFull(this.providedTags, this.root, parentInstrumentable, parentSourceSection, instrumentableNode, sourceSection)) {
                    if (TRACE) {
                        InstrumentationHandler.traceFilterCheck("hit", this.providedTags, binding, instrumentableNode, sourceSection);
                    }
                    this.visitInstrumented(binding, instrumentableNode, sourceSection);
                    if (this.visitForEachBinding) continue;
                    break;
                }
                if (!TRACE) continue;
                InstrumentationHandler.traceFilterCheck("miss", this.providedTags, binding, instrumentableNode, sourceSection);
            }
        }

        protected abstract void visitInstrumented(EventBinding.Source<?> var1, Node var2, SourceSection var3);
    }

    private abstract class AbstractBindingVisitor
    extends AbstractNodeVisitor {
        protected final EventBinding.Source<?> binding;

        AbstractBindingVisitor(EventBinding.Source<?> binding) {
            this.binding = binding;
            Set<Class<?>> limitedTags = binding.getLimitedTags();
            this.materializeLimitedTags = limitedTags != null ? Collections.unmodifiableSet(limitedTags) : null;
        }

        @Override
        boolean shouldVisit() {
            RootNode localRoot = this.root;
            SourceSection localRootSourceSection = this.rootSourceSection;
            int localRootBits = this.rootBits;
            return this.binding.isInstrumentedRoot(this.providedTags, localRoot, localRootSourceSection, localRootBits);
        }

        @Override
        protected final void visitInstrumentable(Node parentInstrumentable, SourceSection parentSourceSection, Node instrumentableNode, SourceSection sourceSection) {
            if (this.binding.isInstrumentedLeaf(this.providedTags, instrumentableNode, sourceSection) || this.binding.isChildInstrumentedLeaf(this.providedTags, this.root, parentInstrumentable, parentSourceSection, instrumentableNode, sourceSection)) {
                if (TRACE) {
                    InstrumentationHandler.traceFilterCheck("hit", this.providedTags, this.binding, instrumentableNode, sourceSection);
                }
                this.visitInstrumented(instrumentableNode, sourceSection);
            } else if (TRACE) {
                InstrumentationHandler.traceFilterCheck("miss", this.providedTags, this.binding, instrumentableNode, sourceSection);
            }
        }

        protected abstract void visitInstrumented(Node var1, SourceSection var2);
    }

    private static abstract class AbstractNodeVisitor
    implements NodeVisitor {
        RootNode root;
        SourceSection rootSourceSection;
        Set<Class<?>> providedTags;
        Set<?> materializeLimitedTags;
        int rootBits;
        int computingRootNodeBits;
        private Node savedParent;
        private SourceSection savedParentSourceSection;

        private AbstractNodeVisitor() {
        }

        abstract boolean shouldVisit();

        private void computeRootBits(SourceSection sourceSection) {
            int bits = this.computingRootNodeBits;
            if (RootNodeBits.isUninitialized(bits)) {
                return;
            }
            if (sourceSection != null) {
                if (RootNodeBits.isNoSourceSection(bits)) {
                    bits = RootNodeBits.setHasSourceSection(bits);
                }
                if (this.rootSourceSection != null) {
                    if (RootNodeBits.isSourceSectionsHierachical(bits) && (sourceSection.getCharIndex() < this.rootSourceSection.getCharIndex() || sourceSection.getCharEndIndex() > this.rootSourceSection.getCharEndIndex())) {
                        bits = RootNodeBits.setSourceSectionsUnstructured(bits);
                    }
                    if (RootNodeBits.isSameSource(bits) && this.rootSourceSection.getSource() != sourceSection.getSource()) {
                        bits = RootNodeBits.setHasDifferentSource(bits);
                    }
                } else {
                    bits = RootNodeBits.setSourceSectionsUnstructured(bits);
                    bits = RootNodeBits.setHasDifferentSource(bits);
                }
            }
            this.computingRootNodeBits = bits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean visit(Node originalNode) {
            Node node = originalNode;
            SourceSection sourceSection = node.getSourceSection();
            boolean instrumentable = InstrumentationHandler.isInstrumentableNode(node, sourceSection);
            Node previousParent = null;
            SourceSection previousParentSourceSection = null;
            if (instrumentable) {
                this.computeRootBits(sourceSection);
                node = this.materializeSyntaxNodes(node, sourceSection);
                this.visitInstrumentable(this.savedParent, this.savedParentSourceSection, node, sourceSection);
                previousParent = this.savedParent;
                previousParentSourceSection = this.savedParentSourceSection;
                this.savedParent = node;
                this.savedParentSourceSection = sourceSection;
            }
            try {
                NodeUtil.forEachChild(node, this);
            }
            finally {
                if (instrumentable) {
                    this.savedParent = previousParent;
                    this.savedParentSourceSection = previousParentSourceSection;
                }
            }
            return true;
        }

        private Node materializeSyntaxNodes(Node instrumentableNode, SourceSection sourceSection) {
            if (instrumentableNode instanceof InstrumentableNode) {
                InstrumentableNode currentNode = (InstrumentableNode)((Object)instrumentableNode);
                assert (currentNode.isInstrumentable());
                Set<Class<?>> materializeTags = this.materializeLimitedTags == null ? this.providedTags : this.materializeLimitedTags;
                InstrumentableNode materializedNode = currentNode.materializeInstrumentableNodes(materializeTags);
                if (currentNode != materializedNode) {
                    if (!(materializedNode instanceof Node)) {
                        throw new IllegalStateException("The returned materialized syntax node is not a Truffle Node.");
                    }
                    if (((Node)((Object)materializedNode)).getParent() != null) {
                        throw new IllegalStateException("The returned materialized syntax node is already adopted.");
                    }
                    SourceSection newSourceSection = ((Node)((Object)materializedNode)).getSourceSection();
                    if (!Objects.equals(sourceSection, newSourceSection)) {
                        throw new IllegalStateException(String.format("The source section of the materialized syntax node must match the source section of the original node. %s != %s.", sourceSection, newSourceSection));
                    }
                    return ((Node)((Object)currentNode)).replace((Node)((Object)materializedNode));
                }
            }
            return instrumentableNode;
        }

        protected abstract void visitInstrumentable(Node var1, SourceSection var2, Node var3, SourceSection var4);
    }

    private static class FindSourcesVisitor
    extends AbstractNodeVisitor {
        private final Map<com.oracle.truffle.api.source.Source, Void> sources;
        private final AtomicReference<Collection<com.oracle.truffle.api.source.Source>> sourcesListRef;
        private final List<com.oracle.truffle.api.source.Source> rootSources = new ArrayList<com.oracle.truffle.api.source.Source>(5);

        FindSourcesVisitor(Map<com.oracle.truffle.api.source.Source, Void> sources, AtomicReference<Collection<com.oracle.truffle.api.source.Source>> sourcesListRef) {
            this.sources = sources;
            this.sourcesListRef = sourcesListRef;
        }

        @Override
        boolean shouldVisit() {
            return true;
        }

        @Override
        protected void visitInstrumentable(Node parentInstrumentable, SourceSection parentSourceSection, Node instrumentableNode, SourceSection sourceSection) {
            if (sourceSection != null) {
                this.adoptSource(sourceSection.getSource());
            }
        }

        void adoptSource(com.oracle.truffle.api.source.Source source) {
            assert (Thread.holdsLock(this.sources));
            if (!this.sources.containsKey(source)) {
                this.sources.put(source, null);
                this.sourcesListRef.get().add(source);
                this.rootSources.add(source);
            }
        }

        com.oracle.truffle.api.source.Source[] getSources() {
            if (this.rootSources.isEmpty()) {
                return null;
            }
            com.oracle.truffle.api.source.Source[] sourcesArray = this.rootSources.toArray(new com.oracle.truffle.api.source.Source[this.rootSources.size()]);
            this.rootSources.clear();
            return sourcesArray;
        }
    }
}

