/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.instrumentation.AllocationEvent;
import com.oracle.truffle.api.instrumentation.AllocationListener;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.PropChangeSupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LanguageInfo;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedList;

public final class AllocationReporter {
    public static final long SIZE_UNKNOWN = Long.MIN_VALUE;
    public static final String PROPERTY_ACTIVE = "active";
    final LanguageInfo language;
    private final PropChangeSupport propSupport = new PropChangeSupport(this);
    private final ThreadLocal<LinkedList<Reference<Object>>> valueCheck;
    @CompilerDirectives.CompilationFinal
    private volatile Assumption listenersNotChangedAssumption = Truffle.getRuntime().createAssumption();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private volatile AllocationListener[] listeners = null;

    AllocationReporter(LanguageInfo language) {
        this.language = language;
        boolean assertions = false;
        if (!$assertionsDisabled) {
            assertions = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        this.valueCheck = assertions ? new ThreadLocal() : null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propSupport.removePropertyChangeListener(listener);
    }

    public boolean isActive() {
        if (!this.listenersNotChangedAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        return this.listeners != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(AllocationListener l) {
        boolean hadListeners;
        CompilerAsserts.neverPartOfCompilation();
        AllocationReporter allocationReporter = this;
        synchronized (allocationReporter) {
            if (this.listeners == null) {
                this.listeners = new AllocationListener[]{l};
                hadListeners = false;
            } else {
                int index = this.listeners.length;
                AllocationListener[] newListeners = Arrays.copyOf(this.listeners, index + 1);
                newListeners[index] = l;
                this.listeners = newListeners;
                hadListeners = true;
            }
            Assumption assumption = this.listenersNotChangedAssumption;
            this.listenersNotChangedAssumption = Truffle.getRuntime().createAssumption();
            assumption.invalidate();
        }
        if (!hadListeners) {
            this.propSupport.firePropertyChange(PROPERTY_ACTIVE, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(AllocationListener l) {
        CompilerAsserts.neverPartOfCompilation();
        boolean hasListeners = true;
        AllocationReporter allocationReporter = this;
        synchronized (allocationReporter) {
            block8: {
                int len;
                block7: {
                    len = this.listeners.length;
                    if (len != 1) break block7;
                    if (this.listeners[0] != l) break block8;
                    this.listeners = null;
                    hasListeners = false;
                    break block8;
                }
                for (int i = 0; i < len; ++i) {
                    if (this.listeners[i] != l) continue;
                    if (i == len - 1) {
                        this.listeners = Arrays.copyOf(this.listeners, i);
                        break;
                    }
                    if (i == 0) {
                        this.listeners = Arrays.copyOfRange(this.listeners, 1, len);
                        break;
                    }
                    AllocationListener[] newListeners = new AllocationListener[len - 1];
                    System.arraycopy(this.listeners, 0, newListeners, 0, i);
                    System.arraycopy(this.listeners, i + 1, newListeners, i, len - i - 1);
                    this.listeners = newListeners;
                    break;
                }
            }
            Assumption assumption = this.listenersNotChangedAssumption;
            this.listenersNotChangedAssumption = Truffle.getRuntime().createAssumption();
            assumption.invalidate();
        }
        if (!hasListeners) {
            this.propSupport.firePropertyChange(PROPERTY_ACTIVE, true, false);
        }
    }

    public void onEnter(Object valueToReallocate, long oldSize, long newSizeEstimate) {
        if (this.valueCheck != null) {
            AllocationReporter.enterSizeCheck(valueToReallocate, oldSize, newSizeEstimate);
            if (valueToReallocate != null) {
                AllocationReporter.allocateValueCheck(valueToReallocate);
            }
        }
        this.notifyAllocateOrReallocate(valueToReallocate, oldSize, newSizeEstimate);
    }

    @ExplodeLoop
    private void notifyAllocateOrReallocate(Object value, long oldSize, long newSizeEstimate) {
        AllocationListener[] ls;
        if (this.valueCheck != null) {
            this.setValueCheck(value);
        }
        CompilerAsserts.partialEvaluationConstant(this);
        if (!this.listenersNotChangedAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        if ((ls = this.listeners) != null) {
            AllocationEvent event = new AllocationEvent(this.language, value, oldSize, newSizeEstimate);
            for (AllocationListener l : ls) {
                l.onEnter(event);
            }
        }
    }

    public void onReturnValue(Object value, long oldSize, long newSize) {
        if (this.valueCheck != null) {
            AllocationReporter.allocateValueCheck(value);
            this.allocatedCheck(value, oldSize, newSize);
        }
        this.notifyAllocated(value, oldSize, newSize);
    }

    @ExplodeLoop
    private void notifyAllocated(Object value, long oldSize, long newSize) {
        AllocationListener[] ls;
        CompilerAsserts.partialEvaluationConstant(this);
        if (!this.listenersNotChangedAssumption.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
        if ((ls = this.listeners) != null) {
            AllocationEvent event = new AllocationEvent(this.language, value, oldSize, newSize);
            for (AllocationListener l : ls) {
                l.onReturnValue(event);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void enterSizeCheck(Object valueToReallocate, long oldSize, long newSizeEstimate) {
        assert (newSizeEstimate == Long.MIN_VALUE || newSizeEstimate > 0L) : "Wrong new size estimate = " + newSizeEstimate;
        assert (valueToReallocate != null || oldSize == 0L) : "Old size must be 0 for new allocations. Was: " + oldSize;
        assert (valueToReallocate == null || oldSize > 0L || oldSize == Long.MIN_VALUE) : "Old size of a re-allocated value must be positive or unknown. Was: " + oldSize;
    }

    @CompilerDirectives.TruffleBoundary
    private boolean setValueCheck(Object value) {
        LinkedList<Reference<Object>> list = this.valueCheck.get();
        if (list == null) {
            list = new LinkedList();
            this.valueCheck.set(list);
        }
        list.add(new WeakReference<Object>(value));
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static void allocateValueCheck(Object value) {
        if (value == null) {
            throw new NullPointerException("No allocated value.");
        }
        if (value instanceof String) {
            return;
        }
        if (value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double) {
            return;
        }
        boolean isTO = InstrumentationHandler.ACCESSOR.isTruffleObject(value);
        assert (isTO) : "Wrong value class, TruffleObject is required. Was: " + value.getClass().getName();
    }

    @CompilerDirectives.TruffleBoundary
    private void allocatedCheck(Object value, long oldSize, long newSize) {
        assert (value != null) : "Allocated value must not be null.";
        LinkedList<Reference<Object>> list = this.valueCheck.get();
        assert (list != null && !list.isEmpty()) : "onEnter() was not called";
        Object orig = list.removeLast().get();
        assert (orig == null || orig == value) : "A different reallocated value. Was: " + orig + " now is: " + value;
        assert (orig == null && oldSize == 0L || orig != null) : "Old size must be 0 for new allocations. Was: " + oldSize;
        assert (orig != null && (oldSize > 0L || oldSize == Long.MIN_VALUE) || orig == null) : "Old size of a re-allocated value must be positive or unknown. Was: " + oldSize;
        assert (newSize == Long.MIN_VALUE || newSize > 0L) : "New value size must be positive or unknown. Was: " + newSize;
    }
}

