/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug.impl;

import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.vm.PolyglotEngine;
import com.oracle.truffle.api.vm.PolyglotRuntime;

public final class DebuggerInstrument
extends TruffleInstrument {
    static final String ID = "debugger";
    private static DebuggerFactory factory;

    @Override
    protected void onCreate(TruffleInstrument.Env env) {
        env.registerService(factory.create(env));
    }

    @Deprecated
    public static Debugger getDebugger(PolyglotEngine engine) {
        PolyglotRuntime.Instrument instrument = engine.getRuntime().getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Debugger is not installed.");
        }
        instrument.setEnabled(true);
        return instrument.lookup(Debugger.class);
    }

    public static void setFactory(DebuggerFactory factory) {
        if (factory == null || !factory.getClass().getName().startsWith("com.oracle.truffle.api.debug")) {
            throw new IllegalArgumentException("Wrong factory: " + factory);
        }
        DebuggerInstrument.factory = factory;
    }

    static {
        try {
            Class.forName(Debugger.class.getName(), true, Debugger.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static interface DebuggerFactory {
        public Debugger create(TruffleInstrument.Env var1);
    }
}

