/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Iterator;

public final class DebugStackTraceElement {
    private final Debugger debugger;
    final TruffleStackTraceElement traceElement;
    private StackTraceElement stackTrace;

    DebugStackTraceElement(Debugger debugger, TruffleStackTraceElement traceElement) {
        this.debugger = debugger;
        this.traceElement = traceElement;
    }

    public boolean isInternal() {
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return true;
        }
        return root.isInternal();
    }

    public String getName() {
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return null;
        }
        try {
            return root.getName();
        }
        catch (Throwable e) {
            try {
                assert (false);
            }
            catch (AssertionError e1) {
                throw e;
            }
            return null;
        }
    }

    public SourceSection getSourceSection() {
        Node node = this.traceElement.getLocation();
        if (node != null) {
            return node.getEncapsulatingSourceSection();
        }
        return null;
    }

    public DebugScope getScope() {
        Node node = this.traceElement.getLocation();
        if (node == null) {
            return null;
        }
        RootNode root = node.getRootNode();
        if (root.getLanguageInfo() == null) {
            return null;
        }
        Frame elementFrame = this.traceElement.getFrame();
        MaterializedFrame frame = elementFrame != null ? elementFrame.materialize() : null;
        Iterable<Scope> scopes = this.debugger.getEnv().findLocalScopes(node, frame);
        Iterator<Scope> it = scopes.iterator();
        if (!it.hasNext()) {
            return null;
        }
        return new DebugScope(it.next(), it, this.debugger, null, frame, root);
    }

    DebugValue wrapHeapValue(Object result) {
        LanguageInfo language = this.getLanguage();
        return new DebugValue.HeapValue(this.debugger, language, null, result);
    }

    LanguageInfo getLanguage() {
        RootNode root = this.findCurrentRoot();
        LanguageInfo language = root != null ? root.getLanguageInfo() : null;
        return language;
    }

    RootNode findCurrentRoot() {
        Node node = this.traceElement.getLocation();
        if (node != null) {
            return node.getRootNode();
        }
        RootCallTarget target = this.traceElement.getTarget();
        return target.getRootNode();
    }

    StackTraceElement toTraceElement() {
        if (this.stackTrace == null) {
            SourceSection sourceLocation;
            LanguageInfo language = this.getLanguage();
            String declaringClass = language != null ? "<" + language.getId() + ">" : "<unknown>";
            String methodName = this.getName();
            if (methodName == null) {
                methodName = "";
            }
            String fileName = (sourceLocation = this.getSourceSection()) != null ? sourceLocation.getSource().getName() : "Unknown";
            int startLine = sourceLocation != null ? sourceLocation.getStartLine() : -1;
            this.stackTrace = new StackTraceElement(declaringClass, methodName, fileName, startLine);
        }
        return this.stackTrace;
    }
}

