/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.debug.BreakpointExceptionFilter;
import com.oracle.truffle.api.debug.BreakpointLocation;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerNode;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SetThreadSuspensionEnabledNode;
import com.oracle.truffle.api.debug.SetThreadSuspensionEnabledNodeGen;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.debug.SuppressFBWarnings;
import com.oracle.truffle.api.debug.SuspendAnchor;
import com.oracle.truffle.api.debug.SuspensionFilter;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecuteSourceEvent;
import com.oracle.truffle.api.instrumentation.ExecuteSourceListener;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.SourceFilter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class Breakpoint {
    private static final Breakpoint BUILDER_INSTANCE = new Breakpoint();
    private final SuspendAnchor suspendAnchor;
    private final BreakpointLocation locationKey;
    private final boolean oneShot;
    private final BreakpointExceptionFilter exceptionFilter;
    private final ResolveListener resolveListener;
    private volatile Debugger debugger;
    private final List<DebuggerSession> sessions = new LinkedList<DebuggerSession>();
    private volatile Assumption sessionsUnchanged;
    private volatile boolean enabled;
    private volatile boolean resolved;
    private volatile int ignoreCount;
    private volatile boolean disposed;
    private volatile String condition;
    private volatile boolean global;
    private volatile GlobalBreakpoint roWrapper;
    private final AtomicLong hitCount = new AtomicLong();
    private volatile Assumption conditionUnchanged;
    private volatile Assumption conditionExistsUnchanged;
    private volatile EventBinding<? extends ExecutionEventNodeFactory> breakpointBinding;
    private EventBinding<?> sourceBinding;

    Breakpoint(BreakpointLocation key, SuspendAnchor suspendAnchor) {
        this(key, suspendAnchor, false, null, null);
    }

    private Breakpoint(BreakpointLocation key, SuspendAnchor suspendAnchor, boolean oneShot, BreakpointExceptionFilter exceptionFilter, ResolveListener resolveListener) {
        this.locationKey = key;
        this.suspendAnchor = suspendAnchor;
        this.oneShot = oneShot;
        this.exceptionFilter = exceptionFilter;
        this.resolveListener = resolveListener;
        this.enabled = true;
    }

    private Breakpoint() {
        this.locationKey = null;
        this.suspendAnchor = SuspendAnchor.BEFORE;
        this.oneShot = false;
        this.exceptionFilter = null;
        this.resolveListener = null;
    }

    public Kind getKind() {
        if (this.locationKey == null) {
            return Kind.HALT_INSTRUCTION;
        }
        if (this.exceptionFilter == null) {
            return Kind.SOURCE_LOCATION;
        }
        return Kind.EXCEPTION;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        if (this.disposed) {
            return;
        }
        if (this.enabled != enabled) {
            if (!this.sessions.isEmpty()) {
                if (enabled) {
                    this.install();
                } else {
                    this.uninstall();
                }
            }
            this.enabled = enabled;
        }
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public synchronized void setCondition(String expression) {
        boolean existsChanged = this.condition == null != (expression == null);
        this.condition = expression;
        Assumption assumption = this.conditionUnchanged;
        if (assumption != null) {
            this.conditionUnchanged = null;
            assumption.invalidate();
        }
        if (existsChanged && (assumption = this.conditionExistsUnchanged) != null) {
            this.conditionExistsUnchanged = null;
            assumption.invalidate();
        }
    }

    @SuppressFBWarnings(value={"UG"})
    public String getCondition() {
        return this.condition;
    }

    public synchronized void dispose() {
        if (!this.disposed) {
            this.setEnabled(false);
            if (this.sourceBinding != null) {
                this.sourceBinding.dispose();
                this.sourceBinding = null;
            }
            for (DebuggerSession session : this.sessions) {
                session.disposeBreakpoint(this);
            }
            if (this.debugger != null) {
                this.debugger.disposeBreakpoint(this);
                this.debugger = null;
            }
            this.disposed = true;
        }
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    public int getIgnoreCount() {
        return this.ignoreCount;
    }

    public void setIgnoreCount(int ignoreCount) {
        this.ignoreCount = ignoreCount;
    }

    public int getHitCount() {
        return (int)this.hitCount.get();
    }

    public String getLocationDescription() {
        return this.locationKey.toString();
    }

    public SuspendAnchor getSuspendAnchor() {
        return this.suspendAnchor;
    }

    public boolean isModifiable() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    DebuggerNode lookupNode(EventContext context) {
        if (!this.isEnabled()) {
            return null;
        }
        EventBinding<? extends ExecutionEventNodeFactory> binding = this.breakpointBinding;
        if (binding != null) {
            return (DebuggerNode)context.lookupExecutionEventNode(binding);
        }
        return null;
    }

    private synchronized Assumption getConditionUnchanged() {
        if (this.conditionUnchanged == null) {
            this.conditionUnchanged = Truffle.getRuntime().createAssumption("Breakpoint condition unchanged.");
        }
        return this.conditionUnchanged;
    }

    private synchronized Assumption getConditionExistsUnchanged() {
        if (this.conditionExistsUnchanged == null) {
            this.conditionExistsUnchanged = Truffle.getRuntime().createAssumption("Breakpoint condition existence unchanged.");
        }
        return this.conditionExistsUnchanged;
    }

    synchronized void installGlobal(Debugger d) {
        if (this.disposed) {
            throw new IllegalArgumentException("Cannot install breakpoint, it is disposed already.");
        }
        if (this.debugger != null) {
            throw new IllegalStateException("Breakpoint is already installed in a Debugger instance.");
        }
        this.install(d);
        this.global = true;
    }

    private void install(Debugger d) {
        assert (Thread.holdsLock(this));
        if (this.debugger != null && this.debugger != d) {
            throw new IllegalStateException("Breakpoint is already installed in a different Debugger instance.");
        }
        this.debugger = d;
        if (this.exceptionFilter != null) {
            this.exceptionFilter.setDebugger(d);
        }
    }

    synchronized boolean install(DebuggerSession d, boolean failOnError) {
        if (this.disposed) {
            if (failOnError) {
                throw new IllegalArgumentException("Cannot install breakpoint, it is disposed already.");
            }
            return false;
        }
        if (this.sessions.contains(d)) {
            if (failOnError) {
                throw new IllegalStateException("Breakpoint is already installed in the session.");
            }
            return true;
        }
        this.install(d.getDebugger());
        this.sessions.add(d);
        this.sessionsAssumptionInvalidate();
        if (this.enabled) {
            this.install();
        }
        return true;
    }

    private void install() {
        SourceFilter filter;
        assert (Thread.holdsLock(this));
        if (this.sourceBinding == null && (filter = this.locationKey.createSourceFilter()) != null) {
            final boolean[] sourceResolved = new boolean[]{false};
            this.sourceBinding = this.debugger.getInstrumenter().attachExecuteSourceListener(filter, new ExecuteSourceListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onExecute(ExecuteSourceEvent event) {
                    if (sourceResolved[0]) {
                        return;
                    }
                    sourceResolved[0] = true;
                    Breakpoint breakpoint = Breakpoint.this;
                    synchronized (breakpoint) {
                        if (Breakpoint.this.sourceBinding != null) {
                            Breakpoint.this.sourceBinding.dispose();
                        }
                    }
                    Source source = event.getSource();
                    SourceSection location = Breakpoint.this.locationKey.adjustLocation(source, Breakpoint.this.debugger.getEnv(), Breakpoint.this.suspendAnchor);
                    if (location != null) {
                        Breakpoint.this.resolveBreakpoint(location);
                    }
                    SourceSectionFilter locationFilter = Breakpoint.this.locationKey.createLocationFilter(source, Breakpoint.this.suspendAnchor);
                    Breakpoint.this.breakpointBinding = Breakpoint.this.createBinding(locationFilter);
                }
            }, true);
            if (sourceResolved[0]) {
                this.sourceBinding.dispose();
            }
        } else if (this.breakpointBinding == null && (this.sourceBinding == null || this.sourceBinding.isDisposed())) {
            this.resolved = true;
            SourceSectionFilter locationFilter = this.locationKey.createLocationFilter(null, this.suspendAnchor);
            this.breakpointBinding = this.createBinding(locationFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventBinding<? extends ExecutionEventNodeFactory> createBinding(SourceSectionFilter locationFilter) {
        EventBinding<BreakpointNodeFactory> binding = this.debugger.getInstrumenter().attachExecutionEventFactory(locationFilter, new BreakpointNodeFactory());
        Breakpoint breakpoint = this;
        synchronized (breakpoint) {
            for (DebuggerSession s : this.sessions) {
                s.allBindings.add(binding);
            }
        }
        return binding;
    }

    boolean isGlobal() {
        return this.global;
    }

    synchronized void sessionClosed(DebuggerSession d) {
        this.sessions.remove(d);
        this.sessionsAssumptionInvalidate();
        if (this.sessions.isEmpty()) {
            this.uninstall();
        }
    }

    private void sessionsAssumptionInvalidate() {
        assert (Thread.holdsLock(this));
        Assumption assumption = this.sessionsUnchanged;
        if (assumption != null) {
            this.sessionsUnchanged = null;
            assumption.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveBreakpoint(SourceSection resolvedLocation) {
        boolean notifyResolved = false;
        Breakpoint breakpoint = this;
        synchronized (breakpoint) {
            if (this.disposed) {
                return;
            }
            if (!this.isResolved()) {
                notifyResolved = true;
                this.resolved = true;
            }
        }
        if (notifyResolved && this.resolveListener != null) {
            this.resolveListener.breakpointResolved(this, resolvedLocation);
        }
    }

    private void uninstall() {
        assert (Thread.holdsLock(this));
        EventBinding<? extends ExecutionEventNodeFactory> binding = this.breakpointBinding;
        this.breakpointBinding = null;
        for (DebuggerSession s : this.sessions) {
            s.allBindings.remove(binding);
        }
        if (binding != null) {
            binding.dispose();
        }
        this.resolved = false;
    }

    boolean notifyIndirectHit(DebuggerNode source, DebuggerNode node, MaterializedFrame frame, DebugException exception) throws BreakpointConditionFailure {
        if (!this.isEnabled()) {
            return false;
        }
        assert (node.getBreakpoint() == this);
        if (source != node) {
            if (!((AbstractBreakpointNode)node).testCondition(frame)) {
                return false;
            }
            if (this.exceptionFilter != null && exception != null) {
                Throwable throwable = (Throwable)((Object)exception.getTruffleException());
                assert (throwable != null);
                BreakpointExceptionFilter.Match matched = this.exceptionFilter.matchException(node, throwable);
                if (!matched.isMatched) {
                    return false;
                }
            }
            if (this.hitCount.incrementAndGet() <= (long)this.ignoreCount) {
                return false;
            }
        }
        if (this.isOneShot()) {
            this.setEnabled(false);
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private void doBreak(DebuggerNode source, DebuggerSession[] breakInSessions, MaterializedFrame frame, boolean onEnter, Object result, Throwable exception, BreakpointConditionFailure failure) {
        DebugException de = exception != null ? new DebugException(this.debugger, (TruffleException)((Object)exception), null, source, false, null) : null;
        this.doBreak(source, breakInSessions, frame, onEnter, result, de, failure);
    }

    @CompilerDirectives.TruffleBoundary
    private void doBreak(DebuggerNode source, DebuggerSession[] breakInSessions, MaterializedFrame frame, boolean onEnter, Object result, DebugException exception, BreakpointConditionFailure failure) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.hitCount.incrementAndGet() <= (long)this.ignoreCount) {
            return;
        }
        SuspendAnchor anchor = onEnter ? SuspendAnchor.BEFORE : SuspendAnchor.AFTER;
        for (DebuggerSession session : breakInSessions) {
            if (!session.isBreakpointsActive(this.getKind())) continue;
            session.notifyCallback(source, frame, anchor, null, result, exception, failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Breakpoint getROWrapper() {
        assert (this.global);
        GlobalBreakpoint wrapper = this.roWrapper;
        if (wrapper == null) {
            Breakpoint breakpoint = this;
            synchronized (breakpoint) {
                wrapper = this.roWrapper;
                if (wrapper == null) {
                    this.roWrapper = wrapper = new GlobalBreakpoint(this);
                }
            }
        }
        return wrapper;
    }

    public static Builder newBuilder(URI sourceUri) {
        Breakpoint breakpoint = BUILDER_INSTANCE;
        breakpoint.getClass();
        return breakpoint.new Builder(sourceUri);
    }

    public static Builder newBuilder(Source source) {
        Breakpoint breakpoint = BUILDER_INSTANCE;
        breakpoint.getClass();
        return breakpoint.new Builder(source);
    }

    public static Builder newBuilder(SourceSection sourceSection) {
        Breakpoint breakpoint = BUILDER_INSTANCE;
        breakpoint.getClass();
        return breakpoint.new Builder(sourceSection);
    }

    public static ExceptionBuilder newExceptionBuilder(boolean caught, boolean uncaught) {
        if (!caught && !uncaught) {
            throw new IllegalArgumentException("At least one of 'caught' or 'uncaught' needs to be true.");
        }
        Breakpoint breakpoint = BUILDER_INSTANCE;
        breakpoint.getClass();
        return breakpoint.new ExceptionBuilder(caught, uncaught);
    }

    @CompilerDirectives.TruffleBoundary
    private static List<DebuggerSession> removeDuplicateSession(DebuggerSession[] sessions, DebuggerSession session, List<DebuggerSession> nonDuplicateSessionsList) {
        List<DebuggerSession> nonDuplicateSessions = nonDuplicateSessionsList;
        if (nonDuplicateSessions == null) {
            nonDuplicateSessions = new ArrayList<DebuggerSession>(sessions.length);
            for (DebuggerSession s : sessions) {
                if (s == session) continue;
                nonDuplicateSessions.add(s);
            }
        } else {
            nonDuplicateSessions.remove(session);
        }
        return nonDuplicateSessions;
    }

    @CompilerDirectives.TruffleBoundary
    private static DebuggerSession[] toSessionsArray(List<DebuggerSession> sessions) {
        return sessions.toArray(new DebuggerSession[sessions.size()]);
    }

    static final class GlobalBreakpoint
    extends Breakpoint {
        private final Breakpoint delegate;

        GlobalBreakpoint(Breakpoint delegate) {
            this.delegate = delegate;
        }

        @Override
        public void dispose() {
            GlobalBreakpoint.fail();
        }

        @Override
        public void setCondition(String expression) {
            GlobalBreakpoint.fail();
        }

        @Override
        public void setEnabled(boolean enabled) {
            GlobalBreakpoint.fail();
        }

        @Override
        public void setIgnoreCount(int ignoreCount) {
            GlobalBreakpoint.fail();
        }

        private static void fail() {
            throw new IllegalStateException("Unmodifiable breakpoint.");
        }

        @Override
        public boolean isModifiable() {
            return false;
        }

        @Override
        public String getCondition() {
            return this.delegate.getCondition();
        }

        @Override
        public int getHitCount() {
            return this.delegate.getHitCount();
        }

        @Override
        public int getIgnoreCount() {
            return this.delegate.getIgnoreCount();
        }

        @Override
        public String getLocationDescription() {
            return this.delegate.getLocationDescription();
        }

        @Override
        public SuspendAnchor getSuspendAnchor() {
            return this.delegate.getSuspendAnchor();
        }

        @Override
        public boolean isDisposed() {
            return this.delegate.isDisposed();
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        @Override
        public boolean isOneShot() {
            return this.delegate.isOneShot();
        }

        @Override
        public boolean isResolved() {
            return this.delegate.isResolved();
        }
    }

    private static class ConditionalBreakNode
    extends Node {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private final EventContext context;
        private final Breakpoint breakpoint;
        @Node.Child
        private SetThreadSuspensionEnabledNode suspensionEnabledNode = SetThreadSuspensionEnabledNodeGen.create();
        @Node.Child
        private DirectCallNode conditionCallNode;
        @Node.Child
        private ExecutableNode conditionSnippet;
        @CompilerDirectives.CompilationFinal
        private Assumption conditionUnchanged;

        ConditionalBreakNode(EventContext context, Breakpoint breakpoint) {
            this.context = context;
            this.breakpoint = breakpoint;
            this.conditionUnchanged = breakpoint.getConditionUnchanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean executeBreakCondition(VirtualFrame frame, DebuggerSession[] sessions) {
            Object result;
            if (this.conditionSnippet == null && this.conditionCallNode == null || !this.conditionUnchanged.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.initializeConditional(frame.materialize());
            }
            try {
                this.suspensionEnabledNode.execute(false, sessions);
                result = this.conditionSnippet != null ? this.conditionSnippet.execute(frame) : this.conditionCallNode.call(EMPTY_ARRAY);
            }
            finally {
                this.suspensionEnabledNode.execute(true, sessions);
            }
            if (!(result instanceof Boolean)) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalArgumentException("Unsupported return type " + result + " in condition.");
            }
            return (Boolean)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeConditional(MaterializedFrame frame) {
            Source conditionSource;
            Node instrumentedNode = this.context.getInstrumentedNode();
            RootNode rootNode = instrumentedNode.getRootNode();
            if (rootNode == null) {
                throw new IllegalStateException("Probe was disconnected from the AST.");
            }
            Source instrumentedSource = this.context.getInstrumentedSourceSection().getSource();
            Breakpoint breakpoint = this.breakpoint;
            synchronized (breakpoint) {
                conditionSource = Source.newBuilder(this.breakpoint.condition).language(instrumentedSource.getLanguage()).mimeType(instrumentedSource.getMimeType()).name("breakpoint condition").build();
                if (conditionSource == null) {
                    throw new IllegalStateException("Condition is not resolved " + rootNode);
                }
                this.conditionUnchanged = this.breakpoint.getConditionUnchanged();
            }
            ExecutableNode snippet = this.breakpoint.debugger.getEnv().parseInline(conditionSource, instrumentedNode, frame);
            if (snippet != null) {
                this.conditionSnippet = this.insert(snippet);
                this.notifyInserted(snippet);
            } else {
                CallTarget callTarget = Debugger.ACCESSOR.parse(conditionSource, instrumentedNode, new String[0]);
                this.conditionCallNode = this.insert(Truffle.getRuntime().createDirectCallNode(callTarget));
            }
        }
    }

    static final class BreakpointConditionFailure
    extends SlowPathException {
        private static final long serialVersionUID = 1L;
        private final Breakpoint breakpoint;

        BreakpointConditionFailure(Breakpoint breakpoint, Throwable cause) {
            super(cause);
            this.breakpoint = breakpoint;
        }

        public Breakpoint getBreakpoint() {
            return this.breakpoint;
        }

        public Throwable getConditionFailure() {
            return this.getCause();
        }
    }

    private static abstract class AbstractBreakpointNode
    extends DebuggerNode {
        private final Breakpoint breakpoint;
        protected final BranchProfile breakBranch = BranchProfile.create();
        @Node.Child
        private ConditionalBreakNode breakCondition;
        @CompilerDirectives.CompilationFinal
        private Assumption conditionExistsUnchanged;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private DebuggerSession[] sessions;
        @CompilerDirectives.CompilationFinal
        private Assumption sessionsUnchanged;

        AbstractBreakpointNode(Breakpoint breakpoint, EventContext context) {
            super(context);
            this.breakpoint = breakpoint;
            this.initializeSessions();
            this.conditionExistsUnchanged = breakpoint.getConditionExistsUnchanged();
            if (breakpoint.condition != null) {
                this.breakCondition = new ConditionalBreakNode(context, breakpoint);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeSessions() {
            CompilerAsserts.neverPartOfCompilation();
            Breakpoint breakpoint = this.breakpoint;
            synchronized (breakpoint) {
                this.sessions = this.breakpoint.sessions.toArray(new DebuggerSession[0]);
                this.sessionsUnchanged = Truffle.getRuntime().createAssumption("Breakpoint sessions unchanged.");
                this.breakpoint.sessionsUnchanged = this.sessionsUnchanged;
            }
        }

        @Override
        boolean isStepNode() {
            return false;
        }

        @Override
        Breakpoint getBreakpoint() {
            return this.breakpoint;
        }

        @Override
        EventBinding<?> getBinding() {
            return this.breakpoint.breakpointBinding;
        }

        @ExplodeLoop
        protected final void onNode(VirtualFrame frame, boolean onEnter, Object result, Throwable exception) {
            if (!this.sessionsUnchanged.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.initializeSessions();
            }
            DebuggerSession[] debuggerSessions = this.sessions;
            boolean active = false;
            List sessionsWithUniqueNodes = null;
            for (DebuggerSession session : debuggerSessions) {
                if (this.consumeIsDuplicate(session)) {
                    if (sessionsWithUniqueNodes == null && debuggerSessions.length == 1) {
                        return;
                    }
                    sessionsWithUniqueNodes = Breakpoint.removeDuplicateSession(debuggerSessions, session, sessionsWithUniqueNodes);
                    continue;
                }
                if (!session.isBreakpointsActive(this.breakpoint.getKind())) continue;
                active = true;
            }
            if (!active) {
                return;
            }
            if (sessionsWithUniqueNodes != null) {
                if (sessionsWithUniqueNodes.isEmpty()) {
                    return;
                }
                debuggerSessions = Breakpoint.toSessionsArray(sessionsWithUniqueNodes);
            }
            if (!this.conditionExistsUnchanged.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (this.breakpoint.condition != null) {
                    this.breakCondition = this.insert(new ConditionalBreakNode(this.context, this.breakpoint));
                    this.notifyInserted(this.breakCondition);
                } else {
                    this.breakCondition = null;
                }
                this.conditionExistsUnchanged = this.breakpoint.getConditionExistsUnchanged();
            }
            BreakpointConditionFailure conditionError = null;
            try {
                if (!this.testCondition(frame)) {
                    return;
                }
            }
            catch (BreakpointConditionFailure e) {
                conditionError = e;
            }
            this.breakBranch.enter();
            this.breakpoint.doBreak(this, debuggerSessions, frame.materialize(), onEnter, result, exception, conditionError);
        }

        final DebuggerSession[] getSessions() {
            if (!this.sessionsUnchanged.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.initializeSessions();
            }
            return this.sessions;
        }

        boolean testCondition(VirtualFrame frame) throws BreakpointConditionFailure {
            if (!this.conditionExistsUnchanged.isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (this.breakpoint.condition != null) {
                    this.breakCondition = this.insert(new ConditionalBreakNode(this.context, this.breakpoint));
                    this.notifyInserted(this.breakCondition);
                } else {
                    this.breakCondition = null;
                }
                this.conditionExistsUnchanged = this.breakpoint.getConditionExistsUnchanged();
            }
            if (this.breakCondition != null) {
                try {
                    return this.breakCondition.executeBreakCondition(frame, this.sessions);
                }
                catch (Throwable e) {
                    CompilerDirectives.transferToInterpreter();
                    throw new BreakpointConditionFailure(this.breakpoint, e);
                }
            }
            return true;
        }
    }

    private static class BreakpointAfterNodeException
    extends AbstractBreakpointNode {
        BreakpointAfterNodeException(Breakpoint breakpoint, EventContext context) {
            super(breakpoint, context);
        }

        @Override
        Set<SuspendAnchor> getSuspendAnchors() {
            return DebuggerSession.ANCHOR_SET_AFTER;
        }

        @Override
        boolean isActiveAt(SuspendAnchor anchor) {
            return SuspendAnchor.AFTER == anchor;
        }

        @Override
        public void onEnter(VirtualFrame frame) {
            this.getBreakpoint().exceptionFilter.resetReportedException();
        }

        @Override
        public void onReturnValue(VirtualFrame frame, Object result) {
            this.getBreakpoint().exceptionFilter.resetReportedException();
        }

        @Override
        @ExplodeLoop
        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            if (exception instanceof TruffleException) {
                DebuggerSession[] debuggerSessions = this.getSessions();
                boolean active = false;
                List nonDuplicateSessions = null;
                for (DebuggerSession session : debuggerSessions) {
                    if (this.consumeIsDuplicate(session)) {
                        if (nonDuplicateSessions == null && debuggerSessions.length == 1) {
                            return;
                        }
                        nonDuplicateSessions = Breakpoint.removeDuplicateSession(debuggerSessions, session, nonDuplicateSessions);
                        continue;
                    }
                    if (!session.isBreakpointsActive(this.getBreakpoint().getKind())) continue;
                    active = true;
                }
                if (!active) {
                    return;
                }
                if (nonDuplicateSessions != null) {
                    if (nonDuplicateSessions.isEmpty()) {
                        return;
                    }
                    debuggerSessions = Breakpoint.toSessionsArray(nonDuplicateSessions);
                }
                BreakpointExceptionFilter.Match matched = this.getBreakpoint().exceptionFilter.matchException(this, exception);
                if (matched.isMatched) {
                    BreakpointConditionFailure conditionError = null;
                    try {
                        if (!this.testCondition(frame)) {
                            return;
                        }
                    }
                    catch (BreakpointConditionFailure e) {
                        conditionError = e;
                    }
                    this.breakBranch.enter();
                    this.doBreak(frame.materialize(), debuggerSessions, conditionError, exception, matched);
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        void doBreak(MaterializedFrame frame, DebuggerSession[] debuggerSessions, BreakpointConditionFailure conditionError, Throwable exception, BreakpointExceptionFilter.Match matched) {
            Node throwLocation = this.getContext().getInstrumentedNode();
            DebugException de = new DebugException(this.getBreakpoint().debugger, (TruffleException)((Object)exception), null, throwLocation, matched.isCatchNodeComputed, matched.catchLocation);
            this.getBreakpoint().doBreak(this, debuggerSessions, frame, false, null, de, conditionError);
        }
    }

    private static class BreakpointAfterNode
    extends AbstractBreakpointNode {
        BreakpointAfterNode(Breakpoint breakpoint, EventContext context) {
            super(breakpoint, context);
        }

        @Override
        Set<SuspendAnchor> getSuspendAnchors() {
            return DebuggerSession.ANCHOR_SET_AFTER;
        }

        @Override
        boolean isActiveAt(SuspendAnchor anchor) {
            return SuspendAnchor.AFTER == anchor;
        }

        @Override
        protected void onReturnValue(VirtualFrame frame, Object result) {
            this.onNode(frame, false, result, null);
        }

        @Override
        protected void onReturnExceptional(VirtualFrame frame, Throwable exception) {
            if (exception instanceof TruffleException) {
                this.onNode(frame, false, null, exception);
            }
        }
    }

    private static class BreakpointBeforeNode
    extends AbstractBreakpointNode {
        BreakpointBeforeNode(Breakpoint breakpoint, EventContext context) {
            super(breakpoint, context);
        }

        @Override
        Set<SuspendAnchor> getSuspendAnchors() {
            return DebuggerSession.ANCHOR_SET_BEFORE;
        }

        @Override
        boolean isActiveAt(SuspendAnchor anchor) {
            return SuspendAnchor.BEFORE == anchor;
        }

        @Override
        protected void onEnter(VirtualFrame frame) {
            this.onNode(frame, true, null, null);
        }
    }

    private class BreakpointNodeFactory
    implements ExecutionEventNodeFactory {
        private BreakpointNodeFactory() {
        }

        @Override
        public ExecutionEventNode create(EventContext context) {
            if (!Breakpoint.this.isResolved()) {
                Breakpoint.this.resolveBreakpoint(context.getInstrumentedSourceSection());
            }
            if (Breakpoint.this.exceptionFilter != null) {
                return new BreakpointAfterNodeException(Breakpoint.this, context);
            }
            switch (Breakpoint.this.suspendAnchor) {
                case BEFORE: {
                    return new BreakpointBeforeNode(Breakpoint.this, context);
                }
                case AFTER: {
                    return new BreakpointAfterNode(Breakpoint.this, context);
                }
            }
            throw new IllegalStateException("Unknown suspend anchor: " + (Object)((Object)Breakpoint.this.suspendAnchor));
        }
    }

    public static interface ResolveListener {
        public void breakpointResolved(Breakpoint var1, SourceSection var2);
    }

    public final class ExceptionBuilder {
        private final boolean caught;
        private final boolean uncaught;
        private SuspensionFilter suspensionFilter;
        private SourceElement[] sourceElements;

        ExceptionBuilder(boolean caught, boolean uncaught) {
            this.caught = caught;
            this.uncaught = uncaught;
        }

        public ExceptionBuilder suspensionFilter(SuspensionFilter filter) {
            this.suspensionFilter = filter;
            return this;
        }

        public ExceptionBuilder sourceElements(SourceElement ... sourceElements) {
            if (this.sourceElements != null) {
                throw new IllegalStateException("Step source elements can only be set once per the builder.");
            }
            if (sourceElements.length == 0) {
                throw new IllegalArgumentException("At least one source element needs to be provided.");
            }
            this.sourceElements = (SourceElement[])sourceElements.clone();
            return this;
        }

        public Breakpoint build() {
            if (this.sourceElements == null) {
                this.sourceElements = new SourceElement[]{SourceElement.STATEMENT};
            }
            BreakpointLocation location = BreakpointLocation.create(this.sourceElements, this.suspensionFilter);
            BreakpointExceptionFilter efilter = new BreakpointExceptionFilter(this.caught, this.uncaught);
            return new Breakpoint(location, SuspendAnchor.AFTER, false, efilter, null);
        }
    }

    public final class Builder {
        private final Object key;
        private int line = -1;
        private SuspendAnchor anchor = SuspendAnchor.BEFORE;
        private int column = -1;
        private ResolveListener resolveListener;
        private int ignoreCount;
        private boolean oneShot;
        private SourceSection sourceSection;
        private SourceElement[] sourceElements;

        private Builder(Object key) {
            Objects.requireNonNull(key);
            this.key = key;
        }

        private Builder(SourceSection key) {
            this(key.getSource());
            Objects.requireNonNull(key);
            this.sourceSection = key;
        }

        public Builder lineIs(int line) {
            if (line <= 0) {
                throw new IllegalArgumentException("Line argument must be > 0.");
            }
            if (this.line != -1) {
                throw new IllegalStateException("LineIs can only be called once per breakpoint builder.");
            }
            if (this.sourceSection != null) {
                throw new IllegalArgumentException("LineIs cannot be used with source section based breakpoint. ");
            }
            this.line = line;
            return this;
        }

        public Builder suspendAnchor(SuspendAnchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public Builder columnIs(int column) {
            if (column <= 0) {
                throw new IllegalArgumentException("Column argument must be > 0.");
            }
            if (this.line == -1) {
                throw new IllegalStateException("ColumnIs can only be called after a line is set.");
            }
            this.column = column;
            return this;
        }

        public Builder resolveListener(ResolveListener resolveListener) {
            Objects.requireNonNull(resolveListener);
            if (this.resolveListener != null) {
                throw new IllegalStateException("ResolveListener can only be set once per breakpoint builder.");
            }
            this.resolveListener = resolveListener;
            return this;
        }

        public Builder ignoreCount(int ignoreCount) {
            if (ignoreCount < 0) {
                throw new IllegalArgumentException("IgnoreCount argument must be >= 0.");
            }
            this.ignoreCount = ignoreCount;
            return this;
        }

        public Builder oneShot() {
            this.oneShot = true;
            return this;
        }

        public Builder sourceElements(SourceElement ... sourceElements) {
            if (this.sourceElements != null) {
                throw new IllegalStateException("Step source elements can only be set once per the builder.");
            }
            if (sourceElements.length == 0) {
                throw new IllegalArgumentException("At least one source element needs to be provided.");
            }
            this.sourceElements = sourceElements;
            return this;
        }

        public Breakpoint build() {
            if (this.sourceElements == null) {
                this.sourceElements = new SourceElement[]{SourceElement.STATEMENT};
            }
            BreakpointLocation location = this.sourceSection != null ? BreakpointLocation.create(this.key, this.sourceElements, this.sourceSection) : BreakpointLocation.create(this.key, this.sourceElements, this.line, this.column);
            Breakpoint breakpoint = new Breakpoint(location, this.anchor, this.oneShot, null, this.resolveListener);
            breakpoint.setIgnoreCount(this.ignoreCount);
            return breakpoint;
        }
    }

    public static enum Kind {
        HALT_INSTRUCTION,
        SOURCE_LOCATION,
        EXCEPTION;

    }
}

