/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.FindContextNode;
import com.oracle.truffle.api.impl.ReadOnlyArrayList;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.io.FileSystem;

public abstract class TruffleLanguage<C> {
    @CompilerDirectives.CompilationFinal
    private LanguageInfo languageInfo;
    @CompilerDirectives.CompilationFinal
    private ContextReference<C> reference;
    @CompilerDirectives.CompilationFinal
    private boolean singletonLanguage;
    static final AccessAPI API = new AccessAPI();

    protected TruffleLanguage() {
    }

    protected abstract C createContext(Env var1);

    protected void initializeContext(C context) throws Exception {
    }

    protected void finalizeContext(C context) {
    }

    protected boolean initializeMultiContext() {
        return false;
    }

    protected void disposeContext(C context) {
    }

    protected CallTarget parse(ParsingRequest request) throws Exception {
        throw new UnsupportedOperationException(String.format("Override parse method of %s, it will be made abstract in future version of Truffle API!", this.getClass().getName()));
    }

    protected ExecutableNode parse(InlineParsingRequest request) throws Exception {
        return null;
    }

    protected OptionDescriptors getOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    protected boolean patchContext(C context, Env newEnv) {
        return false;
    }

    @Deprecated
    protected Object findExportedSymbol(C context, String globalName, boolean onlyExplicit) {
        return null;
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return singleThreaded;
    }

    protected void initializeMultiThreading(C context) {
    }

    protected void initializeThread(C context, Thread thread) {
    }

    protected void disposeThread(C context, Thread thread) {
    }

    @Deprecated
    protected Object getLanguageGlobal(C context) {
        return null;
    }

    protected abstract boolean isObjectOfLanguage(Object var1);

    protected Iterable<Scope> findLocalScopes(C context, Node node, Frame frame) {
        assert (node != null);
        return AccessAPI.engineAccess().createDefaultLexicalScope(node, frame);
    }

    protected Iterable<Scope> findTopScopes(C context) {
        Object global = this.getLanguageGlobal(context);
        return AccessAPI.engineAccess().createDefaultTopScope(global);
    }

    protected String toString(C context, Object value) {
        return Objects.toString(value);
    }

    protected boolean isVisible(C context, Object value) {
        return true;
    }

    final <T> T lookup(Class<T> clazz) {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        return null;
    }

    protected Object findMetaObject(C context, Object value) {
        return null;
    }

    protected SourceSection findSourceLocation(C context, Object value) {
        return null;
    }

    @Deprecated
    protected final Node createFindContextNode() {
        return AccessAPI.engineAccess().createFindContextNode(this);
    }

    @Deprecated
    protected final C findContext(Node n) {
        FindContextNode fcn = (FindContextNode)n;
        if (fcn.getTruffleLanguage() != this) {
            throw new ClassCastException();
        }
        return fcn.executeFindContext();
    }

    public final ContextReference<C> getContextReference() {
        if (this.reference == null) {
            throw new IllegalStateException("TruffleLanguage instance is not initialized. Cannot get the current context reference.");
        }
        return this.reference;
    }

    void initialize(LanguageInfo language, boolean singleton) {
        this.singletonLanguage = singleton;
        if (!singleton) {
            this.languageInfo = language;
            this.reference = new ContextReference(API.nodes().getEngineObject(this.languageInfo));
        }
    }

    CallTarget parse(Source source, Node context, MaterializedFrame frame, String ... argumentNames) {
        CallTarget target;
        ParsingRequest request = new ParsingRequest(source, context, frame, argumentNames);
        try {
            target = request.parse(this);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            request.dispose();
        }
        return target;
    }

    ExecutableNode parseInline(Source source, Node context, MaterializedFrame frame) {
        ExecutableNode snippet;
        assert (context != null);
        InlineParsingRequest request = new InlineParsingRequest(source, context, frame);
        try {
            snippet = request.parse(this);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            request.dispose();
        }
        return snippet;
    }

    protected static <T extends TruffleLanguage<?>> T getCurrentLanguage(Class<T> languageClass) {
        return AccessAPI.engineAccess().getCurrentLanguage(languageClass);
    }

    protected static <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> languageClass) {
        return AccessAPI.engineAccess().getCurrentContext(languageClass);
    }

    protected final String getLanguageHome() {
        return AccessAPI.engineAccess().getLanguageHome(AccessAPI.nodesAccess().getEngineObject(this.languageInfo));
    }

    static final class LanguageImpl
    extends Accessor.LanguageSupport {
        LanguageImpl() {
        }

        @Override
        public boolean isTruffleStackTrace(Throwable t) {
            return t instanceof TruffleStackTrace.LazyStackTrace;
        }

        @Override
        public StackTraceElement[] getInternalStackTraceElements(Throwable t) {
            TruffleStackTrace trace = ((TruffleStackTrace.LazyStackTrace)t).getInternalStackTrace();
            if (trace == null) {
                return new StackTraceElement[0];
            }
            return trace.getInternalStackTrace();
        }

        @Override
        public void materializeHostFrames(Throwable original) {
            TruffleStackTrace.materializeHostFrames(original);
        }

        @Override
        public InstrumentInfo createInstrument(Object vmObject, String id, String name, String version) {
            return new InstrumentInfo(vmObject, id, name, version);
        }

        @Override
        public Object getVMObject(InstrumentInfo info) {
            return info.getVmObject();
        }

        @Override
        public void initializeLanguage(LanguageInfo language, TruffleLanguage<?> impl, boolean legacyLanguage) {
            AccessAPI.nodesAccess().setLanguageSpi(language, impl);
            impl.initialize(language, legacyLanguage);
        }

        @Override
        public boolean initializeMultiContext(LanguageInfo info) {
            return AccessAPI.nodesAccess().getLanguageSpi(info).initializeMultiContext();
        }

        @Override
        public Object getContext(Env env) {
            Object c = env.getLanguageContext();
            if (c != Env.UNSET_CONTEXT) {
                return c;
            }
            return null;
        }

        @Override
        public TruffleLanguage<?> getSPI(Env env) {
            return env.spi;
        }

        @Override
        public Env createEnv(Object vmObject, LanguageInfo language, OutputStream stdOut, OutputStream stdErr, InputStream stdIn, Map<String, Object> config, OptionValues options, String[] applicationArguments, FileSystem fileSystem) {
            Env env = new Env(vmObject, language, stdOut, stdErr, stdIn, config, options, applicationArguments, fileSystem);
            LinkedHashSet<Object> collectedServices = new LinkedHashSet<Object>();
            AccessAPI.instrumentAccess().collectEnvServices(collectedServices, API.nodes().getEngineObject(language), language);
            env.services = new ArrayList<Object>(collectedServices);
            return env;
        }

        @Override
        public Object createEnvContext(Env env) {
            Object context = env.getSpi().createContext(env);
            env.context = context;
            Assumption contextUnchanged = env.contextUnchangedAssumption;
            env.contextUnchangedAssumption = Truffle.getRuntime().createAssumption("Language context unchanged");
            contextUnchanged.invalidate();
            return context;
        }

        @Override
        public TruffleContext createTruffleContext(Object impl) {
            return new TruffleContext(impl);
        }

        @Override
        public void postInitEnv(Env env) {
            env.postInit();
        }

        @Override
        public boolean isContextInitialized(Env env) {
            return env.isInitialized();
        }

        @Override
        public CallTarget parse(Env env, Source code, Node context, String ... argumentNames) {
            return env.getSpi().parse(code, context, null, argumentNames);
        }

        @Override
        public ExecutableNode parseInline(Env env, Source code, Node context, MaterializedFrame frame) {
            return env.getSpi().parseInline(code, context, frame);
        }

        @Override
        public LanguageInfo getLanguageInfo(Env env) {
            return env.language;
        }

        @Override
        public void onThrowable(Node callNode, RootCallTarget root, Throwable e, Frame frame) {
            TruffleStackTrace.addStackFrameInfo(callNode, e, root, frame);
        }

        @Override
        public void initializeThread(Env env, Thread current) {
            env.getSpi().initializeThread(env.context, current);
        }

        @Override
        public boolean isThreadAccessAllowed(LanguageInfo language, Thread thread, boolean singleThread) {
            return AccessAPI.nodesAccess().getLanguageSpi(language).isThreadAccessAllowed(thread, singleThread);
        }

        @Override
        public void initializeMultiThreading(Env env) {
            env.getSpi().initializeMultiThreading(env.context);
        }

        @Override
        public void finalizeContext(Env env) {
            env.getSpi().finalizeContext(env.context);
        }

        @Override
        public void disposeThread(Env env, Thread current) {
            env.getSpi().disposeThread(env.context, current);
        }

        @Override
        public Object evalInContext(Source source, Node node, MaterializedFrame mFrame) {
            LanguageInfo info = node.getRootNode().getLanguageInfo();
            assert (info != null);
            CallTarget target = API.nodes().getLanguageSpi(info).parse(source, node, mFrame, new String[0]);
            try {
                if (target instanceof RootCallTarget) {
                    RootNode exec = ((RootCallTarget)target).getRootNode();
                    return exec.execute(mFrame);
                }
                throw new IllegalStateException("" + target);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Object findExportedSymbol(Env env, String globalName, boolean onlyExplicit) {
            return env.findExportedSymbol(globalName, onlyExplicit);
        }

        @Override
        public LanguageInfo getLanguageInfo(TruffleLanguage<?> language) {
            return ((TruffleLanguage)language).languageInfo;
        }

        @Override
        public LanguageInfo getLegacyLanguageInfo(Object vm, Class<? extends TruffleLanguage> languageClass) {
            if (vm == null) {
                return null;
            }
            Env env = AccessAPI.engineAccess().findEnv(vm, languageClass, false);
            if (env != null) {
                return env.language;
            }
            return null;
        }

        @Override
        public Object languageGlobal(Env env) {
            return env.getLanguageGlobal();
        }

        @Override
        public void dispose(Env env) {
            env.dispose();
        }

        @Override
        public String toStringIfVisible(Env env, Object value, boolean checkVisibility) {
            return env.toStringIfVisible(value, checkVisibility);
        }

        @Override
        public Object findMetaObject(Env env, Object obj) {
            return env.findMetaObjectImpl(obj);
        }

        @Override
        public SourceSection findSourceLocation(Env env, Object obj) {
            return env.findSourceLocation(obj);
        }

        @Override
        public boolean isObjectOfLanguage(Env env, Object value) {
            return env.isObjectOfLanguage(value);
        }

        @Override
        public <S> S lookup(LanguageInfo language, Class<S> type) {
            return AccessAPI.nodesAccess().getLanguageSpi(language).lookup(type);
        }

        @Override
        public Iterable<Scope> findLocalScopes(Env env, Node node, Frame frame) {
            return env.findLocalScopes(node, frame);
        }

        @Override
        public Iterable<Scope> findTopScopes(Env env) {
            return env.findTopScopes();
        }

        @Override
        public OptionDescriptors describeOptions(TruffleLanguage<?> language, String requiredGroup) {
            OptionDescriptors descriptors = language.getOptionDescriptors();
            if (descriptors == null) {
                return OptionDescriptors.EMPTY;
            }
            assert (LanguageImpl.verifyDescriptors(language, requiredGroup, descriptors));
            return descriptors;
        }

        private static boolean verifyDescriptors(TruffleLanguage<?> language, String requiredGroup, OptionDescriptors descriptors) {
            String groupPlusDot = requiredGroup + ".";
            for (OptionDescriptor descriptor : descriptors) {
                if (descriptor.getName().equals(requiredGroup) || descriptor.getName().startsWith(groupPlusDot)) continue;
                throw new IllegalArgumentException(String.format("Illegal option prefix in name '%s' specified for option described by language '%s'. The option prefix must match the id of the language '%s'.", descriptor.getName(), language.getClass().getName(), requiredGroup));
            }
            return true;
        }

        @Override
        public Env patchEnvContext(Env env, OutputStream stdOut, OutputStream stdErr, InputStream stdIn, Map<String, Object> config, OptionValues options, String[] applicationArguments, FileSystem fileSystem) {
            Env newEnv = this.createEnv(env.vmObject, env.language, stdOut, stdErr, stdIn, config, options, applicationArguments, fileSystem);
            newEnv.initialized = env.initialized;
            newEnv.context = env.context;
            env.valid = false;
            return env.spi.patchContext(env.context, newEnv) ? newEnv : null;
        }

        @Override
        public boolean checkTruffleFile(File file) {
            return file instanceof TruffleFile.FileAdapter;
        }

        @Override
        public byte[] truffleFileContent(File file) throws IOException {
            assert (file instanceof TruffleFile.FileAdapter) : "File must be " + TruffleFile.FileAdapter.class.getSimpleName();
            TruffleFile tf = ((TruffleFile.FileAdapter)file).getTruffleFile();
            return tf.readAllBytes();
        }
    }

    static final class AccessAPI
    extends Accessor {
        AccessAPI() {
        }

        static Accessor.EngineSupport engineAccess() {
            return API.engineSupport();
        }

        static Accessor.InstrumentSupport instrumentAccess() {
            return API.instrumentSupport();
        }

        static Accessor.Nodes nodesAccess() {
            return API.nodes();
        }

        static Accessor.InteropSupport interopAccess() {
            return API.interopSupport();
        }

        static Accessor.JavaInteropSupport javaAccess() {
            return API.javaInteropSupport();
        }

        @Override
        protected Accessor.LanguageSupport languageSupport() {
            return new LanguageImpl();
        }

        @Override
        protected Accessor.Nodes nodes() {
            return super.nodes();
        }
    }

    public static final class ContextReference<C> {
        private final Object languageShared;

        private ContextReference(Object languageShared) {
            this.languageShared = languageShared;
        }

        public C get() {
            return (C)AccessAPI.engineAccess().getCurrentContext(this.languageShared);
        }
    }

    public static final class Env {
        private static final Object UNSET_CONTEXT = new Object();
        private final Object vmObject;
        private final LanguageInfo language;
        private final TruffleLanguage<Object> spi;
        private final InputStream in;
        private final OutputStream err;
        private final OutputStream out;
        private final Map<String, Object> config;
        private final OptionValues options;
        private final String[] applicationArguments;
        private final FileSystem fileSystem;
        private List<Object> services;
        @CompilerDirectives.CompilationFinal
        private volatile Object context = UNSET_CONTEXT;
        @CompilerDirectives.CompilationFinal
        private volatile Assumption contextUnchangedAssumption = Truffle.getRuntime().createAssumption("Language context unchanged");
        @CompilerDirectives.CompilationFinal
        private volatile boolean initialized = false;
        @CompilerDirectives.CompilationFinal
        private volatile Assumption initializedUnchangedAssumption = Truffle.getRuntime().createAssumption("Language context initialized unchanged");
        @CompilerDirectives.CompilationFinal
        private volatile boolean valid;

        private Env(Object vmObject, LanguageInfo language, OutputStream out, OutputStream err, InputStream in, Map<String, Object> config, OptionValues options, String[] applicationArguments, FileSystem fileSystem) {
            this.vmObject = vmObject;
            this.language = language;
            this.spi = API.nodes().getLanguageSpi(language);
            this.in = in;
            this.err = err;
            this.out = out;
            this.config = config;
            this.options = options;
            this.applicationArguments = applicationArguments == null ? new String[]{} : applicationArguments;
            this.valid = true;
            this.fileSystem = fileSystem;
        }

        Object getVMObject() {
            return this.vmObject;
        }

        TruffleLanguage<Object> getSpi() {
            return this.spi;
        }

        void checkDisposed() {
            if (AccessAPI.engineAccess().isDisposed(this.vmObject)) {
                throw new IllegalStateException("Language environment is already disposed.");
            }
            if (!this.valid) {
                throw new IllegalStateException("Language environment is already invalidated.");
            }
        }

        public OptionValues getOptions() {
            return this.options;
        }

        public String[] getApplicationArguments() {
            return this.applicationArguments;
        }

        public boolean isCreateThreadAllowed() {
            return AccessAPI.engineAccess().isCreateThreadAllowed(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Thread createThread(Runnable runnable) {
            return this.createThread(runnable, null);
        }

        @CompilerDirectives.TruffleBoundary
        public Thread createThread(Runnable runnable, TruffleContext context) {
            return AccessAPI.engineAccess().createThread(this.vmObject, runnable, context != null ? context.impl : null);
        }

        public TruffleContext.Builder newContextBuilder() {
            TruffleContext truffleContext = TruffleContext.EMPTY;
            truffleContext.getClass();
            return truffleContext.new TruffleContext.Builder(this);
        }

        public Object getPolyglotBindings() {
            return AccessAPI.engineAccess().getPolyglotBindingsForLanguage(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Object importSymbol(String symbolName) {
            return AccessAPI.engineAccess().importSymbol(this.vmObject, this, symbolName);
        }

        @CompilerDirectives.TruffleBoundary
        public void exportSymbol(String symbolName, Object value) {
            AccessAPI.engineAccess().exportSymbol(this.vmObject, symbolName, value);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isHostLookupAllowed() {
            return AccessAPI.engineAccess().isHostAccessAllowed(this.vmObject, this);
        }

        @CompilerDirectives.TruffleBoundary
        public void addToHostClassPath(TruffleFile entry) {
            Objects.requireNonNull(entry);
            AccessAPI.engineAccess().addToHostClassPath(this.vmObject, entry);
        }

        @CompilerDirectives.TruffleBoundary
        public Object lookupHostSymbol(String symbolName) {
            return AccessAPI.engineAccess().lookupHostSymbol(this.vmObject, this, symbolName);
        }

        public boolean isHostObject(Object value) {
            return AccessAPI.javaAccess().isHostObject(value);
        }

        public Object asHostObject(Object value) {
            if (!this.isHostObject(value)) {
                CompilerDirectives.transferToInterpreter();
                throw new ClassCastException();
            }
            return AccessAPI.javaAccess().asHostObject(value);
        }

        public Object asGuestValue(Object hostObject) {
            return AccessAPI.engineAccess().toGuestValue(hostObject, this.vmObject);
        }

        public Object asBoxedGuestValue(Object guestObject) {
            return AccessAPI.engineAccess().asBoxedGuestValue(guestObject, this.vmObject);
        }

        public Object findMetaObject(Object value) {
            return AccessAPI.engineAccess().findMetaObjectForLanguage(this.vmObject, value);
        }

        public boolean isHostException(Throwable exception) {
            return AccessAPI.engineAccess().isHostException(exception);
        }

        public Throwable asHostException(Throwable exception) {
            return AccessAPI.engineAccess().asHostException(exception);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isNativeAccessAllowed() {
            return AccessAPI.engineAccess().isNativeAccessAllowed(this.vmObject, this);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isMimeTypeSupported(String mimeType) {
            this.checkDisposed();
            return AccessAPI.engineAccess().isMimeTypeSupported(this.vmObject, mimeType);
        }

        @CompilerDirectives.TruffleBoundary
        public CallTarget parse(Source source, String ... argumentNames) {
            CompilerAsserts.neverPartOfCompilation();
            this.checkDisposed();
            return AccessAPI.engineAccess().parseForLanguage(this.vmObject, source, argumentNames);
        }

        @CompilerDirectives.TruffleBoundary
        public InputStream in() {
            this.checkDisposed();
            return this.in;
        }

        @CompilerDirectives.TruffleBoundary
        public OutputStream out() {
            this.checkDisposed();
            return this.out;
        }

        @CompilerDirectives.TruffleBoundary
        public OutputStream err() {
            this.checkDisposed();
            return this.err;
        }

        @CompilerDirectives.TruffleBoundary
        public <T> T lookup(Class<T> type) {
            this.checkDisposed();
            for (Object obj : this.services) {
                if (!type.isInstance(obj)) continue;
                return type.cast(obj);
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        public <S> S lookup(InstrumentInfo instrument, Class<S> type) {
            return AccessAPI.engineAccess().lookup(instrument, type);
        }

        @CompilerDirectives.TruffleBoundary
        public <S> S lookup(LanguageInfo language, Class<S> type) {
            if (this.language == language) {
                throw new IllegalArgumentException("Cannot request services from the current language.");
            }
            TruffleLanguage<?> otherSpi = AccessAPI.nodesAccess().getLanguageSpi(language);
            return otherSpi.lookup(type);
        }

        @CompilerDirectives.TruffleBoundary
        public Map<String, LanguageInfo> getLanguages() {
            return AccessAPI.engineAccess().getLanguages(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Map<String, InstrumentInfo> getInstruments() {
            return AccessAPI.engineAccess().getInstruments(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Map<String, Object> getConfig() {
            this.checkDisposed();
            return this.config;
        }

        public TruffleContext getContext() {
            return AccessAPI.engineAccess().getPolyglotContext(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile getTruffleFile(String path) {
            return new TruffleFile(this.fileSystem, this.fileSystem.parsePath(path).normalize());
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile getTruffleFile(URI uri) {
            this.checkDisposed();
            try {
                return new TruffleFile(this.fileSystem, this.fileSystem.parsePath(uri).normalize());
            }
            catch (UnsupportedOperationException e) {
                throw new FileSystemNotFoundException("FileSystem for: " + uri.getScheme() + " scheme is not supported.");
            }
        }

        public Source.Builder<IOException, RuntimeException, RuntimeException> newSourceBuilder(TruffleFile file) {
            Objects.requireNonNull(file, "File must be non null");
            return Source.newBuilder(new TruffleFile.FileAdapter(file));
        }

        @CompilerDirectives.TruffleBoundary
        <E extends TruffleLanguage> E getLanguage(Class<E> languageClass) {
            this.checkDisposed();
            if (languageClass != this.spi.getClass()) {
                throw new IllegalArgumentException("Invalid access to language " + languageClass + ".");
            }
            return (E)((TruffleLanguage)languageClass.cast(this.spi));
        }

        Object findExportedSymbol(String globalName, boolean onlyExplicit) {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                return this.spi.findExportedSymbol(c, globalName, onlyExplicit);
            }
            return null;
        }

        Object getLanguageGlobal() {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                return this.spi.getLanguageGlobal(c);
            }
            return null;
        }

        Object findMetaObjectImpl(Object obj) {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                Object rawValue = AccessAPI.engineAccess().findOriginalObject(obj);
                return this.spi.findMetaObject(c, rawValue);
            }
            return null;
        }

        SourceSection findSourceLocation(Object obj) {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                Object rawValue = AccessAPI.engineAccess().findOriginalObject(obj);
                return this.spi.findSourceLocation(c, rawValue);
            }
            return null;
        }

        boolean isObjectOfLanguage(Object obj) {
            Object rawValue = AccessAPI.engineAccess().findOriginalObject(obj);
            return this.spi.isObjectOfLanguage(rawValue);
        }

        Iterable<Scope> findLocalScopes(Node node, Frame frame) {
            assert (node != null);
            return this.spi.findLocalScopes(this.context, node, frame);
        }

        Iterable<Scope> findTopScopes() {
            return this.spi.findTopScopes(this.context);
        }

        void dispose() {
            Object c = this.getLanguageContext();
            if (c == UNSET_CONTEXT) {
                throw new IllegalStateException("Disposing while context has not been set yet.");
            }
            this.spi.disposeContext(c);
        }

        @CompilerDirectives.TruffleBoundary
        void postInit() {
            try {
                this.spi.initializeContext(this.context);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.initialized = true;
                Assumption old = this.initializedUnchangedAssumption;
                this.initializedUnchangedAssumption = Truffle.getRuntime().createAssumption("Language context initialized unchanged");
                old.invalidate();
            }
        }

        private boolean isInitialized() {
            if (CompilerDirectives.isPartialEvaluationConstant(this)) {
                boolean localInitialized = this.initialized;
                if (this.initializedUnchangedAssumption.isValid()) {
                    return localInitialized;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.initialized;
            }
            return this.initialized;
        }

        String toStringIfVisible(Object value, boolean checkVisibility) {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                if (checkVisibility && !this.spi.isVisible(c, value)) {
                    return null;
                }
                return this.spi.toString(c, value);
            }
            return null;
        }

        private Object getLanguageContext() {
            if (CompilerDirectives.isPartialEvaluationConstant(this)) {
                Object languageContext = this.context;
                if (this.contextUnchangedAssumption.isValid()) {
                    return languageContext;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.context;
            }
            return this.context;
        }
    }

    public static final class InlineParsingRequest {
        private final Node node;
        private final MaterializedFrame frame;
        private final Source source;
        private boolean disposed;

        InlineParsingRequest(Source source, Node node, MaterializedFrame frame) {
            Objects.requireNonNull(source);
            this.node = node;
            this.frame = frame;
            this.source = source;
        }

        public Source getSource() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.source;
        }

        public Node getLocation() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.node;
        }

        public MaterializedFrame getFrame() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.frame;
        }

        void dispose() {
            this.disposed = true;
        }

        ExecutableNode parse(TruffleLanguage<?> truffleLanguage) throws Exception {
            return truffleLanguage.parse(this);
        }
    }

    public static final class ParsingRequest {
        private final Node node;
        private final MaterializedFrame frame;
        private final Source source;
        private final String[] argumentNames;
        private boolean disposed;

        ParsingRequest(Source source, Node node, MaterializedFrame frame, String ... argumentNames) {
            Objects.requireNonNull(source);
            this.node = node;
            this.frame = frame;
            this.source = source;
            this.argumentNames = argumentNames;
        }

        public Source getSource() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.source;
        }

        @Deprecated
        public Node getLocation() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.node;
        }

        @Deprecated
        public MaterializedFrame getFrame() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.frame;
        }

        public List<String> getArgumentNames() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.argumentNames == null ? Collections.emptyList() : ReadOnlyArrayList.asList(this.argumentNames, 0, this.argumentNames.length);
        }

        void dispose() {
            this.disposed = true;
        }

        CallTarget parse(TruffleLanguage<?> truffleLanguage) throws Exception {
            return truffleLanguage.parse(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String id() default "";

        public String name();

        public String implementationName() default "";

        public String version() default "inherit";

        public String[] mimeType();

        public boolean interactive() default true;

        public boolean internal() default false;

        public String[] dependentLanguages() default {};
    }
}

