/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.IdentCaseSensitivity;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLQualifiedNameList;
import com.adbs.ast.SyntaxSupportsConectedServer;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourcePropertiesDialog;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPropertiesDialog;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.AccessDescriptor;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.DB2Descriptor;
import com.adbs.syntax.FirebirdDescriptor;
import com.adbs.syntax.InformixDescriptor;
import com.adbs.syntax.MSSQLDescriptor;
import com.adbs.syntax.MySQLDescriptor;
import com.adbs.syntax.OracleDescriptor;
import com.adbs.syntax.PostgreSQLDescriptor;
import com.adbs.syntax.SQLiteDescriptor;
import com.adbs.syntax.ServerDescriptor;
import com.adbs.syntax.SybaseDescriptor;
import com.adbs.syntax.UniversalParser;
import com.adbs.syntax.UniversalScanner;
import com.adbs.syntax.UniversalSyntaxServerType;
import com.adbs.syntax.UnknownServerDescriptor;
import java.util.ArrayList;
import java.util.List;

public class UniversalSyntaxProvider
extends BaseSyntaxProvider {
    private static final long serialVersionUID = 1L;
    private IdentCaseSensitivity identCaseSens = IdentCaseSensitivity.Insensitive;
    private ArrayList<String> builtinFunctionNames = new ArrayList();
    private boolean autoDetectServer = true;
    private Object serverDescriptor;
    private Object defaultDescriptor = new UnknownServerDescriptor();
    private Object preferredDescriptor = new MSSQLDescriptor();
    private ArrayList serverDescriptors = new ArrayList();

    public UniversalSyntaxProvider() {
        this.builtinFunctionNames.add("Position");
        this.builtinFunctionNames.add("Char_Length");
        this.builtinFunctionNames.add("Character_Length");
        this.builtinFunctionNames.add("Octet_Length");
        this.builtinFunctionNames.add("Bit_Length");
        this.builtinFunctionNames.add("Extract");
        this.builtinFunctionNames.add("SubString");
        this.builtinFunctionNames.add("Upper");
        this.builtinFunctionNames.add("Lower");
        this.builtinFunctionNames.add("Convert");
        this.builtinFunctionNames.add("Translate");
        this.builtinFunctionNames.add("Trim");
        this.builtinFunctionNames.add("Current_Time");
        this.builtinFunctionNames.add("Current_Timestamp");
        this.builtinFunctionNames.add("NullIf");
        this.builtinFunctionNames.add("Coalesce");
        this.serverDescriptors.add(this.preferredDescriptor);
        this.serverDescriptors.add(new MSSQLDescriptor());
        this.serverDescriptors.add(new AccessDescriptor());
        this.serverDescriptors.add(new MySQLDescriptor());
        this.serverDescriptors.add(new OracleDescriptor());
        this.serverDescriptors.add(new PostgreSQLDescriptor());
        this.serverDescriptors.add(new FirebirdDescriptor());
        this.serverDescriptors.add(new DB2Descriptor());
        this.serverDescriptors.add(new SybaseDescriptor());
        this.serverDescriptors.add(new InformixDescriptor());
        this.serverDescriptors.add(new SQLiteDescriptor());
        this.serverDescriptor = this.preferredDescriptor;
    }

    @Override
    public IdentCaseSensitivity getIdentCaseSens() {
        return this.identCaseSens;
    }

    @Override
    public void setIdentCaseSens(IdentCaseSensitivity identCaseSens) {
        if (this.identCaseSens != identCaseSens) {
            this.identCaseSens = identCaseSens;
            this.sendNotifications();
        }
    }

    public ArrayList<String> getBuiltinFunctionNames() {
        return this.builtinFunctionNames;
    }

    public void setBuiltinFunctionNames(ArrayList<String> builtinFunctionNames) {
        if (this.builtinFunctionNames != builtinFunctionNames) {
            this.builtinFunctionNames = builtinFunctionNames;
        }
    }

    public UniversalSyntaxServerType getSyntaxType() {
        return ((ServerDescriptor)this.serverDescriptor).getServerType();
    }

    public UniversalSyntaxServerType getPreferredServer() {
        return ((ServerDescriptor)this.preferredDescriptor).getServerType();
    }

    public void setPreferredServer(UniversalSyntaxServerType value) throws Exception {
        if (value != this.getPreferredServer()) {
            this.preferredDescriptor = this.findServerDescriptorByServerType(value);
        }
    }

    public boolean getAutoDetectServer() {
        return this.autoDetectServer;
    }

    public void setAutoDetectServer(boolean autoDetectServer) {
        this.autoDetectServer = autoDetectServer;
    }

    public UniversalSyntaxServerType getUsedServer() {
        return ((ServerDescriptor)this.serverDescriptor).getServerType();
    }

    @Override
    public BaseSyntaxProvider clone() {
        UniversalSyntaxProvider result = (UniversalSyntaxProvider)super.clone();
        result.identCaseSens = this.identCaseSens;
        return result;
    }

    @Override
    protected Class getParserClass() {
        return UniversalParser.class;
    }

    @Override
    protected Class getScannerClass() {
        return UniversalScanner.class;
    }

    @Override
    public String getQuoteBegin() {
        return ((ServerDescriptor)this.serverDescriptor).getQuoteBegin();
    }

    @Override
    public String getQuoteEnd() {
        return ((ServerDescriptor)this.serverDescriptor).getQuoteEnd();
    }

    @Override
    public void getBuiltinFunctionNames(SQLQualifiedNameList names) {
        super.getBuiltinFunctionNames(names);
        for (int i = 0; i < this.builtinFunctionNames.size(); ++i) {
            names.addBuiltin(this.builtinFunctionNames.get(i));
        }
    }

    @Override
    public boolean isSupportANSIJoins() {
        return true;
    }

    @Override
    public boolean isForceBinaryANSIJoins() {
        return ((ServerDescriptor)this.serverDescriptor).isForceBinaryANSIJoins();
    }

    @Override
    public boolean isSupportOracleJoins() {
        return false;
    }

    @Override
    public boolean isSupportCrossJoin() {
        return ((ServerDescriptor)this.serverDescriptor).isSupportCrossJoin();
    }

    @Override
    public boolean isUniversalExpressions() {
        return ((ServerDescriptor)this.serverDescriptor).isUniversalExpressions();
    }

    @Override
    public boolean isSupportAllTableFieldsSelection() {
        return true;
    }

    @Override
    public boolean isSupportViews() {
        return true;
    }

    @Override
    public boolean isSupportProcedures() {
        return true;
    }

    @Override
    public boolean isSupportSynonyms() {
        return true;
    }

    @Override
    public boolean isSupportUnions() {
        return true;
    }

    @Override
    public boolean isSupportBracketsInUnions() {
        return true;
    }

    @Override
    public boolean isSupportDerivedTables() {
        return true;
    }

    @Override
    public boolean isSupportCTE() {
        return false;
    }

    @Override
    public boolean isSupportRecursiveCTE() {
        return false;
    }

    @Override
    public boolean isSupportSubQueryUnions() {
        return true;
    }

    @Override
    public boolean isSupportSubQueryBracketsInUnions() {
        return true;
    }

    @Override
    public boolean isSupportSubQueryDerivedTables() {
        return true;
    }

    @Override
    public boolean isSupportSubQueryCTE() {
        return false;
    }

    @Override
    public boolean isSupportDatabases() {
        return ((ServerDescriptor)this.serverDescriptor).isSupportDatabases();
    }

    @Override
    public boolean isSupportSchemas() {
        return ((ServerDescriptor)this.serverDescriptor).isSupportSchemas();
    }

    @Override
    public boolean isOuterKeywordInLinksMandatory() {
        return true;
    }

    @Override
    public String getDescription() {
        return "Universal";
    }

    @Override
    public void getDatabaseList(BaseSQLContext sqlContext, SQLQualifiedNameList databaseList) throws QueryBuilderException {
        if (this.autoDetectServer) {
            this.redetectServer(sqlContext);
        } else {
            this.serverDescriptor = this.preferredDescriptor;
        }
        if (!((ServerDescriptor)this.serverDescriptor).getDatabasesList(sqlContext, databaseList)) {
            super.getDatabaseList(sqlContext, databaseList);
        }
    }

    @Override
    public void loadMetadataObjects(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (this.autoDetectServer) {
            this.redetectServer(sqlContext);
        } else {
            this.serverDescriptor = this.preferredDescriptor;
        }
        if (!((ServerDescriptor)this.serverDescriptor).loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataObjects(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public void loadMetadataRelations(BaseSQLContext sqlContext, MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        if (!((ServerDescriptor)this.serverDescriptor).loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database)) {
            super.loadMetadataRelations(sqlContext, metadataContainer, metadataFilter, database);
        }
    }

    @Override
    public SQLQualifiedName getDefaultDatabaseName(BaseSQLContext sqlContext) throws QueryBuilderException {
        SQLQualifiedName result = ((ServerDescriptor)this.serverDescriptor).getDefaultDatabaseName(sqlContext);
        if (result == null) {
            result = super.getDefaultDatabaseName(sqlContext);
        }
        return result;
    }

    @Override
    public void getDefaultSchemaNames(BaseSQLContext sqlContext, SQLIdentifiersCollection defaultSchemaNames) throws QueryBuilderException {
        if (!((ServerDescriptor)this.serverDescriptor).getDefaultSchemaNames(sqlContext, defaultSchemaNames)) {
            super.getDefaultSchemaNames(sqlContext, defaultSchemaNames);
        }
    }

    @Override
    public void getUnionOperatorList(List<String> sl) {
        super.getUnionOperatorList(sl);
        sl.add("Except");
        sl.add("Intersect");
    }

    @Override
    public Class getEditPropsFormClass(Object forObj) {
        if (forObj instanceof Link) {
            return LinkPropertiesDialog.class;
        }
        if (forObj instanceof DataSource) {
            return DataSourcePropertiesDialog.class;
        }
        return super.getEditPropsFormClass(forObj);
    }

    private Object detectServerInternal(BaseSQLContext sqlContext) {
        if (sqlContext.getMetadataProvider() != null && sqlContext.getMetadataProvider().canExecSQL()) {
            ServerDescriptor sd = (ServerDescriptor)this.preferredDescriptor;
            if (sd.isSupportConnectedServer(sqlContext.getMetadataProvider()) == SyntaxSupportsConectedServer.Yes) {
                return sd;
            }
            sd = (ServerDescriptor)this.serverDescriptor;
            if (sd != this.preferredDescriptor && sd.isSupportConnectedServer(sqlContext.getMetadataProvider()) == SyntaxSupportsConectedServer.Yes) {
                return sd;
            }
            for (int i = 0; i < this.serverDescriptors.size(); ++i) {
                sd = (ServerDescriptor)this.serverDescriptors.get(i);
                if (sd == this.preferredDescriptor || sd == this.serverDescriptor || sd.isSupportConnectedServer(sqlContext.getMetadataProvider()) != SyntaxSupportsConectedServer.Yes) continue;
                return sd;
            }
            return this.defaultDescriptor;
        }
        return this.preferredDescriptor;
    }

    public UniversalSyntaxServerType detectServer(BaseSQLContext sqlContext) {
        return ((ServerDescriptor)this.detectServerInternal(sqlContext)).getServerType();
    }

    public void redetectServer(BaseSQLContext sqlContext) {
        this.serverDescriptor = this.detectServerInternal(sqlContext);
    }

    private ServerDescriptor findServerDescriptorByServerType(UniversalSyntaxServerType serverType) throws Exception {
        ServerDescriptor sd = (ServerDescriptor)this.defaultDescriptor;
        if (sd.getServerType() == serverType) {
            return sd;
        }
        for (int i = 0; i < this.serverDescriptors.size(); ++i) {
            sd = (ServerDescriptor)this.serverDescriptors.get(i);
            if (sd.getServerType() != serverType) continue;
            return sd;
        }
        throw new Exception("UniversalSyntaxProvider.FindServerDescriptorByServerType: unknown server type");
    }

    @Override
    public boolean isAsKeywordInExpressionAliasMandatory() {
        return true;
    }

    @Override
    public boolean isAsKeywordInObjectAliasMandatory() {
        return false;
    }

    @Override
    public boolean isInnerKeywordInLinksMandatory() {
        return true;
    }

    @Override
    public String getUpperCaseFunctionName() {
        return "upper";
    }

    @Override
    public boolean isSupportTransactSQLJoins() {
        return false;
    }

    @Override
    protected void setDetectServerVersion(boolean value) {
    }
}

