/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNode;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLQualifiedName;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostgreSQLSelectIntoClause
extends AstNode {
    public boolean temporary;
    public SQLQualifiedName tableName;

    public PostgreSQLSelectIntoClause(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(PostgreSQLSelectIntoClause.class.getField("tableName"));
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof PostgreSQLSelectIntoClause) {
            this.temporary = ((PostgreSQLSelectIntoClause)source).temporary;
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeKeyword("Into");
        builder.addIndent(format.getIndentInPart());
        builder.newLineOrSpace(format.getNewLineAfterPartKeywords());
        if (this.temporary) {
            builder.writeKeyword("Temporary");
            builder.space();
        }
        builder.writeKeyword("Table");
        builder.space();
        this.buildASTField(this.tableName, builder, format);
        builder.endIndent();
    }
}

