/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstExtender;
import com.adbs.ast.AstFieldList;
import com.adbs.ast.AstNode;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.syntax.OracleSQLHierarchicalQueryClause;
import com.adbs.syntax.OracleSQLModelClause;
import com.adbs.utils.Str;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OracleSQLSubQueryExtender
extends AstExtender {
    public String optimizerHints;
    public OracleSQLHierarchicalQueryClause hierarchicalQueryClause;
    public OracleSQLModelClause modelClause;

    public OracleSQLSubQueryExtender(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    protected void getASTFields(AstFieldList l) {
        super.getASTFields(l);
        try {
            l.add(OracleSQLSubQueryExtender.class.getField("hierarchicalQueryClause"));
            l.add(OracleSQLSubQueryExtender.class.getField("modelClause"));
        }
        catch (Exception ex) {
            Logger.getLogger(OracleSQLSubQueryExtender.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        OracleSQLSubQueryExtender sourceAsExtender = (OracleSQLSubQueryExtender)source;
        if (sourceAsExtender != null) {
            this.optimizerHints = sourceAsExtender.optimizerHints;
        }
    }

    @Override
    public void buildSQLForNode(AstNode n, SQLBuilder builder, SQLBuilderSelectFormat format) {
        SQLSubQuerySelectExpression s = (SQLSubQuerySelectExpression)n;
        if (Str.IsNullOrEmpty(this.optimizerHints)) {
            s.buildSelectList(builder, format);
        } else {
            builder.writeKeyword("Select");
            builder.addIndent(format.getIndentInPart());
            builder.space(0);
            builder.writeComment(String.format("/*+ %1$s */", this.optimizerHints));
            s.buildSelectMode(builder, format);
            if (format.getNewLineAfterPartKeywords()) {
                builder.newLine();
            }
            s.buildSelectListItems(builder, format);
            builder.endIndent();
        }
        s.buildFromClause(builder, format);
        s.buildWhereClause(builder, format);
        if (this.hierarchicalQueryClause != null) {
            if (format.getMainPartsFromNewLine()) {
                builder.newLine();
            } else {
                builder.space(1);
            }
            this.hierarchicalQueryClause.buildSQL(builder, format);
        }
        s.buildGroupByClause(builder, format);
        s.buildHavingClause(builder, format);
        if (this.modelClause != null) {
            if (format.getMainPartsFromNewLine()) {
                builder.newLine();
            } else {
                builder.space(1);
            }
            this.modelClause.buildSQL(builder, format);
        }
        s.buildOrderByClause(builder, format);
    }
}

