/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.syntax;

import com.adbs.ast.AstNodeWithList;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.syntax.OracleSQLForUpdateWaitMode;

public class OracleSQLForUpdateClause
extends AstNodeWithList {
    public OracleSQLForUpdateWaitMode waitMode = OracleSQLForUpdateWaitMode.Default;
    public int waitTime = 0;

    public OracleSQLForUpdateClause(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof OracleSQLForUpdateClause) {
            this.waitMode = ((OracleSQLForUpdateClause)source).waitMode;
            this.waitTime = ((OracleSQLForUpdateClause)source).waitTime;
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        builder.writeKeyword("For");
        builder.space();
        builder.writeKeyword("Update");
        if (this.getCount() > 0) {
            builder.space();
            builder.writeKeyword("Of");
            for (int i = 0; i < this.getCount(); ++i) {
                builder.space();
                this.get(i).buildSQL(builder, format);
                if (i >= this.getCount() - 1) continue;
                builder.writeSymbol(",");
            }
        }
        switch (this.waitMode) {
            case Default: {
                break;
            }
            case NoWait: {
                builder.space();
                builder.writeKeyword("NoWait");
                break;
            }
            case Wait: {
                builder.space();
                builder.writeKeyword("Wait");
                builder.space();
                builder.writeNumber(String.valueOf(this.waitTime));
                break;
            }
        }
    }
}

