/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.DataSourceFieldList;
import com.adbs.querybuilder.LeftBracket;
import com.adbs.querybuilder.QueryBase;
import com.adbs.querybuilder.RightBracket;
import com.adbs.querybuilder.UnionGroup;
import com.adbs.querybuilder.UnionNavBar;
import com.adbs.querybuilder.UnionSubQuery;
import com.adbs.utils.Helpers;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;

public class UnionButton
extends JToggleButton
implements Transferable {
    private static final long serialVersionUID = 1L;
    UnionSubQuery unionSubQuery;
    public static final DataFlavor UNION_BUTTON_FLAVOR = new DataFlavor(UnionButton.class, "Union Button");
    static DataFlavor[] flavors = new DataFlavor[]{UNION_BUTTON_FLAVOR};

    public UnionButton(final UnionSubQuery unionSubQuery) {
        this.unionSubQuery = unionSubQuery;
        this.setPreferredSize(new Dimension(24, 24));
        this.setSize(24, 24);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setIcon(Helpers.createImageIcon("images/Q.png"));
        this.setFocusable(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3 && e.getClickCount() == 1) {
                    unionSubQuery.getQueryBuilder().popupMenuPopup(UnionButton.this.getPopupMenu(), UnionButton.this, unionSubQuery, e.getPoint());
                }
                super.mouseClicked(e);
            }
        });
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        this.unionSubQuery.getRootQuery().setActiveUnionSubquery(this.unionSubQuery);
        super.fireActionPerformed(event);
    }

    protected JPopupMenu getPopupMenu() {
        return this.unionSubQuery.getPopupMenu();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(UNION_BUTTON_FLAVOR);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(UNION_BUTTON_FLAVOR)) {
            return this;
        }
        throw new UnsupportedFlavorException(flavor);
    }

    private class CustomDropTargetListener
    extends DropTargetAdapter {
        private CustomDropTargetListener() {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            boolean accept = false;
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(UNION_BUTTON_FLAVOR)) {
                accept = true;
            } else if (transferable.isDataFlavorSupported(LeftBracket.LEFT_BRACKET_FLAVOR)) {
                try {
                    LeftBracket br = (LeftBracket)transferable.getTransferData(LeftBracket.LEFT_BRACKET_FLAVOR);
                    if (br.query == UnionButton.this.unionSubQuery.getParentQuery() || br.query.getParentQuery() == UnionButton.this.unionSubQuery.getParentQuery() && UnionButton.this.unionSubQuery.getParentQuery().items.indexOf(UnionButton.this.unionSubQuery) < UnionButton.this.unionSubQuery.getParentQuery().items.indexOf(br.query)) {
                        accept = true;
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSourceFieldList.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (transferable.isDataFlavorSupported(RightBracket.RIGHT_BRACKET_FLAVOR)) {
                try {
                    RightBracket br = (RightBracket)transferable.getTransferData(RightBracket.RIGHT_BRACKET_FLAVOR);
                    if (br.query == UnionButton.this.unionSubQuery.getParentQuery() || br.query.getParentQuery() == UnionButton.this.unionSubQuery.getParentQuery() && UnionButton.this.unionSubQuery.getParentQuery().items.indexOf(UnionButton.this.unionSubQuery) > UnionButton.this.unionSubQuery.getParentQuery().items.indexOf(br.query)) {
                        accept = true;
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSourceFieldList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (accept) {
                event.acceptDrag(2);
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            QueryBase secondUnion;
            int index;
            event.acceptDrop(2);
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(UNION_BUTTON_FLAVOR)) {
                try {
                    ArrayList l = new ArrayList();
                    UnionButton ub = (UnionButton)transferable.getTransferData(UNION_BUTTON_FLAVOR);
                    UnionSubQuery droppedUnionSubQuery = ub.unionSubQuery;
                    UnionGroup oldGroup = droppedUnionSubQuery.getParentQuery();
                    ((UnionNavBar)UnionButton.this.getParent()).buildList(l, UnionButton.this.unionSubQuery.getRootQuery());
                    index = l.indexOf(UnionButton.this.unionSubQuery);
                    int sourceIndex = l.indexOf(droppedUnionSubQuery);
                    if (index < sourceIndex) {
                        if (index == 0) {
                            UnionButton.this.unionSubQuery.setUnionOperatorFull(droppedUnionSubQuery.getUnionOperatorFull());
                        }
                        UnionButton.this.unionSubQuery.insertBefore(droppedUnionSubQuery);
                    } else {
                        if (sourceIndex == 0) {
                            secondUnion = droppedUnionSubQuery.getParentQuery().get(1);
                            droppedUnionSubQuery.setUnionOperatorFull(secondUnion.getUnionOperatorFull());
                        }
                        UnionButton.this.unionSubQuery.insertAfter(ub.unionSubQuery);
                    }
                    if (oldGroup.getCount() == 0) {
                        oldGroup.dispose();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSourceFieldList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (transferable.isDataFlavorSupported(LeftBracket.LEFT_BRACKET_FLAVOR)) {
                try {
                    LeftBracket bracket = (LeftBracket)transferable.getTransferData(LeftBracket.LEFT_BRACKET_FLAVOR);
                    UnionGroup oldGroup = bracket.query;
                    if (bracket.query == UnionButton.this.unionSubQuery.getParentQuery()) {
                        assert (bracket.query.getCount() > 0);
                        QueryBase firstUnion = bracket.query.get(0);
                        firstUnion.setUnionOperatorFull(bracket.query.getUnionOperatorFull());
                        index = bracket.query.indexOf(UnionButton.this.unionSubQuery);
                        if (bracket.query.getCount() > index + 1) {
                            secondUnion = bracket.query.get(index + 1);
                            bracket.query.setUnionOperatorFull(secondUnion.getUnionOperatorFull());
                        }
                        bracket.query.removeFromBegin(UnionButton.this.unionSubQuery);
                    } else {
                        if (bracket.query.getCount() > 0) {
                            QueryBase firstUnion = bracket.query.get(0);
                            firstUnion.setUnionOperatorFull(bracket.query.getUnionOperatorFull());
                        }
                        bracket.query.addToBegin(UnionButton.this.unionSubQuery);
                        bracket.query.setUnionOperatorFull(UnionButton.this.unionSubQuery.getUnionOperatorFull());
                    }
                    if (oldGroup.getCount() == 0) {
                        oldGroup.dispose();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSourceFieldList.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (transferable.isDataFlavorSupported(RightBracket.RIGHT_BRACKET_FLAVOR)) {
                try {
                    RightBracket bracket = (RightBracket)transferable.getTransferData(RightBracket.RIGHT_BRACKET_FLAVOR);
                    UnionGroup oldGroup = bracket.query;
                    if (bracket.query == UnionButton.this.unionSubQuery.getParentQuery()) {
                        bracket.query.removeFromEnd(UnionButton.this.unionSubQuery);
                    } else {
                        bracket.query.addToEnd(UnionButton.this.unionSubQuery);
                    }
                    if (oldGroup.getCount() == 0) {
                        oldGroup.dispose();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(DataSourceFieldList.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private class CustomDragGestureListener
    implements DragGestureListener {
        private CustomDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            dge.startDrag(null, UnionButton.this);
        }
    }
}

