/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.StatsObject;
import com.adbs.ast.StatsObjects;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.StatisticsBase;
import com.adbs.querybuilder.StatisticsDatabaseObject;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatisticsDatabaseObjectList
extends StatisticsBase {
    private ArrayList<StatisticsDatabaseObject> databaseObjects = new ArrayList();

    public StatisticsDatabaseObjectList(QueryBuilder queryBuilder, BaseSQLContext sqlContext) {
        super(queryBuilder, sqlContext);
    }

    public int getCount() {
        if (!this.isStatisticsValid()) {
            try {
                this.getQueryBuilder().generateResultQueryAST();
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(StatisticsDatabaseObjectList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.databaseObjects.size();
    }

    public StatisticsDatabaseObject get(int index) {
        if (!this.isStatisticsValid()) {
            try {
                this.getQueryBuilder().generateResultQueryAST();
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(StatisticsDatabaseObjectList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.databaseObjects.get(index);
    }

    @Override
    public void dispose() {
        for (StatisticsDatabaseObject o : this.databaseObjects) {
            o.dispose();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadStatistics(SQLSelectStatement query, StatsObjects usedDatabaseObjects) {
        BaseSQLContext context = this.getSQLContext();
        for (int i = 0; i < usedDatabaseObjects.getCount(); ++i) {
            StatisticsDatabaseObject tDatabaseObject;
            StatsObject tStatsObject;
            block17: {
                tStatsObject = usedDatabaseObjects.get(i);
                if (tStatsObject.getMetadataObject() != null) {
                    MetadataObject mo = tStatsObject.getMetadataObject();
                    tDatabaseObject = new StatisticsDatabaseObject(this.getQueryBuilder(), context, mo, mo.getSchema(), mo.getName(), mo.getDatabase(), mo.getFullName());
                    this.databaseObjects.add(tDatabaseObject);
                } else {
                    SQLQualifiedName tDatabase = new SQLQualifiedName(context);
                    try {
                        SQLQualifiedName tFullName = tStatsObject.getName().clone(context);
                        try {
                            tDatabase.assign(tFullName);
                            if (tDatabase.getCount() > 0 && tDatabase.get(0) instanceof AstTokenIdentifier) {
                                AstTokenIdentifier tName = (AstTokenIdentifier)tDatabase.extractName();
                                try {
                                    AstTokenIdentifier tSchema = tDatabase.getCount() > 0 && context.getSyntaxProvider().isSupportSchemas() ? (AstTokenIdentifier)tDatabase.extractName() : new AstTokenIdentifier(context);
                                    try {
                                        tDatabaseObject = new StatisticsDatabaseObject(this.getQueryBuilder(), context, null, tSchema, tName, tDatabase, tFullName);
                                        this.databaseObjects.add(tDatabaseObject);
                                        break block17;
                                    }
                                    finally {
                                        if (tSchema != null) {
                                            tSchema.dispose();
                                        }
                                    }
                                }
                                finally {
                                    tName.dispose();
                                }
                            }
                            tDatabaseObject = null;
                        }
                        finally {
                            tFullName.dispose();
                        }
                    }
                    finally {
                        tDatabase.dispose();
                    }
                }
            }
            if (tDatabaseObject == null) continue;
            tDatabaseObject.getAliases().assign(tStatsObject.getAliases());
        }
        this.setStatisticsValid();
    }

    @Override
    protected void setStatisticsInvalidInternal() {
        super.setStatisticsInvalidInternal();
        for (StatisticsDatabaseObject o : this.databaseObjects) {
            o.dispose();
        }
        this.databaseObjects.clear();
    }
}

