/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstIdentifierList;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.StatisticsBase;

public class StatisticsDatabaseObject
extends StatisticsBase {
    private AstTokenIdentifier schema;
    private AstTokenIdentifier name;
    private SQLQualifiedName database;
    private SQLQualifiedName fullName;
    private MetadataObject metadataObject;
    private AstIdentifierList aliases;

    public StatisticsDatabaseObject(QueryBuilder queryBuilder, BaseSQLContext sqlContext, MetadataObject metadataObject, AstTokenIdentifier schema, AstTokenIdentifier name, SQLQualifiedName database, SQLQualifiedName fullName) {
        super(queryBuilder, sqlContext);
        this.metadataObject = metadataObject;
        this.schema = schema != null ? schema.clone(sqlContext) : new AstTokenIdentifier(sqlContext);
        this.name = name != null ? name.clone(sqlContext) : new AstTokenIdentifier(sqlContext);
        this.database = database != null ? database.clone(sqlContext) : new SQLQualifiedName(sqlContext);
        this.fullName = fullName.clone(sqlContext);
        if (this.fullName instanceof SQLDatabaseObject) {
            ((SQLDatabaseObject)this.fullName).datasource = null;
        }
        this.aliases = new AstIdentifierList(sqlContext);
    }

    @Override
    public void dispose() {
        if (this.schema != null) {
            this.schema.dispose();
        }
        if (this.name != null) {
            this.name.dispose();
        }
        if (this.database != null) {
            this.database.dispose();
        }
        if (this.fullName != null) {
            this.fullName.dispose();
        }
        if (this.aliases != null) {
            this.aliases.dispose();
        }
        super.dispose();
    }

    public MetadataObject getMetadataObject() {
        return this.metadataObject;
    }

    public AstTokenIdentifier getSchema() {
        return this.schema;
    }

    public AstTokenIdentifier getName() {
        return this.name;
    }

    public SQLQualifiedName getDatabase() {
        return this.database;
    }

    public SQLQualifiedName getFullName() {
        return this.fullName;
    }

    public AstIdentifierList getAliases() {
        return this.aliases;
    }
}

