/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.SQLSelectItem;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SQLSubQueryExpression;
import com.adbs.ast.SQLSubQueryExpressions;
import com.adbs.ast.SQLSubQuerySelectExpression;
import com.adbs.ast.StatsColumn;
import com.adbs.ast.StatsColumns;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.StatisticsBase;
import com.adbs.querybuilder.StatisticsColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatisticsColumnList
extends StatisticsBase {
    private ArrayList<StatisticsColumn> databaseObjectColumns = new ArrayList();

    public StatisticsColumnList(QueryBuilder queryBuilder, BaseSQLContext sqlContext) {
        super(queryBuilder, sqlContext);
    }

    @Override
    public void dispose() {
        for (StatisticsColumn c : this.databaseObjectColumns) {
            c.dispose();
        }
        super.dispose();
    }

    public int getCount() {
        if (!this.isStatisticsValid()) {
            try {
                this.getQueryBuilder().generateResultQueryAST();
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(StatisticsColumnList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.databaseObjectColumns.size();
    }

    public StatisticsColumn get(int index) {
        if (!this.isStatisticsValid()) {
            try {
                this.getQueryBuilder().generateResultQueryAST();
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(StatisticsColumnList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.databaseObjectColumns.get(index);
    }

    private void calcSelectedColumnsFromQuery(StatsColumns where, List selected, SQLSubQuerySelectExpression query) {
        if (query.selectItems != null) {
            for (int i = 0; i < query.selectItems.getCount(); ++i) {
                SQLSelectItem si = query.selectItems.get(i);
                for (int j = 0; j < si.getUsedDatabaseObjectColumns().getCount(); ++j) {
                    StatsColumn sf = si.getUsedDatabaseObjectColumns().get(j);
                    StatsColumn f = where.findColumn(sf.getMetadataObject(), sf.getObjectName(), sf.getMetadataField(), sf.getName());
                    if (f == null || selected.indexOf(f) != -1) continue;
                    selected.add(f);
                }
            }
        }
    }

    private void calcSelectedColumnsFromGroup(StatsColumns where, ArrayList selected, SQLSubQueryExpressions queryGroup) {
        for (int i = 0; i < queryGroup.getCount(); ++i) {
            SQLSubQueryExpression q = queryGroup.get(i);
            if (q instanceof SQLSubQuerySelectExpression) {
                this.calcSelectedColumnsFromQuery(where, selected, (SQLSubQuerySelectExpression)q);
                continue;
            }
            this.calcSelectedColumnsFromGroup(where, selected, (SQLSubQueryExpressions)q);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadStatistics(SQLSelectStatement query, StatsColumns usedDatabaseObjectColumns) {
        ArrayList selectedColumns = new ArrayList();
        this.calcSelectedColumnsFromGroup(usedDatabaseObjectColumns, selectedColumns, query);
        for (StatisticsColumn c : this.databaseObjectColumns) {
            c.dispose();
        }
        this.databaseObjectColumns.clear();
        for (int i = 0; i < usedDatabaseObjectColumns.getCount(); ++i) {
            StatisticsColumn tDatabaseObject;
            boolean selectedFlag;
            StatsColumn tStatsColumn = usedDatabaseObjectColumns.get(i);
            boolean bl = selectedFlag = selectedColumns.indexOf(tStatsColumn) != -1;
            if (tStatsColumn.getMetadataObject() != null) {
                MetadataObject mo = tStatsColumn.getMetadataObject();
                if (tStatsColumn.getMetadataField() != null) {
                    MetadataField mf = tStatsColumn.getMetadataField();
                    tDatabaseObject = new StatisticsColumn(this.getQueryBuilder(), this.getSQLContext(), mf, mf.getName(), mo, mo.getSchema(), mo.getName(), mo.getDatabase(), selectedFlag, false);
                } else {
                    tDatabaseObject = new StatisticsColumn(this.getQueryBuilder(), this.getSQLContext(), null, tStatsColumn.getName(), mo, mo.getSchema(), mo.getName(), mo.getDatabase(), selectedFlag, false);
                }
                this.databaseObjectColumns.add(tDatabaseObject);
                continue;
            }
            SQLQualifiedName tDatabase = tStatsColumn.getObjectName().clone(this.getSQLContext());
            try {
                if (tDatabase.getCount() <= 0 || !(tDatabase.get(0) instanceof AstTokenIdentifier)) continue;
                AstTokenIdentifier tName = (AstTokenIdentifier)tDatabase.extractName();
                try {
                    AstTokenIdentifier tSchema = tDatabase.getCount() > 0 && this.getSQLContext().getSyntaxProvider().isSupportSchemas() ? (AstTokenIdentifier)tDatabase.extractName() : new AstTokenIdentifier(this.getSQLContext());
                    try {
                        tDatabaseObject = new StatisticsColumn(this.getQueryBuilder(), this.getSQLContext(), null, tStatsColumn.getName(), null, tSchema, tName, tDatabase, selectedFlag, false);
                        this.databaseObjectColumns.add(tDatabaseObject);
                        continue;
                    }
                    finally {
                        if (tSchema != null) {
                            tSchema.dispose();
                        }
                    }
                }
                finally {
                    tName.dispose();
                }
            }
            finally {
                tDatabase.dispose();
            }
        }
        this.setStatisticsValid();
    }
}

