/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLDatabaseObject;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.StatisticsBase;
import com.adbs.utils.Str;

public class StatisticsColumn
extends StatisticsBase {
    private SQLQualifiedName name;
    private AstTokenIdentifier schema;
    private AstTokenIdentifier objectName;
    private SQLQualifiedName database;
    private SQLQualifiedName fullName;
    boolean usedInQueryText;
    boolean selected;
    MetadataField metadataField;
    MetadataObject metadataObject;

    public StatisticsColumn(QueryBuilder queryBuilder, BaseSQLContext sqlContext, MetadataField metadataField, SQLQualifiedName name, MetadataObject metadataObject, AstTokenIdentifier schema, AstTokenIdentifier objectName, SQLQualifiedName database, boolean selected, boolean usedInQueryText) {
        super(queryBuilder, sqlContext);
        this.metadataField = metadataField;
        this.name = name.clone(sqlContext);
        this.metadataObject = metadataObject;
        this.schema = schema.clone(sqlContext);
        this.objectName = objectName.clone(sqlContext);
        this.database = database.clone(sqlContext);
        this.selected = selected;
        this.usedInQueryText = usedInQueryText;
        if (this.database instanceof SQLDatabaseObject) {
            ((SQLDatabaseObject)this.database).datasource = null;
        }
        this.fullName = this.database.clone(sqlContext);
        if (!Str.IsNullOrEmpty(this.schema.getToken())) {
            this.fullName.addName(this.schema.clone(sqlContext));
        }
        this.fullName.addName(this.objectName.clone(sqlContext));
        for (int i = this.name.getCount() - 1; i >= 0; --i) {
            this.fullName.addName(this.name.get(i).clone(sqlContext));
        }
    }

    @Override
    public void dispose() {
        if (this.name != null) {
            this.name.dispose();
        }
        if (this.schema != null) {
            this.schema.dispose();
        }
        if (this.objectName != null) {
            this.objectName.dispose();
        }
        if (this.database != null) {
            this.database.dispose();
        }
        if (this.fullName != null) {
            this.fullName.dispose();
        }
        super.dispose();
    }

    public MetadataObject getMetadataObject() {
        return this.metadataObject;
    }

    public MetadataField getMetadataField() {
        return this.metadataField;
    }

    public SQLQualifiedName getName() {
        return this.name;
    }

    public AstTokenIdentifier getObjectName() {
        return this.objectName;
    }

    public AstTokenIdentifier getSchema() {
        return this.schema;
    }

    public SQLQualifiedName getDatabase() {
        return this.database;
    }

    public SQLQualifiedName getFullName() {
        return this.fullName;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isUsedInQueryText() {
        return this.usedInQueryText;
    }

    public int getFieldType() {
        if (this.metadataField != null) {
            return this.metadataField.getFieldType();
        }
        return 1111;
    }
}

