/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.BasePropertyPanel;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryStructureTreeOptions;
import com.adbs.utils.Helpers;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class QueryStructureTreePage
extends BasePropertyPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private QueryBuilder queryBuilder = null;
    private JCheckBox cbExpandDatasources;
    private JCheckBox cbExpandFields;
    private JCheckBox cbExpandSubqueries;
    private JCheckBox cbExpandUnions;
    private JCheckBox cbShowDataSources;
    private JCheckBox cbShowFieldList;
    private JPanel groupLabel1;
    private JPanel groupLabel2;
    private JPanel groupLabel3;
    private JLabel label10;
    private JLabel label8;
    private JLabel label9;
    private JTextField textFieldsNodeTitle;
    private JTextField textFromNodeTitle;
    private JTextField textUnionsNodeTitle;

    public QueryStructureTreePage(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.initComponents();
        Helpers.localizer.localizePanel(this);
        QueryStructureTreeOptions o = queryBuilder.getQueryStructureTreeOptions();
        this.cbShowFieldList.setSelected(o.isShowFields());
        this.cbShowDataSources.setSelected(o.isExpandFromNodes());
        this.textFieldsNodeTitle.setText(o.getFieldsNodeText());
        this.textFromNodeTitle.setText(o.getFromNodeText());
        this.textUnionsNodeTitle.setText(o.getUnionsNodeText());
        this.cbExpandFields.setSelected(o.isExpandFieldsNodes());
        this.cbExpandDatasources.setSelected(o.isExpandFromNodes());
        this.cbExpandSubqueries.setSelected(o.isExpandQueryNodes());
        this.cbExpandUnions.setSelected(o.isExpandUnionsNodes());
        this.cbShowFieldList.addActionListener(this);
        this.cbShowDataSources.addActionListener(this);
        this.textFieldsNodeTitle.getDocument().addDocumentListener(this);
        this.textFromNodeTitle.getDocument().addDocumentListener(this);
        this.textUnionsNodeTitle.getDocument().addDocumentListener(this);
        this.cbExpandFields.addActionListener(this);
        this.cbExpandDatasources.addActionListener(this);
        this.cbExpandSubqueries.addActionListener(this);
        this.cbExpandUnions.addActionListener(this);
    }

    @Override
    public void applyChanges() {
        if (this.isModified()) {
            this.queryBuilder.beginUpdate();
            try {
                QueryStructureTreeOptions o = this.queryBuilder.getQueryStructureTreeOptions();
                o.setShowFields(this.cbShowFieldList.isSelected());
                o.setExpandFromNodes(this.cbShowDataSources.isSelected());
                o.setFieldsNodeText(this.textFieldsNodeTitle.getText());
                o.setFromNodeText(this.textFromNodeTitle.getText());
                o.setUnionsNodeText(this.textUnionsNodeTitle.getText());
                o.setExpandFieldsNodes(this.cbExpandFields.isSelected());
                o.setExpandFromNodes(this.cbExpandDatasources.isSelected());
                o.setExpandQueryNodes(this.cbExpandSubqueries.isSelected());
                o.setExpandUnionsNodes(this.cbExpandUnions.isSelected());
            }
            finally {
                this.queryBuilder.endUpdate();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setModified(true);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setModified(true);
    }

    private void initComponents() {
        this.groupLabel2 = new JPanel();
        this.cbExpandFields = new JCheckBox();
        this.cbExpandDatasources = new JCheckBox();
        this.cbExpandSubqueries = new JCheckBox();
        this.cbExpandUnions = new JCheckBox();
        this.groupLabel1 = new JPanel();
        this.textFromNodeTitle = new JTextField();
        this.label9 = new JLabel();
        this.textFieldsNodeTitle = new JTextField();
        this.label10 = new JLabel();
        this.label8 = new JLabel();
        this.textUnionsNodeTitle = new JTextField();
        this.groupLabel3 = new JPanel();
        this.cbShowDataSources = new JCheckBox();
        this.cbShowFieldList = new JCheckBox();
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Dialog", 0, 11));
        this.setName("QueryStructureTreePage");
        this.groupLabel2.setBorder(BorderFactory.createTitledBorder(null, "Special Nodes Visibility", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel2.setName("groupLabel2");
        this.groupLabel2.setOpaque(false);
        this.cbExpandFields.setFont(this.cbExpandFields.getFont());
        this.cbExpandFields.setText("Fields");
        this.cbExpandFields.setName("cbExpandFields");
        this.cbExpandFields.setOpaque(false);
        this.cbExpandDatasources.setFont(this.cbExpandDatasources.getFont());
        this.cbExpandDatasources.setText("Data Source Objects");
        this.cbExpandDatasources.setName("cbExpandDatasources");
        this.cbExpandDatasources.setOpaque(false);
        this.cbExpandSubqueries.setFont(this.cbExpandSubqueries.getFont());
        this.cbExpandSubqueries.setText("Subqueries");
        this.cbExpandSubqueries.setName("cbExpandSubqueries");
        this.cbExpandSubqueries.setOpaque(false);
        this.cbExpandUnions.setFont(this.cbExpandUnions.getFont());
        this.cbExpandUnions.setText("Union Subqueries");
        this.cbExpandUnions.setName("cbExpandUnions");
        this.cbExpandUnions.setOpaque(false);
        GroupLayout groupLabel2Layout = new GroupLayout(this.groupLabel2);
        this.groupLabel2.setLayout(groupLabel2Layout);
        groupLabel2Layout.setHorizontalGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel2Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbExpandUnions).addComponent(this.cbExpandDatasources).addComponent(this.cbExpandFields).addComponent(this.cbExpandSubqueries)).addContainerGap(237, Short.MAX_VALUE)));
        groupLabel2Layout.setVerticalGroup(groupLabel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel2Layout.createSequentialGroup().addComponent(this.cbExpandFields).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbExpandDatasources).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbExpandSubqueries).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbExpandUnions)));
        this.groupLabel1.setBorder(BorderFactory.createTitledBorder(null, "Special Nodes Visibility", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel1.setName("groupLabel1");
        this.groupLabel1.setOpaque(false);
        this.textFromNodeTitle.setFont(this.textFromNodeTitle.getFont());
        this.label9.setFont(this.label9.getFont());
        this.label9.setText("Data sources node title");
        this.label9.setName("label9");
        this.textFieldsNodeTitle.setFont(this.textFieldsNodeTitle.getFont());
        this.label10.setFont(this.label10.getFont());
        this.label10.setText("Union subqueries node title");
        this.label10.setName("label10");
        this.label8.setFont(this.label8.getFont());
        this.label8.setText("Expressions node title");
        this.label8.setName("label8");
        this.textUnionsNodeTitle.setFont(this.textUnionsNodeTitle.getFont());
        GroupLayout groupLabel1Layout = new GroupLayout(this.groupLabel1);
        this.groupLabel1.setLayout(groupLabel1Layout);
        groupLabel1Layout.setHorizontalGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel1Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label10).addComponent(this.label9).addComponent(this.label8)).addGap(18, 18, 18).addGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textFieldsNodeTitle, -2, 167, -2).addComponent(this.textFromNodeTitle, -2, 167, -2).addComponent(this.textUnionsNodeTitle, -2, 167, -2)).addContainerGap(43, Short.MAX_VALUE)));
        groupLabel1Layout.setVerticalGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel1Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label8).addComponent(this.textFieldsNodeTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label9).addComponent(this.textFromNodeTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLabel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label10).addComponent(this.textUnionsNodeTitle, -2, -1, -2)).addContainerGap()));
        this.groupLabel3.setBorder(BorderFactory.createTitledBorder(null, "Special Nodes Visibility", 0, 0, new Font("Dialog", 1, 11), new Color(0, 133, 183)));
        this.groupLabel3.setName("groupLabel3");
        this.groupLabel3.setOpaque(false);
        this.cbShowDataSources.setFont(this.cbShowDataSources.getFont());
        this.cbShowDataSources.setText("Show data source object list for each subquery");
        this.cbShowDataSources.setName("cbShowDataSources");
        this.cbShowDataSources.setOpaque(false);
        this.cbShowFieldList.setFont(this.cbShowFieldList.getFont());
        this.cbShowFieldList.setText("Show field list for each subquery");
        this.cbShowFieldList.setName("cbShowFieldList");
        this.cbShowFieldList.setOpaque(false);
        GroupLayout groupLabel3Layout = new GroupLayout(this.groupLabel3);
        this.groupLabel3.setLayout(groupLabel3Layout);
        groupLabel3Layout.setHorizontalGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel3Layout.createSequentialGroup().addContainerGap().addGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShowDataSources).addComponent(this.cbShowFieldList)).addContainerGap(111, Short.MAX_VALUE)));
        groupLabel3Layout.setVerticalGroup(groupLabel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLabel3Layout.createSequentialGroup().addContainerGap().addComponent(this.cbShowFieldList).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowDataSources).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.groupLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.groupLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.groupLabel3, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.groupLabel3, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel1, -2, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupLabel2, -2, -1, -2).addGap(93, 93, 93)));
    }
}

