/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.LayoutItem;
import com.adbs.querybuilder.LayoutItemType;
import com.adbs.querybuilder.SubQuery;
import com.adbs.querybuilder.UnionSubQuery;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;

class QueryLayout {
    QueryLayout() {
    }

    private static LayoutItemType getItemType(ControlOwner item) {
        if (item instanceof DataSource) {
            return LayoutItemType.DataSource;
        }
        if (item instanceof UnionSubQuery) {
            return LayoutItemType.UnionSubQuery;
        }
        return LayoutItemType.SubQuery;
    }

    private static void collectLayoutChildren(ControlOwner item, ArrayList list) {
        for (int i = 0; i < item.getChildrenCount(); ++i) {
            ControlOwner childItem = item.children.get(i);
            if (childItem instanceof DataSource || childItem instanceof UnionSubQuery || childItem instanceof SubQuery) {
                list.add(childItem);
                continue;
            }
            QueryLayout.collectLayoutChildren(childItem, list);
        }
    }

    private static int compareLayout(ControlOwner item, LayoutItem layoutItem) {
        String name;
        LayoutItemType itemType = QueryLayout.getItemType(item);
        if (layoutItem.getItemType() != itemType) {
            return -1000;
        }
        int result = 0;
        if (layoutItem.getItemType() == LayoutItemType.DataSource && (name = ((DataSource)item).getNameInQuery()).compareToIgnoreCase(layoutItem.Name) != 0) {
            result = -1;
        }
        result -= layoutItem.getItems().size();
        ArrayList children = new ArrayList();
        QueryLayout.collectLayoutChildren(item, children);
        if (children.size() != 0) {
            PackableArray childrenLayout = QueryLayout.calcLayoutOrder(children, layoutItem.getItems());
            childrenLayout.pack();
            result += children.size();
        }
        return result;
    }

    private static PackableArray calcLayoutOrder(ArrayList items, ArrayList layoutItemsList) {
        int i;
        PackableArray result = new PackableArray();
        result.setSize(items.size());
        PackableArray layoutItems = new PackableArray((Collection)layoutItemsList);
        for (i = 0; i < items.size(); ++i) {
            if (i >= layoutItems.size() || QueryLayout.compareLayout((ControlOwner)items.get(i), (LayoutItem)layoutItems.get(i)) != 0) continue;
            result.set(i, layoutItems.get(i));
            layoutItems.set(i, null);
        }
        layoutItems.pack();
        if (layoutItems.size() > 0) {
            for (i = 0; i < result.size(); ++i) {
                if (result.get(i) != null) continue;
                for (int j = 0; j < layoutItems.size(); ++j) {
                    if (layoutItems.get(j) == null || QueryLayout.compareLayout((ControlOwner)items.get(i), (LayoutItem)layoutItems.get(j)) != 0) continue;
                    result.set(i, layoutItems.get(j));
                    layoutItems.set(j, null);
                }
            }
        }
        layoutItems.pack();
        if (layoutItems.size() > 0) {
            for (i = 0; i < result.size(); ++i) {
                if (result.get(i) != null) continue;
                int bestIndex = 0;
                int bestScore = QueryLayout.compareLayout((ControlOwner)items.get(i), (LayoutItem)layoutItems.get(0));
                for (int j = 1; j < layoutItems.size(); ++j) {
                    int score = QueryLayout.compareLayout((ControlOwner)items.get(i), (LayoutItem)layoutItems.get(j));
                    if (score <= bestScore) continue;
                    bestScore = score;
                    bestIndex = j;
                }
                if (bestScore <= -1000) continue;
                result.set(i, layoutItems.get(bestIndex));
                layoutItems.set(bestIndex, null);
                layoutItems.pack();
                if (layoutItems.size() == 0) break;
            }
        }
        return result;
    }

    public static LayoutItem getLayout(ControlOwner item) {
        LayoutItemType itemType = QueryLayout.getItemType(item);
        LayoutItem result = new LayoutItem(itemType);
        if (result.getItemType() == LayoutItemType.DataSource) {
            DataSource datasource = (DataSource)item;
            result.Left = datasource.getLeft();
            result.Top = datasource.getTop();
            result.Width = datasource.getWidth();
            result.Height = datasource.getHeight();
            result.Name = datasource.getNameInQuery();
        }
        ArrayList childItems = new ArrayList();
        QueryLayout.collectLayoutChildren(item, childItems);
        for (Object childItem : childItems) {
            LayoutItem childLayoutItem = QueryLayout.getLayout((ControlOwner)childItem);
            if (childLayoutItem == null) continue;
            result.getItems().add(childLayoutItem);
        }
        return result;
    }

    public static void setLayout(ControlOwner item, LayoutItem layout) {
        if (item instanceof DataSource && layout.getItemType() == LayoutItemType.DataSource) {
            DataSource datasource = (DataSource)item;
            datasource.setBounds(new Rectangle(layout.Left, layout.Top, layout.Width, layout.Height));
        }
        ArrayList children = new ArrayList();
        QueryLayout.collectLayoutChildren(item, children);
        PackableArray childrenLayout = QueryLayout.calcLayoutOrder(children, layout.getItems());
        for (int i = 0; i < children.size(); ++i) {
            if (childrenLayout.get(i) == null) continue;
            QueryLayout.setLayout((ControlOwner)children.get(i), (LayoutItem)childrenLayout.get(i));
        }
    }

    static class PackableArray
    extends ArrayList {
        public PackableArray(int initialCapacity) {
            super(initialCapacity);
        }

        public PackableArray() {
        }

        public PackableArray(Collection c) {
            super(c);
        }

        public void pack() {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) != null) continue;
                this.remove(i);
            }
        }

        public void setSize(int newSize) {
            for (int i = super.size(); i < newSize; ++i) {
                this.add(null);
            }
            if (super.size() > newSize) {
                this.removeRange(newSize, super.size() - newSize);
            }
        }
    }
}

