/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstNodeBase;
import com.adbs.ast.AstTraversable;
import com.adbs.ast.SQLExpressionParameter;
import com.adbs.querybuilder.Parameter;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParameterList
implements AstTraversable {
    private QueryBuilder queryBuilder;
    private boolean parametersValid = true;
    private final ArrayList<Parameter> items = new ArrayList();
    private ArrayList astParamList = new ArrayList();

    public ParameterList(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public int getCount() {
        if (!this.parametersValid) {
            try {
                this.queryBuilder.generateResultQueryAST();
            }
            catch (QueryBuilderException ex) {
                Logger.getLogger(ParameterList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.items.size();
    }

    public Parameter get(int index) throws QueryBuilderException {
        if (!this.parametersValid) {
            this.queryBuilder.generateResultQueryAST();
        }
        return this.items.get(index);
    }

    public boolean isParametersValid() {
        return this.parametersValid;
    }

    @Override
    public void addNodeToListIfParameter(AstNodeBase ast) {
        if (ast != null && ast instanceof SQLExpressionParameter) {
            this.astParamList.add(ast);
        }
    }

    public void reloadParameterListFromAST(AstNode ast) {
        this.items.clear();
        if (ast != null) {
            this.astParamList.clear();
            ast.traverseASTTreeDepthFirst(this);
            for (int i = 0; i < this.astParamList.size(); ++i) {
                this.items.add(new Parameter((SQLExpressionParameter)this.astParamList.get(i)));
            }
        }
        this.setParametersValid();
    }

    protected void setParametersInvalidInternal() {
        this.items.clear();
    }

    public void setParametersInvalid() {
        this.parametersValid = false;
        this.setParametersInvalidInternal();
    }

    public void setParametersValid() {
        this.parametersValid = true;
    }
}

