/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataProcedure;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.MetadataView;
import com.adbs.querybuilder.BasePropertyPanel;
import com.adbs.querybuilder.MetadataContainerLoadDialog;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.utils.Helpers;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

class OfflineModePage
extends BasePropertyPanel {
    private static final long serialVersionUID = 1L;
    private QueryBuilder queryBuilder = null;
    private MetadataContainer metadataContainer = null;
    private BaseSyntaxProvider syntaxProvider = null;
    private JButton bEditMetadata;
    private JButton bLoadFromXML;
    private JButton bLoadMetadata;
    private JButton bSaveToXML;
    private JCheckBox cbOfflineMode;
    private JLabel lMetadataObjectCount;
    private JScrollPane spNote;
    private JTextArea taNote;

    public OfflineModePage(QueryBuilder queryBuilder, MetadataContainer metadataContainer, BaseSyntaxProvider syntaxProvider) {
        this.queryBuilder = queryBuilder;
        this.metadataContainer = metadataContainer;
        this.syntaxProvider = syntaxProvider;
        this.initComponents();
        Helpers.localizer.localizePanel(this);
        this.cbOfflineMode.setEnabled(true);
        this.cbOfflineMode.setSelected(queryBuilder.isOfflineMode());
        this.spNote.setVisible(false);
        this.updateMode();
        this.cbOfflineMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OfflineModePage.this.cbOfflineModeActionPerformed(evt);
            }
        });
    }

    @Override
    public void applyChanges() {
        if (this.isModified()) {
            if (this.cbOfflineMode.isSelected()) {
                if (this.queryBuilder.getMetadataProvider() != null) {
                    this.queryBuilder.getMetadataProvider().disconnect();
                }
                this.queryBuilder.getMetadataContainer().assign(this.metadataContainer);
            } else {
                this.queryBuilder.getMetadataContainer().clear();
            }
            this.queryBuilder.setOfflineMode(this.cbOfflineMode.isSelected());
        }
    }

    private void cbOfflineModeActionPerformed(ActionEvent evt) {
        this.setModified(true);
        this.updateMode();
    }

    private void initComponents() {
        this.bEditMetadata = new JButton();
        this.bSaveToXML = new JButton();
        this.bLoadFromXML = new JButton();
        this.lMetadataObjectCount = new JLabel();
        this.bLoadMetadata = new JButton();
        this.cbOfflineMode = new JCheckBox();
        this.spNote = new JScrollPane();
        this.taNote = new JTextArea();
        this.setBackground(new Color(255, 255, 255));
        this.setFont(new Font("Dialog", 0, 11));
        this.setName("OfflineModePage");
        this.bEditMetadata.setFont(this.bEditMetadata.getFont());
        this.bEditMetadata.setText("Edit Metadata Container...");
        this.bEditMetadata.setName("bEditMetadata");
        this.bEditMetadata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OfflineModePage.this.bEditMetadataActionPerformed(evt);
            }
        });
        this.bSaveToXML.setFont(this.bSaveToXML.getFont());
        this.bSaveToXML.setText("Save to XML...");
        this.bSaveToXML.setName("bSaveToXML");
        this.bSaveToXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OfflineModePage.this.bSaveToXMLActionPerformed(evt);
            }
        });
        this.bLoadFromXML.setFont(this.bLoadFromXML.getFont());
        this.bLoadFromXML.setText("Load from XML...");
        this.bLoadFromXML.setName("bLoadFromXML");
        this.bLoadFromXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OfflineModePage.this.bLoadFromXMLActionPerformed(evt);
            }
        });
        this.lMetadataObjectCount.setBackground(null);
        this.lMetadataObjectCount.setFont(this.lMetadataObjectCount.getFont());
        this.lMetadataObjectCount.setText("Loaded Metadata: %1$d tables, %2$d views, %3$d procedures.");
        this.bLoadMetadata.setFont(this.bLoadMetadata.getFont());
        this.bLoadMetadata.setText("Load metadata to work in Offline mode...");
        this.bLoadMetadata.setEnabled(false);
        this.bLoadMetadata.setName("bLoadMetadata");
        this.bLoadMetadata.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OfflineModePage.this.bLoadMetadataActionPerformed(evt);
            }
        });
        this.cbOfflineMode.setBackground(null);
        this.cbOfflineMode.setFont(this.cbOfflineMode.getFont());
        this.cbOfflineMode.setText("Enable Offline Mode");
        this.cbOfflineMode.setEnabled(false);
        this.cbOfflineMode.setName("cbOfflineMode");
        this.spNote.setFont(this.spNote.getFont());
        this.taNote.setBackground(SystemColor.info);
        this.taNote.setColumns(20);
        this.taNote.setEditable(false);
        this.taNote.setFont(new Font("Dialog", 0, 11));
        this.taNote.setLineWrap(true);
        this.taNote.setRows(3);
        this.taNote.setText("Note that the Free Edition has following limitations: only the Universal SQL dialect parser is available and the offline mode is disabled.");
        this.taNote.setWrapStyleWord(true);
        this.taNote.setMargin(new Insets(2, 5, 2, 2));
        this.spNote.setViewportView(this.taNote);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lMetadataObjectCount, -1, 380, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.cbOfflineMode, -1, -1, Short.MAX_VALUE).addGap(259, 259, 259)).addGroup(layout.createSequentialGroup().addComponent(this.bLoadMetadata, -1, 292, Short.MAX_VALUE).addGap(88, 88, 88)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.spNote, GroupLayout.Alignment.LEADING, -1, 292, Short.MAX_VALUE).addComponent(this.bEditMetadata, GroupLayout.Alignment.LEADING, -1, 292, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.bLoadFromXML, -1, 137, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.bSaveToXML, -1, 137, Short.MAX_VALUE))).addGap(88, 88, 88))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.cbOfflineMode).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bLoadMetadata).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lMetadataObjectCount).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bLoadFromXML).addComponent(this.bSaveToXML)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bEditMetadata).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spNote).addGap(88, 88, 88)));
    }

    private void bLoadMetadataActionPerformed(ActionEvent evt) {
        this.metadataContainer.beginUpdate();
        try {
            MetadataContainerLoadDialog f = new MetadataContainerLoadDialog(SwingUtilities.getWindowAncestor(this), this.metadataContainer, false);
            if (f.showDialog()) {
                this.setModified(true);
                this.cbOfflineMode.setSelected(true);
            }
            f.dispose();
        }
        finally {
            this.metadataContainer.endUpdate();
        }
    }

    private void bLoadFromXMLActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(0);
        fileChooser.setDialogTitle("Select XML file to load metadata from");
        fileChooser.setFileFilter(new FileNameExtensionFilter("XML files", "xml"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog(this) == 0) {
            try {
                this.metadataContainer.loadFromXMLFile(fileChooser.getSelectedFile().getPath());
            }
            catch (QueryBuilderException ex) {
                JOptionPane.showMessageDialog(this, "Failed to load metadata from XML file.\r\n" + ex.getMessage());
            }
            this.setModified(true);
            this.updateMetadataStats();
        }
    }

    private void bSaveToXMLActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogType(1);
        fileChooser.setDialogTitle("Select XML file to save metadata to");
        fileChooser.setFileFilter(new FileNameExtensionFilter("XML files", "xml"));
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog(this) == 0) {
            String path = fileChooser.getSelectedFile().getPath();
            if (Helpers.getFileExtension(fileChooser.getSelectedFile().getName()) == null) {
                path = path + ".xml";
            }
            this.metadataContainer.saveToXMLFile(path);
            this.setModified(true);
            this.updateMetadataStats();
        }
    }

    private void bEditMetadataActionPerformed(ActionEvent evt) {
        if (QueryBuilder.editMetadataContainer(SwingUtilities.getWindowAncestor(this), this.metadataContainer, false, null)) {
            this.setModified(true);
        }
    }

    private void updateMode() {
        Font f = this.lMetadataObjectCount.getFont().deriveFont(this.cbOfflineMode.isSelected() ? 1 : 0);
        this.lMetadataObjectCount.setFont(f);
        this.bLoadFromXML.setEnabled(this.cbOfflineMode.isSelected());
        this.bSaveToXML.setEnabled(this.cbOfflineMode.isSelected());
        this.bEditMetadata.setEnabled(this.cbOfflineMode.isSelected());
        this.updateMetadataStats();
    }

    private void updateMetadataStats() {
        int t = 0;
        int v = 0;
        int p = 0;
        for (int i = 0; i < this.metadataContainer.getCount(); ++i) {
            MetadataObject mo = this.metadataContainer.get(i);
            if (mo instanceof MetadataTable) {
                ++t;
                continue;
            }
            if (mo instanceof MetadataView) {
                ++v;
                continue;
            }
            if (!(mo instanceof MetadataProcedure)) continue;
            ++p;
        }
        String strMetadataObjectCount = Helpers.localizer.getString("strMetadataObjectCount", "Loaded Metadata: %1$d tables, %2$d views, %3$d procedures.");
        this.lMetadataObjectCount.setText(String.format(strMetadataObjectCount, t, v, p));
    }
}

