/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkCardinality;
import com.adbs.querybuilder.LinkConnectToSide;
import com.adbs.querybuilder.LinkPainter;
import com.adbs.querybuilder.LinkPainterFriendlyName;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.utils.Helpers;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.SystemColor;
import javax.swing.Icon;

@LinkPainterFriendlyName(value="MS SQL Style")
public class LinkPainterMSSQL
extends LinkPainter {
    private Color linkColor = Color.BLACK;
    private Color linkColorFocused = SystemColor.controlShadow;
    private Color linkBorderColor = Color.BLACK;

    public LinkPainterMSSQL(QueryBuilder queryBuilder) {
        super(queryBuilder);
    }

    public Color getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(Color value) {
        if (this.linkColor != value) {
            this.linkColor = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    public Color getLinkColorFocused() {
        return this.linkColorFocused;
    }

    public void setLinkColorFocused(Color value) {
        if (this.linkColorFocused != value) {
            this.linkColorFocused = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    public Color getLinkBorderColor() {
        return this.linkBorderColor;
    }

    public void setLinkBorderColor(Color value) {
        if (this.linkBorderColor != value) {
            this.linkBorderColor = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    protected void paintCardinalitySymbol(Graphics g, int x, int y, LinkCardinality cardinality) {
        Icon img;
        switch (cardinality) {
            case One: {
                img = Helpers.accessLinkCardinality1;
                break;
            }
            case Many: {
                img = Helpers.accessLinkCardinalityMany;
                break;
            }
            default: {
                img = null;
            }
        }
        if (img != null) {
            img.paintIcon(null, g, x - img.getIconWidth() / 2, y - img.getIconHeight() - 4);
        }
    }

    @Override
    public void paintLink(Graphics g, int[] xPoints, int[] yPoints, boolean focused, LinkConnectToSide firstSide, LinkConnectToSide secondSide, Link link) {
        if (!focused) {
            this.drawLine(g, xPoints, yPoints, this.getLinkColor(), 0, 1);
        } else {
            this.drawLine(g, xPoints, yPoints, this.getLinkColor(), 0, 2);
        }
        Stroke oldStroke = ((Graphics2D)g).getStroke();
        g.setColor(this.getLinkColor());
        ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
        g.drawLine(xPoints[0], yPoints[0], xPoints[1], yPoints[1]);
        g.drawLine(xPoints[3], yPoints[3], xPoints[2], yPoints[2]);
        if (link.getLeftCardinality() != LinkCardinality.Unknown) {
            this.paintCardinalitySymbol(g, (xPoints[0] + xPoints[1]) / 2, yPoints[0], link.getLeftCardinality());
        }
        if (link.getRightCardinality() != LinkCardinality.Unknown) {
            this.paintCardinalitySymbol(g, (xPoints[3] + xPoints[2]) / 2, yPoints[3], link.getRightCardinality());
        }
        Color fillColor = focused ? this.getMarkColorFocused() : this.getMarkColor();
        BasicStroke stroke = new BasicStroke(1.0f);
        Point p = new Point((xPoints[1] + xPoints[2]) / 2, (yPoints[1] + yPoints[2]) / 2);
        int factor = xPoints[0] > xPoints[3] ? -1 : 1;
        if (link.getLeftType() == LinkSideType.Outer) {
            this.drawLeftSideMark(link, g, this.getLinkBorderColor(), stroke, fillColor, p, 7, factor);
        }
        if (link.getRightType() == LinkSideType.Outer) {
            this.drawRightSideMark(link, g, this.getLinkBorderColor(), stroke, fillColor, p, 7, factor);
        }
        this.drawCenterMark(link, g, this.getLinkBorderColor(), stroke, fillColor, p, 7);
        ((Graphics2D)g).setStroke(oldStroke);
    }
}

