/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkConnectToSide;
import com.adbs.querybuilder.LinkPainterFriendlyName;
import com.adbs.querybuilder.QueryBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.lang.annotation.Annotation;
import java.util.Arrays;

public abstract class LinkPainter {
    protected QueryBuilder queryBuilder;
    private Color markColor;
    private Color markColorFocused;

    public LinkPainter(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        this.markColor = SystemColor.control;
        this.markColorFocused = SystemColor.controlDkShadow;
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public Color getMarkColor() {
        return this.markColor;
    }

    public void setMarkColor(Color value) {
        if (this.markColor != value) {
            this.markColor = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    public Color getMarkColorFocused() {
        return this.markColorFocused;
    }

    public void setMarkColorFocused(Color value) {
        if (this.markColorFocused != value) {
            this.markColorFocused = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.doUpdateControlParams();
            }
        }
    }

    protected void drawLine(Graphics g, int[] xPoints, int[] yPoints, Color color, int dy, int width) {
        Graphics2D g2 = (Graphics2D)g;
        int[] yPoints2 = Arrays.copyOf(yPoints, yPoints.length);
        Stroke oldStroke = g2.getStroke();
        if (dy != 0) {
            int i = 0;
            while (i < yPoints2.length) {
                int n = i++;
                yPoints2[n] = yPoints2[n] + dy;
            }
        }
        g2.setColor(color);
        g2.setStroke(new BasicStroke(width));
        g2.drawPolyline(xPoints, yPoints2, xPoints.length);
        g2.setStroke(oldStroke);
    }

    protected void drawLeftSideMark(Link link, Graphics g, Color color, BasicStroke stroke, Paint paint, Point center, int amSize, int amFactor) {
        Graphics2D g2 = (Graphics2D)g;
        int[] xx = new int[4];
        int[] yy = new int[4];
        xx[0] = center.x;
        yy[0] = center.y - amSize;
        xx[1] = center.x - amSize * amFactor;
        yy[1] = center.y - amSize;
        xx[2] = center.x - amSize * amFactor;
        yy[2] = center.y + amSize;
        xx[3] = center.x;
        yy[3] = center.y + amSize;
        if (paint != null) {
            g2.setPaint(paint);
            g2.fillPolygon(xx, yy, 4);
        }
        g2.setColor(color);
        g2.setStroke(stroke);
        g2.drawPolygon(xx, yy, 4);
    }

    protected void drawRightSideMark(Link link, Graphics g, Color color, BasicStroke stroke, Paint paint, Point center, int amSize, int amFactor) {
        Graphics2D g2 = (Graphics2D)g;
        int[] xx = new int[4];
        int[] yy = new int[4];
        xx[0] = center.x;
        yy[0] = center.y - amSize;
        xx[1] = center.x + amSize * amFactor;
        yy[1] = center.y - amSize;
        xx[2] = center.x + amSize * amFactor;
        yy[2] = center.y + amSize;
        xx[3] = center.x;
        yy[3] = center.y + amSize;
        if (paint != null) {
            g2.setPaint(paint);
            g2.fillPolygon(xx, yy, 4);
        }
        g2.setColor(color);
        g2.setStroke(stroke);
        g2.drawPolygon(xx, yy, 4);
    }

    protected void drawCenterMark(Link link, Graphics g, Color color, BasicStroke stroke, Paint paint, Point center, int amSize) {
        Graphics2D g2 = (Graphics2D)g;
        int[] xx = new int[4];
        int[] yy = new int[4];
        xx[0] = center.x;
        yy[0] = center.y - amSize;
        xx[1] = center.x + amSize;
        yy[1] = center.y;
        xx[2] = center.x;
        yy[2] = center.y + amSize;
        xx[3] = center.x - amSize;
        yy[3] = center.y;
        if (paint != null) {
            g2.setPaint(paint);
            g2.fillPolygon(xx, yy, 4);
        }
        g2.setColor(color);
        g2.setStroke(stroke);
        g2.drawPolygon(xx, yy, 4);
    }

    public abstract void paintLink(Graphics var1, int[] var2, int[] var3, boolean var4, LinkConnectToSide var5, LinkConnectToSide var6, Link var7);

    public String getFriendlyName() {
        Annotation[] annotations;
        for (Annotation annotation : annotations = this.getClass().getAnnotations()) {
            if (!(annotation instanceof LinkPainterFriendlyName)) continue;
            return ((LinkPainterFriendlyName)annotation).value();
        }
        return "Unnamed Link Painter";
    }
}

