/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataRelation;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.SQLExpressionItem;
import com.adbs.ast.SQLExpressionOperatorBinary;
import com.adbs.ast.SQLFromSource;
import com.adbs.ast.SQLJoinKind;
import com.adbs.ast.SQLJoinKindFull;
import com.adbs.ast.SQLJoinKindInner;
import com.adbs.ast.SQLJoinKindLeft;
import com.adbs.ast.SQLJoinKindRight;
import com.adbs.ast.SQLObjectColumn;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.ControlOwner;
import com.adbs.querybuilder.DataSource;
import com.adbs.querybuilder.DataSourceBase;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.LinkCardinality;
import com.adbs.querybuilder.LinkControl;
import com.adbs.querybuilder.LinkDeletingEvent;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class Link
extends ControlOwner
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private DatasourceGroup datasourceGroup;
    protected DataSourceBase datasourceOwner = null;
    private SQLExpressionItem astLinkExpression = null;
    final ArrayList referencedDatasources = new ArrayList();
    final ArrayList datasources = new ArrayList();
    protected DataSource leftDatasource;
    LinkSideType leftType;
    private SQLQualifiedName leftField;
    private LinkCardinality leftCardinality = LinkCardinality.Unknown;
    protected DataSource rightDatasource;
    LinkSideType rightType;
    private SQLQualifiedName rightField;
    private LinkCardinality rightCardinality = LinkCardinality.Unknown;
    private LinkPlace place;
    private boolean simple;
    boolean newFlag = false;

    public Link(DatasourceGroup owner, QueryBuilder queryBuilder) {
        super(owner.getQuery().getFromClause(), owner, queryBuilder);
        try {
            if (owner instanceof DatasourceGroup) {
                this.setDatasourceGroup(owner);
            } else {
                this.setDatasourceGroup(null);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Link.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void dispose() {
        try {
            this.setDatasourceGroup(null);
        }
        catch (QueryBuilderException ex) {
            Logger.getLogger(Link.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (this.astLinkExpression != null) {
            this.astLinkExpression.dispose();
            this.astLinkExpression = null;
        }
        if (this.leftField != null) {
            this.leftField.dispose();
            this.leftField = null;
        }
        if (this.rightField != null) {
            this.rightField.dispose();
            this.rightField = null;
        }
        super.dispose();
    }

    public DatasourceGroup getDatasourceGroup() {
        return this.datasourceGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDatasourceGroup(DatasourceGroup value) throws QueryBuilderException {
        if (this.datasourceGroup != value) {
            DatasourceGroup oldGroup = this.datasourceGroup;
            DatasourceGroup newGroup = value;
            if (oldGroup != null) {
                oldGroup.beginUpdate();
            }
            try {
                if (newGroup != null) {
                    newGroup.beginUpdate();
                }
                try {
                    if (this.datasourceGroup != null) {
                        this.datasourceGroup.unregisterLink(this);
                        if (!this.isDisposing()) {
                            this.datasourceGroup.notifyReorderNeeded();
                        }
                    }
                    this.datasourceGroup = value;
                    if (this.datasourceGroup != null) {
                        this.datasourceGroup.registerLink(this);
                        if (!this.isDisposing()) {
                            this.datasourceGroup.notifyReorderNeeded();
                        }
                    }
                    this.setUpdateParent(value);
                }
                finally {
                    if (newGroup != null) {
                        newGroup.endUpdate();
                    }
                }
            }
            finally {
                if (oldGroup != null) {
                    oldGroup.endUpdate();
                }
            }
        }
    }

    public DataSourceBase getDatasourceOwner() {
        return this.datasourceOwner;
    }

    protected LinkControl getLinkControl() {
        if (this.controls.size() >= 1) {
            return (LinkControl)this.controls.get(0);
        }
        return null;
    }

    public boolean isSimple() {
        return this.simple;
    }

    public LinkPlace getPlace() {
        return this.place;
    }

    public DataSource getLeftDatasource() {
        return this.leftDatasource;
    }

    public LinkSideType getLeftType() {
        return this.leftType;
    }

    public SQLQualifiedName getLeftField() {
        return this.leftField;
    }

    public LinkCardinality getLeftCardinality() {
        return this.leftCardinality;
    }

    public DataSource getRightDatasource() {
        return this.rightDatasource;
    }

    public LinkSideType getRightType() {
        return this.rightType;
    }

    public SQLQualifiedName getRightField() {
        return this.rightField;
    }

    public LinkCardinality getRightCardinality() {
        return this.rightCardinality;
    }

    public SQLExpressionItem getLinkExpression() {
        return this.astLinkExpression;
    }

    public void setLinkExpression(SQLExpressionItem value) {
        if (value != this.getLinkExpression()) {
            this.setLinkParamsInternal(this.datasourceOwner, value, this.place, false);
            if (this.isControlsCreated()) {
                this.getLinkControl().reAlign();
            }
        }
    }

    public String getLinkExpressionString() {
        return this.astLinkExpression.getSimpleSQL(this.sqlContext.getSQLBuilderExpression());
    }

    public void setLinkExpressionString(String value) {
        SQLExpressionItem newExpr = this.sqlContext.parseLogicalExpression(value, true);
        ArrayList lCTE = new ArrayList();
        ArrayList lFromObj = new ArrayList();
        this.gatherPrepareAndFixupContext(lCTE, lFromObj, true);
        newExpr.prepareAndFixupRecursive(lCTE, lFromObj);
        this.setLinkExpression(newExpr);
    }

    @Override
    public int getControlsCount() {
        return 1;
    }

    @Override
    protected Component createControlInternal(int i) {
        if (i == 0) {
            LinkControl c = new LinkControl(this);
            c.setDiagramPane(this.datasourceGroup.getQuery().getDiagramPane());
            c.getDiagramPane().add(c);
            this.controls.set(i, c);
            c.getDiagramPane().setComponentZOrder(c, 0);
            return c;
        }
        return null;
    }

    @Override
    protected void updateContolParams(int i) {
        super.updateContolParams(i);
        if (this.isControlsCreated()) {
            this.getLinkControl().invalidate();
        }
    }

    @Override
    protected void getASTChildren(List l) {
        super.getASTChildren(l);
        if (this.astLinkExpression != null) {
            l.add(this.astLinkExpression);
        }
    }

    protected void loadDataSourceList(DataSourceBase dataSourceOwner) {
        if (this.astLinkExpression != null) {
            int i;
            this.referencedDatasources.clear();
            this.astLinkExpression.getReferencedDatasourcesRecursive(this.referencedDatasources);
            for (i = this.referencedDatasources.size() - 1; i >= 0; --i) {
                if (((SQLFromSource)this.referencedDatasources.get((int)i)).data != null) continue;
                this.referencedDatasources.remove(i);
            }
            for (i = 0; i < this.referencedDatasources.size(); ++i) {
                Object o = this.referencedDatasources.get(i);
                assert (o instanceof SQLFromSource);
                SQLFromSource fs = (SQLFromSource)o;
                DataSource ds = (DataSource)fs.data;
                this.referencedDatasources.set(i, ds);
            }
            this.recalcSameLevelDatasources(dataSourceOwner);
        }
    }

    protected void resetCardinality() {
        this.leftCardinality = LinkCardinality.Unknown;
        this.rightCardinality = LinkCardinality.Unknown;
    }

    public void calcCardinality() {
        LinkCardinality[] metadataCardinalityToQBCardinality = LinkCardinality.values();
        MetadataRelation r = this.getMetadataRelation();
        if (r != null) {
            MetadataObject leftObject = this.leftDatasource.getMetadataObject();
            if (r.getRelations().getParent() == leftObject) {
                if (!r.isInverted()) {
                    this.leftCardinality = metadataCardinalityToQBCardinality[r.getKeyCardinality().ordinal()];
                    this.rightCardinality = metadataCardinalityToQBCardinality[r.getChildCardinality().ordinal()];
                } else {
                    this.leftCardinality = metadataCardinalityToQBCardinality[r.getChildCardinality().ordinal()];
                    this.rightCardinality = metadataCardinalityToQBCardinality[r.getKeyCardinality().ordinal()];
                }
            } else if (!r.isInverted()) {
                this.leftCardinality = metadataCardinalityToQBCardinality[r.getChildCardinality().ordinal()];
                this.rightCardinality = metadataCardinalityToQBCardinality[r.getKeyCardinality().ordinal()];
            } else {
                this.leftCardinality = metadataCardinalityToQBCardinality[r.getKeyCardinality().ordinal()];
                this.rightCardinality = metadataCardinalityToQBCardinality[r.getChildCardinality().ordinal()];
            }
        }
    }

    protected void calcDatasourcesReferencedByLink(ArrayList l) {
        Helpers.listAssign(l, this.referencedDatasources, Helpers.ListAssignOp.Copy, null);
    }

    protected void recalcSameLevelDatasources(DataSourceBase datasourceOwner) {
        if (this.astLinkExpression != null) {
            DataSourceBase ds;
            ArrayList dsl = new ArrayList();
            this.calcDatasourcesReferencedByLink(dsl);
            this.datasources.clear();
            if (datasourceOwner != null) {
                this.datasources.add(datasourceOwner);
                dsl.remove(datasourceOwner);
            }
            for (int i = dsl.size() - 1; i >= 0; --i) {
                ds = (DataSource)dsl.get(i);
                if (this.datasourceGroup.indexOf(ds) == -1) continue;
                if (this.datasources.indexOf(ds) == -1) {
                    this.datasources.add(ds);
                }
                dsl.remove(i);
            }
            if (dsl.size() > 0) {
                for (int j = 0; j < this.datasourceGroup.getCount(); ++j) {
                    ds = this.datasourceGroup.get(j);
                    if (ds instanceof DatasourceGroup) {
                        for (int i = dsl.size() - 1; i >= 0; --i) {
                            if (!((DatasourceGroup)ds).containsDatasource((DataSourceBase)dsl.get(i), true)) continue;
                            if (this.datasources.indexOf(ds) == -1) {
                                this.datasources.add(ds);
                            }
                            dsl.remove(i);
                            break;
                        }
                    }
                    if (dsl.size() == 0) break;
                }
            }
        }
        if (this.simple) assert (this.datasources.size() == 2);
    }

    protected static void getReferencedColumns(SQLExpressionItem expression, List columnList) {
        columnList.clear();
        if (expression != null) {
            expression.getReferencedColumnsRecursive(columnList);
            if (columnList.size() > 1) {
                int i;
                TreeMap<String, SQLObjectColumn> sl = new TreeMap<String, SQLObjectColumn>();
                for (i = 0; i < columnList.size(); ++i) {
                    SQLObjectColumn c = (SQLObjectColumn)columnList.get(i);
                    String s = c.getSimpleSQL(expression.getSQLContext().getSQLBuilderExpressionQuoted());
                    if (sl.containsKey(s)) continue;
                    sl.put(s, c);
                }
                for (i = columnList.size() - 1; i >= 0; --i) {
                    if (sl.containsValue(columnList.get(i))) continue;
                    columnList.remove(i);
                }
            }
        }
    }

    public static boolean canLoadExpressionAsSimpleLink(DataSourceBase datasourceOwner, SQLExpressionItem expression) {
        boolean result = false;
        if (expression != null) {
            ArrayList l = new ArrayList();
            Link.getReferencedColumns(expression, l);
            if (l.size() == 2) {
                SQLObjectColumn c1 = (SQLObjectColumn)l.get(0);
                SQLObjectColumn c2 = (SQLObjectColumn)l.get(1);
                if (c1.datasource != null && c2.datasource != null && c1.datasource.data != null && c2.datasource.data != null && c1.datasource.data != c2.datasource.data) {
                    DataSource d1 = (DataSource)c1.datasource.data;
                    DataSource d2 = (DataSource)c2.datasource.data;
                    DatasourceGroup g = datasourceOwner.getGroup();
                    result = g.containsDatasourceBefore(d1, datasourceOwner) && datasourceOwner.containsDatasource(d2, true) || g.containsDatasourceBefore(d2, datasourceOwner) && datasourceOwner.containsDatasource(d1, true);
                }
            }
        }
        return result;
    }

    public static boolean canLoadExpressionAsSimpleWhereLink(DatasourceGroup fromClause, SQLExpressionItem expression) {
        SQLExpressionOperatorBinary eob;
        boolean result = false;
        if (expression != null && (eob = Helpers.expressionGetTompostBinaryOperator(expression)) != null) {
            ArrayList l = new ArrayList();
            Link.getReferencedColumns(eob, l);
            result = l.size() == 2 && ((SQLObjectColumn)l.get((int)0)).datasource != null && ((SQLObjectColumn)l.get((int)1)).datasource != null && ((SQLObjectColumn)l.get((int)0)).datasource.data != null && ((SQLObjectColumn)l.get((int)1)).datasource.data != null && ((SQLObjectColumn)l.get((int)0)).datasource != ((SQLObjectColumn)l.get((int)1)).datasource && ((DataSource)((SQLObjectColumn)l.get((int)0)).datasource.data).query == ((DataSource)((SQLObjectColumn)l.get((int)1)).datasource.data).query;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinkParamsInternal(DataSourceBase dataSourceOwner, SQLExpressionItem ast, LinkPlace place, boolean newFlag) {
        assert (dataSourceOwner != null) : "Link.SetLinkParamsInternal: bad param: dataSourceOwner is null";
        this.newFlag = newFlag;
        this.place = place;
        if (this.astLinkExpression != null) {
            this.astLinkExpression.dispose();
        }
        this.astLinkExpression = ast;
        this.simple = false;
        this.datasourceOwner = dataSourceOwner;
        this.loadDataSourceList(dataSourceOwner);
        if (this.datasources.size() == 1 || this.datasources.size() == 2) {
            ArrayList l = new ArrayList();
            try {
                Link.getReferencedColumns(this.astLinkExpression, l);
                if (l.size() == 2) {
                    SQLObjectColumn c1 = (SQLObjectColumn)l.get(0);
                    SQLObjectColumn c2 = (SQLObjectColumn)l.get(1);
                    if (c1.datasource != null && c2.datasource != null && c1.datasource.data != null && c2.datasource.data != null && c1.datasource.data != c2.datasource.data) {
                        DataSource d1 = (DataSource)c1.datasource.data;
                        DataSource d2 = (DataSource)c2.datasource.data;
                        if (this.datasourceGroup.containsDatasourceBefore(d2, dataSourceOwner) && dataSourceOwner.containsDatasource(d1, true)) {
                            DataSource d = d1;
                            d1 = d2;
                            d2 = d;
                            SQLObjectColumn c = c1;
                            c1 = c2;
                            c2 = c;
                        } else if (!this.datasourceGroup.containsDatasourceBefore(d1, dataSourceOwner) || !dataSourceOwner.containsDatasource(d2, true)) {
                            d1 = null;
                            d2 = null;
                        }
                        if (d1 != null && d2 != null) {
                            this.simple = true;
                            this.setLeftDatasource(d1);
                            if (this.leftField != null) {
                                this.leftField.dispose();
                            }
                            this.leftField = c1.clone(this.getSQLContext());
                            this.setRightDatasource(d2);
                            if (this.rightField != null) {
                                this.rightField.dispose();
                            }
                            this.rightField = c2.clone(this.getSQLContext());
                            if (place == LinkPlace.From) {
                                this.setOraclePlusForDatasource(this.leftDatasource, false);
                                this.setOraclePlusForDatasource(this.rightDatasource, false);
                                this.setWhereLinkTypeTransactSQL(LinkSideType.Inner, this.leftDatasource);
                                this.setWhereLinkTypeTransactSQL(LinkSideType.Inner, this.rightDatasource);
                            }
                        }
                    }
                } else {
                    this.simple = false;
                    this.setLeftDatasource(null);
                    if (this.leftField != null) {
                        this.leftField.dispose();
                        this.leftField = null;
                    }
                    this.setRightDatasource(null);
                    if (this.rightField != null) {
                        this.rightField.dispose();
                        this.rightField = null;
                    }
                }
            }
            finally {
                l.clear();
            }
        }
        this.calcLeftTypeInternal();
        this.calcRightTypeInternal();
        this.loadSubQueries(this.astLinkExpression);
        if (this.simple) {
            this.calcCardinality();
        } else {
            this.resetCardinality();
        }
        if (!this.simple) {
            this.recalcSideDatasources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calcLeftTypeInternal() {
        LinkSideType st;
        if (this.place == LinkPlace.From) {
            st = this.datasourceOwner.getFromSource().joinKind != null ? (this.datasourceOwner.getFromSource().joinKind.isLeftOuter() ? LinkSideType.Outer : LinkSideType.Inner) : LinkSideType.Inner;
        } else {
            st = LinkSideType.Inner;
            ArrayList l = new ArrayList();
            try {
                SQLExpressionOperatorBinary eob;
                this.astLinkExpression.getReferencedColumnsRecursive(l);
                for (int i = 0; i < l.size(); ++i) {
                    DataSourceBase ds;
                    SQLObjectColumn c = (SQLObjectColumn)l.get(i);
                    if (c.datasource == null || c.datasource.data == null || !this.datasourceOwner.containsDatasource(ds = (DataSourceBase)c.datasource.data, true) || !c.outerJoin) continue;
                    st = LinkSideType.Outer;
                    break;
                }
                if (st == LinkSideType.Inner && (eob = Helpers.expressionGetTompostBinaryOperator(this.astLinkExpression)) != null) {
                    l.clear();
                    if (eob.operatorObj != null && eob.operatorObj.operatorName.equals("*=") && eob.lExpression != null) {
                        eob.lExpression.getReferencedDatasourcesRecursive(l);
                        if (l.size() == 1 && l.get(0) == this.getLeftDatasource().getFromSource()) {
                            st = LinkSideType.Outer;
                        }
                    } else if (eob.operatorObj != null && eob.operatorObj.operatorName.equals("=*") && eob.rExpression != null) {
                        eob.rExpression.getReferencedDatasourcesRecursive(l);
                        if (l.size() == 1 && l.get(0) == this.getLeftDatasource().getFromSource()) {
                            st = LinkSideType.Outer;
                        }
                    }
                }
            }
            finally {
                l.clear();
            }
        }
        this.leftType = st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calcRightTypeInternal() {
        LinkSideType st;
        if (this.place == LinkPlace.From) {
            st = this.datasourceOwner.getFromSource().joinKind != null ? (this.datasourceOwner.getFromSource().joinKind.isRightOuter() ? LinkSideType.Outer : LinkSideType.Inner) : LinkSideType.Inner;
        } else {
            st = LinkSideType.Inner;
            ArrayList l = new ArrayList();
            try {
                SQLExpressionOperatorBinary eob;
                this.astLinkExpression.getReferencedColumnsRecursive(l);
                for (int i = 0; i < l.size(); ++i) {
                    DataSourceBase ds;
                    SQLObjectColumn c = (SQLObjectColumn)l.get(i);
                    if (c.datasource == null || c.datasource.data == null || this.datasourceOwner.containsDatasource(ds = (DataSourceBase)c.datasource.data, true) || !c.outerJoin) continue;
                    st = LinkSideType.Outer;
                    break;
                }
                if (st == LinkSideType.Inner && (eob = Helpers.expressionGetTompostBinaryOperator(this.astLinkExpression)) != null) {
                    l.clear();
                    if (eob.operatorObj != null && eob.operatorObj.operatorName.equals("*=") && eob.lExpression != null) {
                        eob.lExpression.getReferencedDatasourcesRecursive(l);
                        if (l.size() == 1 && l.get(0) == this.getRightDatasource().getFromSource()) {
                            st = LinkSideType.Outer;
                        }
                    } else if (eob.operatorObj != null && eob.operatorObj.operatorName.equals("=*") && eob.rExpression != null) {
                        eob.rExpression.getReferencedDatasourcesRecursive(l);
                        if (l.size() == 1 && l.get(0) == this.getRightDatasource().getFromSource()) {
                            st = LinkSideType.Outer;
                        }
                    }
                }
            }
            finally {
                l.clear();
            }
        }
        this.rightType = st;
    }

    protected void setWhereLinkTypeTransactSQL(LinkSideType linkType, DataSource datasource) {
        ArrayList l;
        SQLExpressionOperatorBinary eob = Helpers.expressionGetTompostBinaryOperator(this.astLinkExpression);
        if (eob != null && eob.lExpression != null) {
            l = new ArrayList();
            eob.lExpression.getReferencedDatasourcesRecursive(l);
            if (l.indexOf(datasource.getFromSource()) != -1) {
                if (linkType == LinkSideType.Inner) {
                    if (eob.operatorObj != null && eob.operatorObj.operatorName.length() > 0 && eob.operatorObj.operatorName.charAt(0) == '*') {
                        eob.operatorObj.operatorName = eob.operatorObj.operatorName.substring(1, eob.operatorObj.operatorName.length());
                    }
                } else if (eob.operatorObj != null && eob.operatorObj.operatorName.length() > 0 && eob.operatorObj.operatorName.charAt(0) != '*') {
                    eob.operatorObj.operatorName = '*' + eob.operatorObj.operatorName;
                }
            }
        }
        if (eob != null && eob.lExpression != null) {
            l = new ArrayList();
            eob.rExpression.getReferencedDatasourcesRecursive(l);
            if (l.indexOf(datasource.getFromSource()) != -1) {
                if (linkType == LinkSideType.Inner) {
                    if (eob.operatorObj != null && eob.operatorObj.operatorName.length() > 0 && eob.operatorObj.operatorName.charAt(eob.operatorObj.operatorName.length() - 1) == '*') {
                        eob.operatorObj.operatorName = eob.operatorObj.operatorName.substring(0, eob.operatorObj.operatorName.length() - 1);
                    }
                } else if (eob.operatorObj != null && eob.operatorObj.operatorName.length() > 0 && eob.operatorObj.operatorName.charAt(eob.operatorObj.operatorName.length() - 1) != '*') {
                    eob.operatorObj.operatorName = eob.operatorObj.operatorName + '*';
                }
            }
        }
    }

    protected void flipLink() {
        assert (this.simple);
        DataSource ds = this.rightDatasource;
        LinkSideType lt = this.rightType;
        LinkCardinality cr = this.rightCardinality;
        SQLQualifiedName fld = this.rightField;
        this.datasourceOwner = this.datasourceOwner == this.rightDatasource ? this.leftDatasource : this.rightDatasource;
        this.rightDatasource = this.leftDatasource;
        this.rightType = this.leftType;
        this.rightCardinality = this.leftCardinality;
        this.rightField = this.leftField;
        this.leftDatasource = ds;
        this.leftType = lt;
        this.leftCardinality = cr;
        this.leftField = fld;
        if (this.isControlsCreated()) {
            this.getLinkControl().reAlign();
        }
    }

    protected void moveDatasourceIntoGroup(DataSourceBase datasource, DatasourceGroup group) {
        int i = this.datasources.indexOf(datasource);
        if (i != -1) {
            if (this.datasources.indexOf(group) == -1) {
                this.datasources.set(i, group);
            } else {
                this.datasources.remove(i);
            }
        }
        if (this.datasourceOwner == datasource) {
            this.datasourceOwner = group;
        }
        if (this.simple) assert (this.datasources.size() == 2);
    }

    @Override
    protected boolean notifyDatasourceDestroyingInternal(DataSource datasource) {
        return this.referencedDatasources.indexOf(datasource) != -1 || !this.isSimple() && this.datasourceOwner == datasource || this.datasourceGroup.getCount() == 2 && this.datasourceGroup.indexOf(datasource) != -1;
    }

    @Override
    protected void notifyDatasourceReplacedInternal(DataSource datasourceFrom, DataSource datasourceTo) {
        int i = this.referencedDatasources.indexOf(datasourceFrom);
        if (i != -1) {
            this.referencedDatasources.set(i, datasourceTo);
        }
        if ((i = this.datasources.indexOf(datasourceFrom)) != -1) {
            this.datasources.set(i, datasourceTo);
        }
        this.astLinkExpression.replaceReferencesToDatasourceRecursive(datasourceFrom.getFromSource(), datasourceTo.getFromSource());
        if (this.leftDatasource == datasourceFrom) {
            this.leftDatasource = datasourceTo;
        }
        if (this.rightDatasource == datasourceFrom) {
            this.rightDatasource = datasourceTo;
        }
        if (this.datasourceOwner == datasourceFrom) {
            this.datasourceOwner = datasourceTo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJoinKindClass(Class joinKindClass) {
        SQLJoinKind jk = null;
        if (this.place == LinkPlace.Where) {
            if (this.simple) {
                try {
                    Constructor c = joinKindClass.getConstructor(BaseSQLContext.class);
                    jk = (SQLJoinKind)c.newInstance(this.getSQLContext());
                    try {
                        if (this.getSQLContext().getSyntaxProvider().isSupportOracleJoins()) {
                            if (jk.isLeftOuter() && this.leftTypeSupportOuter()) {
                                if (jk.isRightOuter() && this.rightTypeSupportOuter()) {
                                    this.leftType = LinkSideType.Outer;
                                    this.rightType = LinkSideType.Outer;
                                    this.setOraclePlusForDatasource(this.leftDatasource, true);
                                    this.setOraclePlusForDatasource(this.rightDatasource, true);
                                } else {
                                    this.leftType = LinkSideType.Outer;
                                    this.rightType = LinkSideType.Inner;
                                    this.setOraclePlusForDatasource(this.leftDatasource, false);
                                    this.setOraclePlusForDatasource(this.rightDatasource, true);
                                }
                            } else if (jk.isRightOuter() && this.rightTypeSupportOuter()) {
                                this.leftType = LinkSideType.Inner;
                                this.rightType = LinkSideType.Outer;
                                this.setOraclePlusForDatasource(this.leftDatasource, true);
                                this.setOraclePlusForDatasource(this.rightDatasource, false);
                            } else {
                                this.leftType = LinkSideType.Inner;
                                this.rightType = LinkSideType.Inner;
                                this.setOraclePlusForDatasource(this.leftDatasource, false);
                                this.setOraclePlusForDatasource(this.rightDatasource, false);
                            }
                        } else if (this.getSQLContext().getSyntaxProvider().isSupportTransactSQLJoins()) {
                            if (jk.isLeftOuter() && this.leftTypeSupportOuter()) {
                                this.leftType = LinkSideType.Outer;
                                this.setWhereLinkTypeTransactSQL(LinkSideType.Outer, this.leftDatasource);
                            } else {
                                this.leftType = LinkSideType.Inner;
                                this.setWhereLinkTypeTransactSQL(LinkSideType.Inner, this.leftDatasource);
                            }
                            if (jk.isRightOuter() && this.rightTypeSupportOuter()) {
                                this.rightType = LinkSideType.Outer;
                                this.setWhereLinkTypeTransactSQL(LinkSideType.Outer, this.rightDatasource);
                            } else {
                                this.rightType = LinkSideType.Inner;
                                this.setWhereLinkTypeTransactSQL(LinkSideType.Inner, this.rightDatasource);
                            }
                        } else {
                            this.leftType = LinkSideType.Inner;
                            this.rightType = LinkSideType.Inner;
                            this.setWhereLinkTypeTransactSQL(LinkSideType.Inner, this.leftDatasource);
                            this.setWhereLinkTypeTransactSQL(LinkSideType.Inner, this.rightDatasource);
                            this.setOraclePlusForDatasource(this.leftDatasource, false);
                            this.setOraclePlusForDatasource(this.rightDatasource, false);
                        }
                    }
                    finally {
                        jk.dispose();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(Link.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            this.datasourceOwner.setJoinKindClass(joinKindClass);
        }
    }

    private DataSource calcDatasource(DataSourceBase ds) {
        while (ds != null && ds instanceof DatasourceGroup) {
            if (((DatasourceGroup)ds).getCount() > 0) {
                ds = ((DatasourceGroup)ds).get(0);
                continue;
            }
            ds = null;
        }
        return (DataSource)ds;
    }

    private DataSource calcLeftDatasource() {
        DataSourceBase ds;
        int max = -1;
        for (int i = this.datasources.size() - 1; i >= 0; --i) {
            int cur;
            ds = (DataSourceBase)this.datasources.get(i);
            if (ds == this.datasourceOwner || (cur = this.datasourceGroup.indexOf(ds)) <= max) continue;
            max = cur;
        }
        ds = max >= 0 ? this.datasourceGroup.get(max) : (this.datasourceOwner != null ? this.datasourceGroup.get(this.datasourceGroup.indexOf(this.datasourceOwner) - 1) : null);
        if (ds != null) {
            return this.calcDatasource(ds);
        }
        return null;
    }

    private DataSource calcRightDatasource() {
        return this.calcDatasource(this.datasourceOwner);
    }

    protected void recalcSideDatasources() {
        if (!this.simple) {
            this.setLeftDatasource(this.calcLeftDatasource());
            this.setRightDatasource(this.calcRightDatasource());
        }
    }

    public void setLeftDatasource(DataSource datasource) {
        if (this.leftDatasource != datasource) {
            this.leftDatasource = datasource;
        }
    }

    public void setRightDatasource(DataSource datasource) {
        if (this.rightDatasource != datasource) {
            this.rightDatasource = datasource;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("remove")) {
            LinkDeletingEvent linkDeletingEvent = new LinkDeletingEvent(this.queryBuilder, this.getDatasourceGroup().getQuery(), this);
            this.queryBuilder.fireLinkDeletingEvent(linkDeletingEvent);
            if (!linkDeletingEvent.abort) {
                this.dispose();
            }
        } else if (action.equals("edit")) {
            this.editProps(SwingUtilities.getWindowAncestor(this.getQueryBuilder()));
        }
    }

    public void setLeftType(LinkSideType leftType) {
        switch (this.rightType) {
            case Inner: {
                if (leftType == LinkSideType.Inner) {
                    this.setJoinKindClass(SQLJoinKindInner.class);
                    break;
                }
                this.setJoinKindClass(SQLJoinKindLeft.class);
                break;
            }
            case Outer: {
                if (leftType == LinkSideType.Inner) {
                    this.setJoinKindClass(SQLJoinKindRight.class);
                    break;
                }
                this.setJoinKindClass(SQLJoinKindFull.class);
            }
        }
    }

    public void setRightType(LinkSideType rightType) {
        switch (this.leftType) {
            case Inner: {
                if (rightType == LinkSideType.Inner) {
                    this.setJoinKindClass(SQLJoinKindInner.class);
                    break;
                }
                this.setJoinKindClass(SQLJoinKindRight.class);
                break;
            }
            case Outer: {
                if (rightType == LinkSideType.Inner) {
                    this.setJoinKindClass(SQLJoinKindLeft.class);
                    break;
                }
                this.setJoinKindClass(SQLJoinKindFull.class);
            }
        }
    }

    protected void setOraclePlusForDatasource(DataSource datasource, boolean setPlus) {
        ArrayList l = new ArrayList();
        this.astLinkExpression.getReferencedColumnsRecursive(l);
        for (int i = 0; i < l.size(); ++i) {
            SQLObjectColumn c = (SQLObjectColumn)l.get(i);
            if (datasource != c.datasource.data) continue;
            c.outerJoin = setPlus;
        }
    }

    public boolean isSupportOuterJoins() {
        if (this.getSQLContext().getSyntaxProvider().isSupportANSIJoins()) {
            return true;
        }
        if (this.getSQLContext().getSyntaxProvider().isSupportOracleJoins()) {
            return true;
        }
        if (this.getSQLContext().getSyntaxProvider().isSupportTransactSQLJoins()) {
            SQLExpressionOperatorBinary eob = Helpers.expressionGetTompostBinaryOperator(this.astLinkExpression);
            return eob != null && eob.operatorObj != null && (eob.operatorObj.operatorName.equals("=") || eob.operatorObj.operatorName.equals("*=") || eob.operatorObj.operatorName.equals("=*"));
        }
        return false;
    }

    public boolean leftTypeSupportOuter() {
        return this.isSupportOuterJoins();
    }

    public boolean rightTypeSupportOuter() {
        return this.isSupportOuterJoins();
    }

    private MetadataRelation findRelationInternal(MetadataObject leftObject, MetadataObject rightObject, SQLQualifiedName leftField, SQLQualifiedName rightField) {
        for (int i = 0; i < leftObject.getRelations().getCount(); ++i) {
            MetadataField childMetadataField;
            MetadataRelation relation = leftObject.getRelations().get(i);
            MetadataTable childObject = this.getQueryBuilder().getMetadataContainer().findTableByFullName(relation.getChildTable());
            if (childObject != rightObject || relation.getKeyFields().getCount() != 1 || relation.getChildFields().getCount() != 1 || leftField.getCount() != 1 || !(leftField.get(0) instanceof AstTokenIdentifier) || rightField.getCount() != 1 || !(rightField.get(0) instanceof AstTokenIdentifier)) continue;
            int k = leftObject.getFields().findFieldByName(relation.getKeyFields().get(0));
            MetadataField keyMetadataField = k != -1 ? leftObject.getFields().get(k) : null;
            k = rightObject.getFields().findFieldByName(relation.getChildFields().get(0));
            MetadataField metadataField = childMetadataField = k != -1 ? rightObject.getFields().get(k) : null;
            if (keyMetadataField == null || childMetadataField == null || !this.getSQLContext().isQualifiedNamesEqual(keyMetadataField.getName(), leftField) && keyMetadataField.getAltName().compareToIgnoreCase(leftField.get(0).getToken()) != 0 || !this.getSQLContext().isQualifiedNamesEqual(childMetadataField.getName(), rightField) && childMetadataField.getAltName().compareToIgnoreCase(rightField.get(0).getToken()) != 0) continue;
            return relation;
        }
        return null;
    }

    public MetadataRelation getMetadataRelation() {
        MetadataRelation result = null;
        if (this.leftDatasource != null && this.leftField != null && this.rightDatasource != null && this.rightField != null) {
            MetadataObject leftObject = this.leftDatasource.getMetadataObject();
            MetadataObject rightObject = this.rightDatasource.getMetadataObject();
            if (leftObject != null && rightObject != null && (result = this.findRelationInternal(leftObject, rightObject, this.leftField, this.rightField)) == null) {
                result = this.findRelationInternal(rightObject, leftObject, this.rightField, this.leftField);
            }
        }
        return result;
    }

    public void refreshMetadata() {
        this.datasourceOwner.notifySQLUpdated();
    }
}

