/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLFromGroup;
import com.adbs.ast.SQLJoinKind;
import com.adbs.ast.SQLJoinKindCross;
import com.adbs.ast.SQLJoinKindFull;
import com.adbs.ast.SQLJoinKindInner;
import com.adbs.ast.SQLJoinKindLeft;
import com.adbs.ast.SQLJoinKindRight;
import com.adbs.querybuilder.DataSourceBase;
import com.adbs.querybuilder.DatasourceGroup;
import com.adbs.querybuilder.Link;
import com.adbs.querybuilder.LinkPlace;
import com.adbs.querybuilder.LinkSideType;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class DataSourcesSet {
    public ArrayList datasources = new ArrayList();
    public ArrayList links = new ArrayList();

    DataSourcesSet() {
    }

    public void loadAllLinkedForDatasource(DataSourceBase datasource, ArrayList datasources, ArrayList links) {
        datasources.remove(datasource);
        if (this.datasources.indexOf(datasource) == -1) {
            this.datasources.add(datasource);
        }
        int i = links.size() - 1;
        while (i >= 0) {
            Link l = (Link)links.get(i);
            if (datasources.size() == 1 && links.size() > 0 || l.datasources.indexOf(datasource) != -1 || this.datasources.indexOf(l.leftDatasource) != -1) {
                links.remove(i);
                this.links.add(l);
                for (int j = 0; j < l.datasources.size(); ++j) {
                    DataSourceBase ds = (DataSourceBase)l.datasources.get(j);
                    if (this.datasources.indexOf(ds) != -1) continue;
                    this.loadAllLinkedForDatasource(ds, datasources, links);
                }
            }
            if (i >= links.size()) {
                i = links.size() - 1;
                continue;
            }
            --i;
        }
    }

    public void reorderByTemplate(List datasources) {
        if (this.datasources.size() > 1) {
            int cur = 0;
            for (int i = 0; i < datasources.size() - 1; ++i) {
                int j = this.datasources.indexOf(datasources.get(i));
                if (j == -1) continue;
                if (j != cur) {
                    Helpers.listExchange(this.datasources, cur, j);
                }
                ++cur;
            }
        }
    }

    public void writeToGroup(DatasourceGroup group) throws QueryBuilderException {
        int i;
        ArrayList<DataSourceBase> dl = new ArrayList<DataSourceBase>();
        ArrayList<Link> ll = new ArrayList<Link>();
        assert (this.datasources.size() == 1 && this.links.size() == 0 || this.datasources.size() > 1 && this.links.size() > 0);
        while (this.datasources.size() > 0) {
            DataSourceBase ds;
            block22: {
                Constructor c;
                Class newType;
                for (i = 0; i < this.datasources.size() && !this.canAddDatasource((DataSourceBase)this.datasources.get(i), dl); ++i) {
                }
                if (i < this.datasources.size()) {
                    ds = (DataSourceBase)this.datasources.get(i);
                    newType = this.assignLinksToDatasource(ds, dl);
                    this.datasources.remove(i);
                } else {
                    ds = (DataSourceBase)this.datasources.get(0);
                    newType = ds.getSQLContext().getSyntaxProvider().isSupportCrossJoin() ? SQLJoinKindCross.class : null;
                    this.datasources.remove(0);
                }
                dl.add(ds);
                if (dl.size() == 1) {
                    ds.setFromSourceJoinKind(null);
                } else if (ds.getJoinKind() == null) {
                    try {
                        if (newType != null) {
                            c = newType.getConstructor(BaseSQLContext.class);
                            ds.setFromSourceJoinKind((SQLJoinKind)c.newInstance(group.getSQLContext()));
                            break block22;
                        }
                        ds.setFromSourceJoinKind(null);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DataSourcesSet.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else if (ds.getJoinKind().getClass() != newType) {
                    try {
                        if (newType != null) {
                            c = newType.getConstructor(BaseSQLContext.class);
                            SQLJoinKind newJoin = (SQLJoinKind)c.newInstance(group.getSQLContext());
                            newJoin.assign(ds.getJoinKind());
                            ds.setFromSourceJoinKind(newJoin);
                        } else {
                            ds.setFromSourceJoinKind(null);
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(DataSourcesSet.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            if (dl.size() <= 2 || !group.getSQLContext().getSyntaxProvider().isForceBinaryANSIJoins()) continue;
            while (dl.size() > 2) {
                ds = (DataSourceBase)dl.get(0);
                DataSourceBase ds2 = (DataSourceBase)dl.get(1);
                DatasourceGroup newGroup = new DatasourceGroup(group.getFromClause(), group, group.getQueryBuilder());
                group.extractInternal(newGroup);
                newGroup.astFromSource = new SQLFromGroup(group.getSQLContext());
                ds.setGroup(newGroup);
                ds2.setGroup(newGroup);
                dl.set(0, newGroup);
                dl.remove(1);
                ll.clear();
                for (i = 0; i < group.getLinkCount(); ++i) {
                    Link l = group.links.get(i);
                    if (l.datasources.size() == 1 && l.datasources.get(0) == ds2 || l.isSimple() && l.datasources.size() == 2 && l.datasources.indexOf(ds) != -1 && l.datasources.indexOf(ds2) != -1) {
                        ll.add(l);
                        continue;
                    }
                    l.moveDatasourceIntoGroup(ds, newGroup);
                    l.moveDatasourceIntoGroup(ds2, newGroup);
                }
                for (i = 0; i < ll.size(); ++i) {
                    ((Link)ll.get(i)).setDatasourceGroup(newGroup);
                }
            }
        }
        for (i = 0; i < dl.size(); ++i) {
            ((DataSourceBase)dl.get(i)).destroyCachedResultASTs();
            group.addInternal((DataSourceBase)dl.get(i));
        }
    }

    public boolean canAddDatasource(DataSourceBase datasource, List datasources) {
        boolean result = datasources.size() == 0;
        LinkSideType clt = LinkSideType.Inner;
        LinkSideType crt = LinkSideType.Inner;
        Link comp = null;
        for (int i = 0; i < this.links.size(); ++i) {
            Link l = (Link)this.links.get(i);
            if (!this.isLinkMine(l, datasource, datasources)) continue;
            if (datasources.size() == 0) {
                return false;
            }
            result = true;
            if (l.newFlag) continue;
            if (comp == null) {
                comp = l;
                if (comp.getDatasourceOwner() == datasource || comp.isSimple() && datasource.containsDatasource(comp.getRightDatasource(), true)) {
                    clt = comp.getLeftType();
                    crt = comp.getRightType();
                    continue;
                }
                crt = comp.getLeftType();
                clt = comp.getRightType();
                continue;
            }
            if (l.getPlace() != LinkPlace.From) continue;
            if (l.getDatasourceOwner() == datasource) {
                result = l.getLeftType() == clt && l.getRightType() == crt;
            } else {
                boolean bl = result = l.getLeftType() == crt && l.getRightType() == clt;
            }
            if (result) continue;
            return false;
        }
        return result;
    }

    public boolean isLinkMine(Link link, DataSourceBase datasource, List datasources) {
        boolean result;
        ArrayList dsl = new ArrayList();
        if (link.isSimple() && datasource.containsDatasource(link.getRightDatasource(), true) || datasource.containsDatasource(link.getLeftDatasource(), true) || !link.isSimple() && link.getDatasourceOwner() == datasource) {
            Helpers.listAssign(dsl, link.datasources, Helpers.ListAssignOp.Copy, null);
            Helpers.listAssign(dsl, datasources, Helpers.ListAssignOp.SrcUnique, null);
            result = dsl.size() == 1 && dsl.get(0) == datasource;
        } else {
            result = false;
        }
        return result;
    }

    public Class assignLinksToDatasource(DataSourceBase datasource, List datasources) {
        LinkSideType lt = LinkSideType.Inner;
        LinkSideType rt = LinkSideType.Inner;
        boolean linksFound = false;
        for (int i = this.links.size() - 1; i >= 0; --i) {
            Link l = (Link)this.links.get(i);
            if (!this.isLinkMine(l, datasource, datasources)) continue;
            linksFound = true;
            this.links.remove(i);
            lt = l.getLeftType();
            rt = l.getRightType();
            if (!l.isSimple() || l.getDatasourceOwner() == datasource) continue;
            l.flipLink();
        }
        Class result = linksFound ? (lt == LinkSideType.Inner ? (rt == LinkSideType.Inner ? SQLJoinKindInner.class : SQLJoinKindRight.class) : (rt == LinkSideType.Inner ? SQLJoinKindLeft.class : SQLJoinKindFull.class)) : (datasource.getQueryBuilder().getSyntaxProvider().isSupportCrossJoin() ? SQLJoinKindCross.class : null);
        return result;
    }

    public void moveToParentGroup(DatasourceGroup group) throws QueryBuilderException {
        DatasourceGroup fromGroup = group;
        DatasourceGroup toGroup = group.getGroup();
        int index = toGroup.indexOf(fromGroup) + 1;
        for (int i = this.datasources.size() - 1; i >= 0; --i) {
            DataSourceBase ds = (DataSourceBase)this.datasources.get(i);
            ds.setGroup(toGroup);
            if (toGroup.indexOf(ds) != index) {
                toGroup.extractInternal(ds);
                toGroup.insertInternal(index, ds);
            }
            for (int iLink = 0; iLink < toGroup.getLinkCount(); ++iLink) {
                Link l = toGroup.links.get(iLink);
                if (l.datasources.indexOf(fromGroup) == -1) continue;
                if (l.getDatasourceOwner() == fromGroup) {
                    l.datasourceOwner = ds;
                }
                l.recalcSameLevelDatasources(l.datasourceOwner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFromChild(DatasourceGroup group) throws QueryBuilderException {
        DatasourceGroup fromGroup = (DatasourceGroup)this.datasources.get(0);
        DatasourceGroup toGroup = group;
        this.datasources.clear();
        fromGroup.beginUpdate();
        try {
            while (fromGroup.getCount() > 0) {
                DataSourceBase ds = fromGroup.items.get(0);
                ds.setGroup(toGroup);
                this.datasources.add(ds);
            }
            while (fromGroup.getLinkCount() > 0) {
                Link l = fromGroup.links.get(0);
                l.setDatasourceGroup(toGroup);
                this.links.add(l);
            }
        }
        finally {
            fromGroup.endUpdate();
        }
        fromGroup.dispose();
    }
}

