/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.querybuilder;

import com.adbs.ast.AstNode;
import com.adbs.ast.BuildSQLForNodeEventListener;
import com.adbs.ast.IdentQuotation;
import com.adbs.ast.KeywordFormat;
import com.adbs.ast.ObjectPrefixSkipping;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLSelectStatement;
import com.adbs.ast.SkipKeywordMode;
import com.adbs.ast.UpdatedEvent;
import com.adbs.ast.UpdatedEventListener;
import com.adbs.querybuilder.ActiveSubQueryChangedEvent;
import com.adbs.querybuilder.ActiveSubQueryChangedEventListener;
import com.adbs.querybuilder.ActiveUnionSubQueryChangedEvent;
import com.adbs.querybuilder.ActiveUnionSubQueryChangedEventListener;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.querybuilder.QueryPart;
import com.adbs.querybuilder.QuoteAllIdentifiers;
import com.adbs.querybuilder.SQLUpdatedEvent;
import com.adbs.querybuilder.SQLUpdatedEventListener;
import com.adbs.utils.Helpers;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;

public class BaseSQLBuilder
extends Component
implements UpdatedEventListener,
ActiveUnionSubQueryChangedEventListener,
ActiveSubQueryChangedEventListener,
SQLUpdatedEventListener {
    private static final long serialVersionUID = 1L;
    private SQLBuilder builder;
    private QueryBuilder queryBuilder;
    private QueryPart targetQueryPart = QueryPart.Query;
    private QuoteAllIdentifiers quoteAllIdentifiers = QuoteAllIdentifiers.AsInQueryBuilder;
    protected ArrayList<SQLUpdatedEventListener> updatedEventListenerList = new ArrayList();

    public BaseSQLBuilder() {
        this.builder = this.createSQLBuilder();
        this.builder.addUpdatedEventListener(this);
    }

    public String getSQL() throws QueryBuilderException {
        if (this.queryBuilder != null && this.queryBuilder.getSyntaxProvider() != null) {
            if (!this.queryBuilder.isSleepMode()) {
                AstNode ast;
                switch (this.targetQueryPart) {
                    case Query: {
                        SQLSelectStatement queryAst = this.queryBuilder.getResultQueryAST();
                        if (Helpers.isQueryEmpty(queryAst)) {
                            queryAst = null;
                        }
                        ast = queryAst;
                        break;
                    }
                    case SubQuery: {
                        ast = this.queryBuilder.getActiveSubquery().getResultASTInternal();
                        break;
                    }
                    case UnionSubQuery: {
                        ast = this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().getResultASTInternal();
                        break;
                    }
                    default: {
                        ast = null;
                    }
                }
                if (ast != null) {
                    this.builder.beginBuild();
                    try {
                        ast.buildSQL(this.builder, this.builder.getMainQueryFormat());
                    }
                    finally {
                        this.builder.endBuild();
                    }
                    return this.builder.getResult();
                }
                return "";
            }
            return this.queryBuilder.getSQL();
        }
        return "";
    }

    public void setSQL(String value) {
        if (this.queryBuilder == null) {
            throw new QueryBuilderException("BaseSqlBuilder.QueryBuilder property is not assigned");
        }
        if (!this.queryBuilder.isSleepMode()) {
            switch (this.targetQueryPart) {
                case Query: {
                    this.queryBuilder.setSQL(value);
                    break;
                }
                case SubQuery: {
                    this.queryBuilder.getActiveSubquery().setSQL(value);
                    break;
                }
                case UnionSubQuery: {
                    this.queryBuilder.getActiveSubquery().getActiveUnionSubquery().setSQL(value);
                }
            }
        } else {
            this.queryBuilder.setSQL(value);
        }
    }

    public SQLBuilder getSQLBuilder() {
        return this.builder;
    }

    public boolean isUpdating() {
        return this.builder.isUpdating();
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(QueryBuilder value) {
        if (this.queryBuilder != value) {
            if (this.queryBuilder != null) {
                this.queryBuilder.removeActiveUnionSubQueryChangedEventListener(this);
                this.queryBuilder.removeActiveSubQueryChangedEventListener(this);
                this.queryBuilder.removeSQLUpdatedEventListener(this);
            }
            this.queryBuilder = value;
            if (this.queryBuilder != null) {
                this.queryBuilder.addSQLUpdatedEventListener(this);
                this.queryBuilder.addActiveSubQueryChangedEventListener(this);
                this.queryBuilder.addActiveUnionSubQueryChangedEventListener(this);
                this.onSQLUpdated();
            }
        }
    }

    public int getRightMargin() {
        return this.builder.getRightMargin();
    }

    public void setRightMargin(int value) {
        this.builder.setRightMargin(value);
    }

    public KeywordFormat getKeywordFormat() {
        return this.builder.getKeywordFormat();
    }

    public void setKeywordFormat(KeywordFormat value) {
        this.builder.setKeywordFormat(value);
    }

    public QuoteAllIdentifiers getQuoteAllIdentifiers() {
        if (this.queryBuilder != null && this.quoteAllIdentifiers == QuoteAllIdentifiers.AsInQueryBuilder) {
            this.builder.setQuoteIdentifiers(this.queryBuilder.getQuoteAllIdentifiersInternal());
        }
        return this.quoteAllIdentifiers;
    }

    public void setQuoteAllIdentifiers(QuoteAllIdentifiers value) {
        this.quoteAllIdentifiers = value;
        if (this.quoteAllIdentifiers == QuoteAllIdentifiers.AsInQueryBuilder) {
            this.builder.setQuoteIdentifiers(this.queryBuilder.getQuoteAllIdentifiersInternal());
        } else if (this.quoteAllIdentifiers == QuoteAllIdentifiers.Yes) {
            this.builder.setQuoteIdentifiers(IdentQuotation.All);
        } else {
            this.builder.setQuoteIdentifiers(IdentQuotation.IfNeed);
        }
    }

    public ObjectPrefixSkipping getObjectPrefixSkipping() {
        return this.builder.getObjectPrefixSkipping();
    }

    public void setObjectPrefixSkipping(ObjectPrefixSkipping value) {
        this.builder.setObjectPrefixSkipping(value);
    }

    public SQLBuilderSelectFormat getMainQueryFormat() {
        return this.builder.getMainQueryFormat();
    }

    public void setMainQueryFormat(SQLBuilderSelectFormat value) {
        this.builder.setMainQueryFormat(value);
    }

    public SQLBuilderSelectFormat getExpressionSubqueryFormat() {
        return this.builder.getExpressionsSubQueryFormat();
    }

    public void setExpressionSubqueryFormat(SQLBuilderSelectFormat value) {
        this.builder.setExpressionsSubQueryFormat(value);
    }

    public SQLBuilderSelectFormat getDerievedQueryFormat() {
        return this.builder.getFromSubQueryFormat();
    }

    public void setDerievedQueryFormat(SQLBuilderSelectFormat value) {
        this.builder.setFromSubQueryFormat(value);
    }

    public SQLBuilderSelectFormat getCTESubQueryFormat() {
        return this.builder.getCTESubQueryFormat();
    }

    public void setCTESubQueryFormat(SQLBuilderSelectFormat value) {
        this.builder.setCTESubQueryFormat(value);
    }

    public boolean isUseAltNames() {
        return this.builder.isUseAltNames();
    }

    public void setUseAltNames(boolean value) {
        this.builder.setUseAltNames(value);
    }

    public SkipKeywordMode getOuterKeywordInLinks() {
        return this.builder.getOuterKeywordInLinks();
    }

    public void setOuterKeywordInLinks(SkipKeywordMode value) {
        this.builder.setOuterKeywordInLinks(value);
    }

    public SkipKeywordMode getInnerKeywordInLinks() {
        return this.builder.getInnerKeywordInLinks();
    }

    public void setInnerKeywordInLinks(SkipKeywordMode value) {
        this.builder.setInnerKeywordInLinks(value);
    }

    public boolean isParenthesizeANDGroups() {
        return this.builder.isParenthesizeANDGroups();
    }

    public void setParenthesizeANDGroups(boolean value) {
        this.builder.setParenthesizeANDGroups(value);
    }

    public boolean isParenthesizeSingleCriterion() {
        return this.builder.isParenthesizeSingleCriterion();
    }

    public void setParenthesizeSingleCriterion(boolean value) {
        this.builder.setParenthesizeSingleCriterion(value);
    }

    @Override
    public void updatedEventOccurred(UpdatedEvent event) {
        this.onSQLUpdated();
    }

    public void onSQLUpdated() {
        if (this.quoteAllIdentifiers == QuoteAllIdentifiers.AsInQueryBuilder && this.queryBuilder != null) {
            this.builder.setQuoteIdentifiers(this.queryBuilder.getQuoteAllIdentifiersInternal());
        } else if (this.quoteAllIdentifiers == QuoteAllIdentifiers.Yes) {
            this.builder.setQuoteIdentifiers(IdentQuotation.All);
        } else {
            this.builder.setQuoteIdentifiers(IdentQuotation.IfNeed);
        }
        this.fireSQLUpdatedEvent(new SQLUpdatedEvent(this));
    }

    public void beginUpdate() {
        this.builder.beginUpdate();
    }

    public void endUpdate() {
        this.builder.endUpdate();
    }

    protected SQLBuilder createSQLBuilder() {
        return null;
    }

    public void addSQLUpdatedEventListener(SQLUpdatedEventListener listener) {
        this.updatedEventListenerList.add(listener);
    }

    public void removeSQLUpdatedEventListener(SQLUpdatedEventListener listener) {
        this.updatedEventListenerList.remove(listener);
    }

    protected void fireSQLUpdatedEvent(SQLUpdatedEvent evt) {
        Iterator<SQLUpdatedEventListener> listeners = this.updatedEventListenerList.iterator();
        while (listeners.hasNext()) {
            listeners.next().sqlUpdatedEventOccurred(evt);
        }
    }

    public SkipKeywordMode getAsKeywordInExpressionAlias() {
        return this.builder.getAsKeywordInExpressionAlias();
    }

    public void setAsKeywordInExpressionAlias(SkipKeywordMode value) {
        this.builder.setAsKeywordInExpressionAlias(value);
    }

    public SkipKeywordMode getAsKeywordInObjectAlias() {
        return this.builder.getAsKeywordInObjectAlias();
    }

    public void setAsKeywordInObjectAlias(SkipKeywordMode value) {
        this.builder.setAsKeywordInObjectAlias(value);
    }

    public boolean isExpandVirtualFields() {
        return this.builder.isExpandVirtualFields();
    }

    public void setExpandVirtualFields(boolean value) {
        this.builder.setExpandVirtualFields(value);
    }

    public boolean isExpandVirtualObjects() {
        return this.builder.isExpandVirtualObjects();
    }

    public void setExpandVirtualObjects(boolean value) {
        this.builder.setExpandVirtualObjects(value);
    }

    public void addBeginBuildSQLForNodeEventListener(BuildSQLForNodeEventListener listener) {
        this.builder.addBeginBuildSQLForNodeEventListener(listener);
    }

    public void removeBeginBuildSQLForNodeEventListener(BuildSQLForNodeEventListener listener) {
        this.builder.removeBeginBuildSQLForNodeEventListener(listener);
    }

    public void addEndBuildSQLForNodeEventListener(BuildSQLForNodeEventListener listener) {
        this.builder.addEndBuildSQLForNodeEventListener(listener);
    }

    public void removeEndBuildSQLForNodeEventListener(BuildSQLForNodeEventListener listener) {
        this.builder.removeEndBuildSQLForNodeEventListener(listener);
    }

    public QueryPart getTargetQueryPart() {
        return this.targetQueryPart;
    }

    public void setTargetQueryPart(QueryPart value) {
        if (this.targetQueryPart != value) {
            this.targetQueryPart = value;
            this.onSQLUpdated();
        }
    }

    @Override
    public void activeUnionSubQueryChangedEventOccurred(ActiveUnionSubQueryChangedEvent event) {
        if (this.targetQueryPart == QueryPart.UnionSubQuery) {
            this.onSQLUpdated();
        }
    }

    @Override
    public void activeSubQueryChangedEventOccurred(ActiveSubQueryChangedEvent event) {
        if (this.targetQueryPart == QueryPart.SubQuery) {
            this.onSQLUpdated();
        }
    }

    @Override
    public void sqlUpdatedEventOccurred(SQLUpdatedEvent event) {
        this.onSQLUpdated();
    }
}

