/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.metadata;

import com.adbs.ast.AstNode;
import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataBase;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataFilter;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataSynonym;
import com.adbs.ast.SQLIdentifiersCollection;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.QueryBuilderException;
import com.adbs.utils.Helpers;
import com.adbs.utils.Str;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BaseMetadataObjectsFetcher
implements Disposable {
    protected BaseSQLContext sqlContext;
    private MetadataFilter metadataFilter;
    private MetadataContainer metadataContainer;
    private Class defaultObjectClass;
    private boolean trimSpaces;
    private SQLIdentifiersCollection systemSchemaNames;

    public BaseMetadataObjectsFetcher(BaseSQLContext sqlContext) {
        this.sqlContext = sqlContext;
        this.systemSchemaNames = new SQLIdentifiersCollection(sqlContext);
    }

    @Override
    public void dispose() {
        this.systemSchemaNames.dispose();
    }

    public BaseSQLContext getSqlContext() {
        return this.sqlContext;
    }

    public MetadataFilter getMetadataFilter() {
        return this.metadataFilter;
    }

    public void setMetadataFilter(MetadataFilter value) {
        this.metadataFilter = value;
    }

    public MetadataContainer getMetadataContainer() {
        return this.metadataContainer;
    }

    public Class getDefaultObjectClass() {
        return this.defaultObjectClass;
    }

    public void setDefaultObjectClass(Class defaultObjectClass) {
        this.defaultObjectClass = defaultObjectClass;
    }

    public boolean getTrimSpaces() {
        return this.trimSpaces;
    }

    public void setTrimSpaces(boolean trimSpaces) {
        this.trimSpaces = trimSpaces;
    }

    public SQLIdentifiersCollection getSystemSchemaNames() {
        return this.systemSchemaNames;
    }

    public void setSystemSchemaNames(SQLIdentifiersCollection systemSchemaNames) {
        if (this.systemSchemaNames != systemSchemaNames) {
            this.systemSchemaNames.assign(systemSchemaNames);
        }
    }

    protected void init() throws QueryBuilderException {
    }

    protected boolean next() throws QueryBuilderException {
        return false;
    }

    protected void close() {
    }

    protected Class calcMetadataObjectClass() {
        return this.defaultObjectClass;
    }

    protected boolean calcSystemFlag() {
        return false;
    }

    protected void calcObjectName(AstTokenIdentifier schema, AstTokenIdentifier name) {
        schema.setToken("");
        name.setToken("");
    }

    protected void calcReferencedObjectName(SQLQualifiedName database, AstTokenIdentifier schema, AstTokenIdentifier name) {
        database.clear();
        schema.setToken("");
        name.setToken("");
    }

    protected String trimName(String name) {
        if (this.trimSpaces) {
            return name.trim();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMetadata(MetadataContainer metadataContainer, MetadataFilter metadataFilter, SQLQualifiedName database) throws QueryBuilderException {
        AstTokenIdentifier sch = null;
        AstNode nm = null;
        MetadataObject mo = null;
        this.metadataFilter = metadataFilter;
        this.metadataContainer = metadataContainer;
        metadataContainer.beginUpdate();
        try {
            if (this.sqlContext.getSyntaxProvider().isSupportDatabases() && Helpers.isQualifiedNameEmpty(database)) {
                database = metadataContainer.getDefaultDatabaseName();
            }
            this.init();
            try {
                sch = new AstTokenIdentifier(this.sqlContext);
                nm = new AstTokenIdentifier(this.sqlContext);
                AstTokenIdentifier emptySchemaName = this.sqlContext.getSyntaxProvider().getEmptySchemaName(this.sqlContext);
                while (this.next()) {
                    Class moc = this.calcMetadataObjectClass();
                    if (moc == null) continue;
                    boolean sf = this.calcSystemFlag();
                    sch.setToken("");
                    sch.setCaseSensitive(this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
                    ((AstTokenIdentifier)nm).setToken("");
                    ((AstTokenIdentifier)nm).setCaseSensitive(this.sqlContext.getSyntaxProvider().isIdentifiersCaseSensitive());
                    this.calcObjectName(sch, (AstTokenIdentifier)nm);
                    if (!sf && this.sqlContext.getSyntaxProvider().isSupportSchemas() && !sch.isEmpty() && this.systemSchemaNames.getCount() > 0) {
                        sf = this.systemSchemaNames.containsSameId(sch);
                    }
                    if (Str.IsNullOrEmpty(((AstToken)nm).getToken())) continue;
                    try {
                        Constructor c = moc.getConstructor(MetadataBase.class, BaseSQLContext.class);
                        mo = (MetadataObject)c.newInstance(metadataContainer, this.sqlContext);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(BaseMetadataObjectsFetcher.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    try {
                        if (emptySchemaName != null && !sch.isEmpty() && this.sqlContext.isIdentifiersEqual(emptySchemaName, sch)) {
                            sch.clear();
                        }
                        mo.setDatabase(database);
                        mo.setSchema(sch);
                        mo.setName((AstTokenIdentifier)nm);
                        mo.setSystem(sf);
                        mo.setShortDescription(this.getShortDescription());
                        mo.setLongDescription(this.getLongDescription());
                        if (metadataFilter != null && !metadataFilter.filterMetadataObject(mo)) continue;
                        metadataContainer.add(mo);
                        if (mo instanceof MetadataSynonym) {
                            this.calcReferencedObjectName(((MetadataSynonym)mo).getReferencedDatabase(), ((MetadataSynonym)mo).getReferencedSchema(), ((MetadataSynonym)mo).getReferencedName());
                            if (Helpers.isQualifiedNameEmpty(((MetadataSynonym)mo).getReferencedDatabase())) {
                                ((MetadataSynonym)mo).setReferencedDatabase(database);
                            }
                            if (!((MetadataSynonym)mo).getReferencedSchema().isEmpty() && emptySchemaName != null && this.sqlContext.isIdentifiersEqual(emptySchemaName, ((MetadataSynonym)mo).getReferencedSchema())) {
                                ((MetadataSynonym)mo).getReferencedSchema().clear();
                            }
                            ((MetadataSynonym)mo).updateReferencedFullName();
                            if (!mo.isSystem() && this.sqlContext.getSyntaxProvider().isSupportSchemas() && !((MetadataSynonym)mo).getReferencedSchema().isEmpty() && this.systemSchemaNames.getCount() > 0) {
                                mo.setSystem(this.systemSchemaNames.containsSameId(((MetadataSynonym)mo).getReferencedSchema()));
                            }
                        }
                        try {
                            mo.setVisible(metadataContainer.isMetadataObjectVisible(mo));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        mo = null;
                    }
                    finally {
                        if (mo == null) continue;
                        mo.dispose();
                    }
                }
                this.close();
                if (emptySchemaName != null) {
                    emptySchemaName.dispose();
                }
                try {
                    if (metadataContainer.isOfflineMode()) {
                        mo.loadFields();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                if (nm != null) {
                    nm.dispose();
                }
                if (sch != null) {
                    sch.dispose();
                }
                this.close();
            }
        }
        finally {
            metadataContainer.endUpdate();
        }
    }

    public String getShortDescription() {
        return "";
    }

    public String getLongDescription() {
        return "";
    }
}

