/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.Disposable;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.SQLAliasObjectAlias;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.ast.StatsObject;
import com.adbs.utils.Helpers;
import java.util.ArrayList;
import java.util.Iterator;

public class StatsObjects
implements Disposable,
Iterable<StatsObject> {
    private BaseSQLContext sqlContext;
    private final ArrayList<StatsObject> items = new ArrayList();

    public StatsObjects(BaseSQLContext sqlContext) {
        this.sqlContext = sqlContext;
    }

    @Override
    public void dispose() {
        this.clear();
    }

    public int getCount() {
        return this.items.size();
    }

    public StatsObject get(int index) {
        return this.items.get(index);
    }

    private StatsObject findObject(MetadataObject metadataObject, SQLQualifiedName name) {
        StatsObject result;
        if (metadataObject != null) {
            for (int i = 0; i < this.getCount(); ++i) {
                result = this.items.get(i);
                if (result.getMetadataObject() != metadataObject) continue;
                return result;
            }
            result = null;
        } else {
            assert (this.sqlContext.getSyntaxProvider() != null);
            for (int i = 0; i < this.getCount(); ++i) {
                result = this.items.get(i);
                if (result.getMetadataObject() != null || !this.sqlContext.isQualifiedNamesEqual(result.getName(), name)) continue;
                return result;
            }
            result = null;
        }
        return result;
    }

    public void assign(Object source) {
        if (source instanceof StatsObjects) {
            this.clear();
            for (int i = 0; i < ((StatsObjects)source).getCount(); ++i) {
                StatsObject o = ((StatsObjects)source).get(i);
                this.addObject(o.getMetadataObject(), o.getName());
            }
        }
    }

    public StatsObject addObject(MetadataObject metadataObject, SQLQualifiedName name) {
        StatsObject result = new StatsObject(this.sqlContext, metadataObject, name);
        this.items.add(result);
        return result;
    }

    public int addObjectIfNotExists(MetadataObject metadataObject, SQLQualifiedName name, SQLAliasObjectAlias alias) {
        int result;
        assert (!Helpers.isQualifiedNameEmpty(name));
        StatsObject so = this.findObject(metadataObject, name);
        if (so == null) {
            so = this.addObject(metadataObject, name);
            result = 1;
        } else {
            result = 0;
        }
        if (alias != null && alias.alias != null && !alias.alias.isEmpty() && so.getAliases().findByIdToken(alias.alias) == -1) {
            so.getAliases().add(alias.alias.clone(this.sqlContext));
        }
        return result;
    }

    public int addObjects(StatsObjects statsObjects) {
        int result = 0;
        if (statsObjects == null) {
            return 0;
        }
        for (int i = 0; i < statsObjects.getCount(); ++i) {
            StatsObject srco = statsObjects.get(i);
            StatsObject dsto = this.findObject(srco.getMetadataObject(), srco.getName());
            if (dsto == null) {
                dsto = this.addObject(srco.getMetadataObject(), srco.getName());
                ++result;
            }
            for (int j = 0; j < srco.getAliases().getCount(); ++j) {
                if (dsto.getAliases().findByIdToken(srco.getAliases().get(j)) != -1) continue;
                dsto.getAliases().add(srco.getAliases().get(j).clone(this.sqlContext));
            }
        }
        return result;
    }

    public void clear() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).dispose();
        }
        this.items.clear();
    }

    @Override
    public Iterator<StatsObject> iterator() {
        return this.items.iterator();
    }
}

