/*
 * Decompiled with CFR 0.152.
 */
package com.adbs.ast;

import com.adbs.ast.AstNode;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.SQLBuilder;
import com.adbs.ast.SQLBuilderSelectFormat;
import com.adbs.ast.SQLSubQueryExpression;
import com.adbs.ast.SQLSubQuerySelectExpression;
import java.util.ArrayList;
import java.util.List;

public class SQLSubQueryExpressions
extends SQLSubQueryExpression {
    private ArrayList<SQLSubQueryExpression> expressions = new ArrayList();

    public SQLSubQueryExpressions(BaseSQLContext sqlContext) {
        super(sqlContext);
    }

    public int getCount() {
        return this.expressions.size();
    }

    public SQLSubQueryExpression get(int index) {
        return this.expressions.get(index);
    }

    @Override
    public void assign(Object source) {
        super.assign(source);
        if (source instanceof SQLSubQueryExpressions) {
            this.clear();
            for (int i = 0; i < ((SQLSubQueryExpressions)source).getCount(); ++i) {
                this.add((SQLSubQueryExpression)((SQLSubQueryExpressions)source).get(i).clone(this.sqlContext));
            }
        }
    }

    @Override
    public void getMyChildren(List l) {
        super.getMyChildren(l);
        int index = this.findFirstChildIndexForClass(SQLSubQueryExpressions.class);
        for (int i = this.getCount() - 1; i >= 0; --i) {
            l.add(index, this.get(i));
        }
    }

    private void buildItemSQL(SQLBuilder builder, SQLBuilderSelectFormat format, SQLSubQueryExpression item) {
        if (item instanceof SQLSubQueryExpressions) {
            builder.writeSymbol("(");
        }
        item.buildSQL(builder, format);
        if (item instanceof SQLSubQueryExpressions) {
            builder.writeSymbol(")");
        }
    }

    @Override
    public void buildSQLDirect(SQLBuilder builder, SQLBuilderSelectFormat format) {
        if (this.getCount() > 0) {
            this.buildItemSQL(builder, format, this.get(0));
        }
        for (int i = 1; i < this.getCount(); ++i) {
            builder.newLineOrSpace(format.getMainPartsFromNewLine());
            this.get(i).buildUnionOperator(builder, format);
            builder.newLineOrSpace(format.getMainPartsFromNewLine());
            this.buildItemSQL(builder, format, this.get(i));
        }
    }

    public int add(SQLSubQueryExpression subExpression) {
        this.expressions.add(subExpression);
        return this.expressions.size() - 1;
    }

    public int remove(AstNode item) {
        int x = this.expressions.indexOf(item);
        if (x != -1) {
            this.expressions.remove(x);
            if (item != null) {
                item.dispose();
            }
        }
        return x;
    }

    public void delete(int index) {
        SQLSubQueryExpression n = this.get(index);
        if (n != null) {
            n.dispose();
        }
        this.expressions.remove(index);
    }

    public SQLSubQueryExpression extract(SQLSubQueryExpression item) {
        int itemIndex = this.expressions.indexOf(item);
        if (itemIndex == -1) {
            return null;
        }
        SQLSubQueryExpression expr = this.expressions.get(itemIndex);
        this.expressions.remove(item);
        return expr;
    }

    public SQLSubQueryExpression extract(int index) {
        SQLSubQueryExpression item = this.expressions.get(index);
        this.expressions.remove(index);
        return item;
    }

    public void clear() {
        for (int i = 0; i < this.getCount(); ++i) {
            this.get(i).dispose();
        }
        this.expressions.clear();
    }

    public SQLSubQuerySelectExpression firstUnionSubQuery() {
        SQLSubQuerySelectExpression result = null;
        for (int i = 0; i < this.getCount(); ++i) {
            SQLSubQueryExpression sq = this.get(i);
            if (sq instanceof SQLSubQueryExpressions) {
                result = ((SQLSubQueryExpressions)sq).firstUnionSubQuery();
                if (result == null) continue;
                return result;
            }
            return (SQLSubQuerySelectExpression)sq;
        }
        return result;
    }
}

